/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.swing;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.high_d.axis.Alignment;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinates;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesModel;
import com.macrofocus.high_d.swing.SwingHighDFactory;
import com.macrofocus.high_d.tablelens.TableLens;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.java.JavaDataFrameFactory;
import com.macrofocus.order.MutableVisibleOrder;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class SwingApplication {
    public SwingApplication() {
        DataFrame dataFrame = JavaDataFrameFactory.getInstance().createRandomDataFrame(4, 100000, 10);
        SwingHighDFactory factory = new SwingHighDFactory(dataFrame);
        ParallelCoordinates parallelCoordinates = factory.createParallelCoordinates();
        MutableVisibleOrder axisOrder = ((AxisGroupModel)parallelCoordinates.getModel().getAxisHierarchy().getAxisGroupHierarchy().getRoot()).getAxisOrder();
        for (AxisModel axisModel : axisOrder.iterableAll()) {
            axisOrder.setVisible((Object)axisModel, true);
        }
        ParallelCoordinatesModel model = parallelCoordinates.getModel();
        parallelCoordinates.getView().getRendering().setValue((Object)CPCanvas.Rendering.Density);
        parallelCoordinates.getView().setShowTiming(true);
        parallelCoordinates.getView().getAlignment().setValue((Object)Alignment.Center);
        TableLens tableLens = factory.createTableLens();
        tableLens.getModel().setOrder((AxisModel)tableLens.getModel().getAxisGroupModel().getAxisOrder().get(3));
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.add("Parallel Coordinates", (Component)parallelCoordinates.getNativeComponent());
        tabPane.add("TableLens", (Component)tableLens.getNativeComponent());
        ApplicationModel applicationModel = ApplicationModelFactory.HIGHD_API_V1;
        JFrame frame = new JFrame();
        frame.setTitle(applicationModel.getName() + " " + applicationModel.getVersion() + ", Copyright (c) " + applicationModel.getCopyright() + " " + applicationModel.getEdition());
        frame.setSize(800, 400);
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout());
        pane.add((Component)tabPane, "Center");
        frame.getContentPane().add(pane);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        new SwingApplication();
    }
}

