/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.table.swing;

import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.DataFrameEvent;
import com.macrofocus.molap.dataframe.DataFrameListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class DataFrameTableModel<R, C, V>
implements TableModel {
    private final DataFrame<R, C, V> dataFrame;
    protected List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private final DataFrameListener dataFrameListener = new DataFrameListener(){

        public void dataFrameChanged(final DataFrameEvent event) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (event.isStructureChanged()) {
                        DataFrameTableModel.this.fireTableStructureChanged();
                    } else {
                        DataFrameTableModel.this.fireTableDataChanged();
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    };

    public DataFrameTableModel(DataFrame<R, C, V> dataFrame) {
        this.dataFrame = dataFrame;
        dataFrame.addWeakDataFrameListener(this.dataFrameListener);
    }

    @Override
    public String getColumnName(int column) {
        Object columnKey = this.dataFrame.getColumnKey(column);
        if (columnKey != null) {
            return columnKey.toString();
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.dataFrame.getColumnClass(this.dataFrame.getColumnKey(columnIndex));
    }

    @Override
    public int getRowCount() {
        return this.dataFrame.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.dataFrame.getColumnCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.dataFrame.getValueAt(this.dataFrame.getRowKey(rowIndex), this.dataFrame.getColumnKey(columnIndex));
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    protected void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    protected void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public void fireTableChanged(TableModelEvent e) {
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(e);
        }
    }
}

