/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.tablelens.swing;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.swing.SwingColorMapFactory;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.helper.TableHelper;
import com.macrofocus.high_d.tablelens.AbstractTableLens;
import com.macrofocus.high_d.tablelens.DefaultTableLensModel;
import com.macrofocus.high_d.tablelens.TableLensController;
import com.macrofocus.high_d.tablelens.TableLensModel;
import com.macrofocus.high_d.tablelens.TableLensView;
import com.macrofocus.high_d.tablelens.swing.SwingTableLensController;
import com.macrofocus.high_d.tablelens.swing.SwingTableLensView;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.colortheme.LightColorTheme;
import com.macrofocus.license.SimpleLicenseModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.java.TableModelDataFrame;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.OverlayLayout;
import javax.swing.table.TableModel;

public class SwingTableLens<Row, Column>
extends AbstractTableLens<JComponent, Color, Row, Column> {
    private final JComponent nativeComponent = new JComponent(){};

    public SwingTableLens() {
        this.nativeComponent.setLayout(new OverlayLayout(this.nativeComponent));
        this.view = this.createView();
        this.view.setLicenseModel(licenseModel);
        this.controller = this.createController(this.view);
        this.nativeComponent.add((Component)this.view.getNativeComponent());
        this.nativeComponent.validate();
    }

    public SwingTableLens(TableLensModel<Color, Row, Column> model) {
        this();
        this.setModel(model);
    }

    public SwingTableLens(DataFrame<Row, Column, ?> dataFrame) {
        this();
        this.load(dataFrame);
    }

    public static void setLicenseKey(String username, String key) {
        licenseModel = new SimpleLicenseModel(ApplicationModelFactory.HIGHD_API, username, key);
    }

    protected TableLensModel createModel(DataFrame dataFrame) {
        return new DefaultTableLensModel((CPFactory)SwingFactory.getInstance(), (ColorMapFactory)SwingColorMapFactory.getInstance(), dataFrame);
    }

    protected TableLensView createView() {
        SwingTableLensView view = new SwingTableLensView();
        return view;
    }

    protected TableLensController createController(TableLensView view) {
        return new SwingTableLensController(view);
    }

    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }

    public static void main(String[] args) {
        SwingTableLens.setLicenseKey("Macrofocus GmbH", "3RCD9-DMQDM-AAEMV-LGN5S-76384-FE5WA");
        TableModel tableModel = TableHelper.createRandomTableModel((int)3, (int)10000, (int)10);
        SwingTableLens tableLens = new SwingTableLens(new TableModelDataFrame(tableModel));
        TableLensModel model = tableLens.getModel();
        tableLens.getView().getColorTheme().setValue((Object)new LightColorTheme((CPColorFactory)SwingFactory.getInstance()));
        tableLens.getView().setShowTiming(true);
        ApplicationModel applicationModel = ApplicationModelFactory.HIGHD_API_V1;
        JFrame frame = new JFrame(applicationModel.getName() + " " + applicationModel.getVersion() + ", Copyright (c) " + applicationModel.getCopyright() + " " + applicationModel.getEdition());
        frame.setSize(600, 600);
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(tableLens.getNativeComponent());
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

