/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.tablelens.swing;

import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.swing.AbstractSwingComponent;
import com.macrofocus.crossplatform.swing.SwingCanvas;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.high_d.tablelens.AbstractTableLensComponent;
import com.macrofocus.high_d.tablelens.TableLensView;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.igraphics.swing.SwingITiming;
import java.awt.Color;
import javax.swing.JComponent;

public class SwingTableLensComponent<Row, C>
extends AbstractTableLensComponent<JComponent, Color, Row, C> {
    private final CPCanvas<JComponent> nativeComponent;
    private final SwingITiming prepareTiming = new SwingITiming("Prepare");
    private final SwingITiming renderTiming = new SwingITiming("Render");
    private final PropertyListener<CPCanvas.Rendering> renderingListener = new PropertyListener<CPCanvas.Rendering>(){

        public void propertyChanged(PropertyEvent<CPCanvas.Rendering> event) {
            SwingTableLensComponent.this.createOverplots();
            SwingTableLensComponent.this.timer.restart();
        }
    };

    public void scheduleUpdate() {
        if (((JComponent)this.nativeComponent.getNativeComponent()).isShowing()) {
            this.timer.restart();
            this.nativeComponent.repaint();
        }
    }

    public SwingTableLensComponent(final TableLensView<JComponent, Color, Row, C> view) {
        super(view, (CPCanvas)new SwingCanvas(){

            public void updateColorTheme() {
                super.updateColorTheme();
                ColorTheme colorTheme = (ColorTheme)view.getColorTheme().getValue();
                if (colorTheme != null && this.getNativeComponent() != null) {
                    Color background = this.getNativeComponent().getBackground();
                    colorTheme.setBackground(SwingFactory.getInstance().createRGBAColor(background.getRed(), background.getGreen(), background.getBlue(), background.getAlpha()));
                    this.getNativeComponent().setBackground((Color)colorTheme.getBackground().getNativeColor());
                    this.getNativeComponent().setForeground((Color)colorTheme.getForeground().getNativeColor());
                }
            }
        }, (CPFactory)SwingFactory.getInstance());
        this.nativeComponent = this.canvas;
        ((JComponent)this.nativeComponent.getNativeComponent()).setOpaque(true);
        ((JComponent)this.nativeComponent.getNativeComponent()).updateUI();
        this.setModel(view.getModel());
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractSwingComponent.setStyleClass((CPComponent)this, (String[])styleClasses);
    }

    protected int getWidth() {
        return (int)this.nativeComponent.getWidth();
    }

    protected int getHeight() {
        return (int)this.nativeComponent.getHeight();
    }

    protected void repaint() {
        this.nativeComponent.repaint();
    }

    protected void refresh() {
        this.prepareTiming.start();
        this.nativeComponent.refresh();
        this.prepareTiming.end();
    }

    public JComponent getNativeComponent() {
        return (JComponent)this.nativeComponent.getNativeComponent();
    }
}

