/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.tablelens.swing;

import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPInteractiveComponent;
import com.macrofocus.crossplatform.swing.AbstractSwingComponent;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.crossplatform.swing.SwingInteractiveComponent;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.helper.SwingHelper;
import com.macrofocus.high_d.axis.AxisHeaderView;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.DummyAxisModel;
import com.macrofocus.high_d.axis.swing.SwingAxisView;
import com.macrofocus.high_d.tablelens.AbstractTableLensView;
import com.macrofocus.high_d.tablelens.TableLensComponent;
import com.macrofocus.high_d.tablelens.TableLensModel;
import com.macrofocus.high_d.tablelens.TableLensView;
import com.macrofocus.high_d.tablelens.swing.SwingTableLensComponent;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.labeling.EnhancedJLabel;
import com.macrofocus.labeling.EnhancedLabel;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.order.MutableVisibleOrder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;

public class SwingTableLensView<Row, C>
extends AbstractTableLensView<JLayeredPane, Color, Row, C> {
    private final CPInteractiveComponent<TableLensLayeredPane> nativeComponent;
    private final Map<AxisModel, JButton> axisLabels = new HashMap<AxisModel, JButton>();
    private TableLensModel<Color, Row, C> model;
    private final TableLensComponent<JComponent, Row, C> tableLensComponent;
    private int headerMaximumHeight;
    private MutableProperty<CPCanvas.Rendering> rendering;
    private boolean isSelectionMode = true;
    private SwingAxisView draggedAxisView;
    private int draggedLocation;
    private LicenseModel licenseModel;
    private JPanel unregisteredPanel;
    private ComponentAdapter unregisteredPanelListener;
    private final PropertyListener<CPCanvas.Rendering> renderingListener = new PropertyListener<CPCanvas.Rendering>(){

        public void propertyChanged(PropertyEvent<CPCanvas.Rendering> event) {
            SwingTableLensView.this.createOverplots();
        }
    };

    public SwingTableLensView() {
        super((CPColorFactory)SwingFactory.getInstance());
        this.nativeComponent = new SwingInteractiveComponent((JComponent)new TableLensLayeredPane());
        this.tableLensComponent = new SwingTableLensComponent(this);
        ((TableLensLayeredPane)this.nativeComponent.getNativeComponent()).add((Component)this.tableLensComponent.getNativeComponent(), JLayeredPane.DEFAULT_LAYER);
        ((TableLensLayeredPane)this.nativeComponent.getNativeComponent()).setOpaque(true);
        ((TableLensLayeredPane)this.nativeComponent.getNativeComponent()).updateUI();
        ((TableLensLayeredPane)this.nativeComponent.getNativeComponent()).addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SwingTableLensView.this.refresh();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                SwingTableLensView.this.refresh();
            }
        });
        ((TableLensLayeredPane)this.nativeComponent.getNativeComponent()).addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    SwingTableLensView.this.refresh();
                }
            }
        });
        this.properties.addPropertiesListener(new PropertiesListener(){

            public void propertyChanged(Object name, PropertyEvent event) {
                if (name == TableLensView.PropertyType.ColorTheme) {
                    ((TableLensLayeredPane)SwingTableLensView.this.nativeComponent.getNativeComponent()).updateUI();
                    ((TableLensLayeredPane)SwingTableLensView.this.nativeComponent.getNativeComponent()).repaint();
                }
            }
        });
        this.setLicenseModel(this.licenseModel);
    }

    public void addMouseListener(CPCanvas.MouseListener l) {
        this.tableLensComponent.addMouseListener(l);
    }

    public void addMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.tableLensComponent.addMouseMotionListener(l);
    }

    public void removeMouseListener(CPCanvas.MouseListener l) {
        this.tableLensComponent.removeMouseListener(l);
    }

    public void removeMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.tableLensComponent.removeMouseMotionListener(l);
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractSwingComponent.setStyleClass((CPComponent)this, (String[])styleClasses);
    }

    public JLayeredPane getNativeComponent() {
        return (JLayeredPane)this.nativeComponent.getNativeComponent();
    }

    public int getWidth() {
        return ((TableLensLayeredPane)this.nativeComponent.getNativeComponent()).getWidth();
    }

    public int getHeight() {
        return ((TableLensLayeredPane)this.nativeComponent.getNativeComponent()).getHeight();
    }

    protected void refresh() {
        if (((TableLensLayeredPane)this.nativeComponent.getNativeComponent()).isShowing()) {
            this.runLayout();
            ((TableLensLayeredPane)this.nativeComponent.getNativeComponent()).repaint();
        }
    }

    private void runLayout() {
        ((JComponent)this.tableLensComponent.getNativeComponent()).setBounds(0, this.headerMaximumHeight, this.getWidth(), this.getHeight() - this.headerMaximumHeight);
        MutableVisibleOrder axisOrder = this.model.getAxisGroupModel().getAxisOrder();
        for (AxisModel axisModel : axisOrder.iterableAll()) {
            assert (axisModel != null);
            JButton header = this.getHeader(axisModel);
            if (axisOrder.isVisible((Object)axisModel)) {
                int i = axisOrder.indexOf((Object)axisModel);
                Double x1Location = this.model.getLocation(axisModel);
                Double x2Location = i + 1 < axisOrder.size() ? this.model.getLocation((AxisModel)axisOrder.get(i + 1)) : Double.valueOf(1.0);
                if (x1Location != null && x2Location != null) {
                    int x = (int)(x1Location * (double)this.getWidth());
                    int y = 0;
                    int width = (int)(x2Location * (double)this.getWidth()) - x;
                    int height = this.headerMaximumHeight;
                    Rectangle mp = new Rectangle(x, y, width, height);
                    header.setBounds(mp);
                }
                header.setVisible(true);
                continue;
            }
            header.setVisible(false);
        }
        ((TableLensLayeredPane)this.nativeComponent.getNativeComponent()).revalidate();
    }

    public JButton getHeader(final AxisModel axisModel) {
        if (!this.axisLabels.containsKey(axisModel)) {
            AxisHeaderView label = this.createAxisHeaderView(axisModel);
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    SwingTableLensView.this.model.setOrder(axisModel);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ((TableLensLayeredPane)SwingTableLensView.this.nativeComponent.getNativeComponent()).requestFocusInWindow(true);
                }
            });
            ((TableLensLayeredPane)this.nativeComponent.getNativeComponent()).add((Component)label, JLayeredPane.PALETTE_LAYER);
            this.axisLabels.put(axisModel, (JButton)label);
        }
        return this.axisLabels.get(axisModel);
    }

    protected AxisHeaderView createAxisHeaderView(AxisModel axisModel) {
        return new AxisHeaderView(axisModel);
    }

    public Row getClosestRow(int x, int y) {
        return (Row)this.tableLensComponent.getClosestRow(x, y);
    }

    public List<Row> getRows(Rectangle2D rect) {
        return this.tableLensComponent.getRows(rect);
    }

    public boolean isSelectionMode() {
        return this.isSelectionMode;
    }

    public void setModel(TableLensModel model) {
        if (this.model != null) {
            this.model.getAxisGroupModel().getAxisOrder().removeOrderListener(this.orderListener);
        }
        this.model = model;
        this.tableLensComponent.setModel(model);
        if (this.model != null) {
            this.model.getAxisGroupModel().getAxisOrder().addOrderListener(this.orderListener);
        }
    }

    public void setSelectionMode(boolean value) {
        this.isSelectionMode = value;
    }

    public TableLensModel getModel() {
        return this.model;
    }

    public void setLicenseModel(LicenseModel licenseModel) {
        if (this.unregisteredPanel != null) {
            ((TableLensLayeredPane)this.nativeComponent.getNativeComponent()).removeComponentListener(this.unregisteredPanelListener);
            ((TableLensLayeredPane)this.nativeComponent.getNativeComponent()).remove(this.unregisteredPanel);
            this.unregisteredPanel = null;
            this.unregisteredPanelListener = null;
        }
        if (licenseModel == null || licenseModel.verify() != LicenseModel.State.Valid) {
            EnhancedJLabel unregisteredLabel = new EnhancedJLabel();
            unregisteredLabel.setEffect(EnhancedLabel.Effect.Outline);
            String message = licenseModel == null ? "Unregistered version" : licenseModel.verify().toString();
            unregisteredLabel.setText(message);
            unregisteredLabel.setForeground(new Color(0, 0, 0, 63));
            unregisteredLabel.setBackground(new Color(255, 255, 255));
            unregisteredLabel.setEffectOpacity(0.2f);
            this.unregisteredPanel = new JPanel(){

                @Override
                public void paint(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    super.paint(g2);
                }
            };
            this.unregisteredPanel.setOpaque(false);
            this.unregisteredPanel.setLayout(new OverlayLayout(this.unregisteredPanel));
            this.unregisteredPanel.add((Component)unregisteredLabel);
            unregisteredLabel.setFont(unregisteredLabel.getFont().deriveFont(1, 32.0f));
            ((TableLensLayeredPane)this.nativeComponent.getNativeComponent()).add(this.unregisteredPanel, JLayeredPane.MODAL_LAYER, 0);
            this.unregisteredPanelListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    SwingHelper.centerBottom((Container)((Container)SwingTableLensView.this.nativeComponent.getNativeComponent()), (Component)SwingTableLensView.this.unregisteredPanel);
                }
            };
            ((TableLensLayeredPane)this.nativeComponent.getNativeComponent()).addComponentListener(this.unregisteredPanelListener);
        }
    }

    protected void createOverplots() {
        if (this.tableLensComponent != null) {
            this.tableLensComponent.createOverplots();
            this.tableLensComponent.scheduleUpdate();
        }
    }

    private class TableLensLayeredPane
    extends JLayeredPane {
        private TableLensLayeredPane() {
        }

        @Override
        public boolean requestFocusInWindow(boolean temporary) {
            return super.requestFocusInWindow(temporary);
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2;
            long current = System.currentTimeMillis();
            Object antialias = (g2 = (Graphics2D)g).getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antialias != null ? antialias : RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
            super.paint(g);
            if (SwingTableLensView.this.isShowTiming()) {
                g.setColor(Color.red);
                g.drawString(System.currentTimeMillis() - current + " milliseconds", 5, this.getSize().height - 25);
            }
        }

        @Override
        public void updateUI() {
            super.updateUI();
            SwingTableLensView.this.headerMaximumHeight = SwingTableLensView.this.createAxisHeaderView((AxisModel)new DummyAxisModel((String)"T")).getPreferredSize().height;
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension getPreferredSize() {
            if (SwingTableLensView.this.model != null) {
                int count = SwingTableLensView.this.model.getAxisGroupModel().getAxisOrder().size();
                return new Dimension(count * (Integer)SwingTableLensView.this.getColumnSize().getValue(), SwingTableLensView.this.headerMaximumHeight + (Integer)SwingTableLensView.this.getRowSize().getValue() * SwingTableLensView.this.model.getObjectCount());
            }
            return new Dimension(0, 0);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }
}

