/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.treemap.swing;

import com.macrofocus.crossplatform.CPComponent;
import com.treemap.TreeMap;
import com.treemap.TreeMapModel;
import com.treemap.swing.GroupByComboBoxModel;
import com.treemap.swing.SizeComboBoxModel;
import com.treemap.swing.TreeMapPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SwingTreeMapPanel
extends JPanel
implements CPComponent<JComponent> {
    private final TreeMap treeMap;
    private final JComboBox sizeComboBox;
    private final JComboBox groupByComboBox;

    public SwingTreeMapPanel(TreeMap treeMap) {
        this.treeMap = treeMap;
        this.setLayout(new BorderLayout());
        this.add((Component)new TreeMapPanel(treeMap), "Center");
        JPanel configurationPanel = new JPanel();
        configurationPanel.setLayout(new BoxLayout(configurationPanel, 0));
        configurationPanel.add(new JLabel("Group by: "));
        this.groupByComboBox = new JComboBox(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(0, super.getPreferredSize().height);
            }
        };
        configurationPanel.add(this.groupByComboBox);
        configurationPanel.add(Box.createHorizontalStrut(5));
        configurationPanel.add(new JLabel("Size: "));
        this.sizeComboBox = new JComboBox(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(0, super.getPreferredSize().height);
            }
        };
        configurationPanel.add(this.sizeComboBox);
        configurationPanel.add(Box.createHorizontalGlue());
        this.add((Component)configurationPanel, "South");
        if (treeMap.getModel() != null) {
            this.setModel(treeMap.getModel());
        }
    }

    public void setModel(TreeMapModel model) {
        this.treeMap.setModel(model);
        this.groupByComboBox.setModel(new GroupByComboBoxModel(model));
        this.sizeComboBox.setModel(new SizeComboBoxModel(model));
    }

    public TreeMap getTreeMap() {
        return this.treeMap;
    }

    public void setStyleClass(String ... styleClasses) {
    }

    public JComponent getNativeComponent() {
        return this;
    }
}

