/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.treetable.swing;

import com.macrofocus.high_d.treetable.swing.AbstractTreeTableModel;
import com.macrofocus.high_d.treetable.swing.TreeTableModel;
import com.treemap.AbstractTreeMapNode;
import com.treemap.DefaultTreeMapModel;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapEvent;
import com.treemap.TreeMapListener;
import java.awt.Color;
import java.util.List;

public class TreeMapTreeTableModel
extends AbstractTreeTableModel {
    private final DefaultTreeMapModel model;
    private final boolean expertMode = false;

    public TreeMapTreeTableModel(DefaultTreeMapModel model) {
        this.model = model;
        model.addListener(new TreeMapListener(){

            public void tableModelChanged() {
                TreeMapTreeTableModel.this.fireTreeStructureChanged(this, null, null, null);
            }

            public void treeMapChanged(TreeMapEvent event) {
                TreeMapTreeTableModel.this.fireTreeStructureChanged(this, null, null, null);
            }
        });
    }

    @Override
    public Object getRoot() {
        return this.model.getRoot();
    }

    @Override
    public int getColumnCount() {
        return this.model.getColumnCount() + 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.model.getDataFrame().getColumnName(this.model.getDataFrame().getColumnKey(columnIndex));
            }
            case 1: {
                return "Size";
            }
            case 2: {
                return "Color";
            }
        }
        return this.model.getDataFrame().getColumnName(this.model.getDataFrame().getColumnKey(columnIndex - 2));
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return TreeTableModel.class;
            }
            case 1: {
                return Double.class;
            }
            case 2: {
                return Color.class;
            }
        }
        return this.model.getDataFrame().getColumnClass(this.model.getDataFrame().getColumnKey(columnIndex - 2));
    }

    @Override
    public Object getValueAt(Object n, int columnIndex) {
        AbstractTreeMapNode node = (AbstractTreeMapNode)n;
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                AbstractTreeMapNode parent = this.model.getParent(node);
                if (parent != null) {
                    double v = this.model.getSize((MutableTreeMapNode)node) / this.model.getSumSize((MutableTreeMapNode)parent);
                    if (!Double.isNaN(v) && !Double.isInfinite(v)) {
                        return v;
                    }
                    return null;
                }
                return 1.0;
            }
            case 2: {
                return this.model.getColor((MutableTreeMapNode)node);
            }
            default: {
                columnIndex -= 2;
            }
        }
        if (node.hasNoChildren()) {
            switch (columnIndex) {
                case 0: {
                    if (node.hasNoChildren()) {
                        return this.model.getValueAt(node, this.model.getDataFrame().getColumnKey(columnIndex));
                    }
                    return node.getLabelName();
                }
            }
            return this.model.getValueAt(node, this.model.getDataFrame().getColumnKey(columnIndex));
        }
        switch (columnIndex) {
            case 0: {
                return node.getLabelName();
            }
        }
        return this.model.getAggregateValue((MutableTreeMapNode)node, this.model.getTreeMapField(columnIndex));
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return true;
    }

    @Override
    public void setValueAt(Object aValue, Object node, int column) {
    }

    @Override
    public Object getChild(Object p, int index) {
        AbstractTreeMapNode parent = (AbstractTreeMapNode)p;
        List list = (List)this.model.getChildren(parent);
        return list.get(index);
    }

    @Override
    public int getChildCount(Object p) {
        AbstractTreeMapNode parent = (AbstractTreeMapNode)p;
        return this.model.getChildCount(parent);
    }
}

