/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.interaction;

import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.geom.Point;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.high_d.interaction.InteractionMode;
import com.macrofocus.rubberband.RubberBand;
import java.util.Collection;

public abstract class GenericMouseListener<Row>
implements CPCanvas.MouseListener,
CPCanvas.MouseMotionListener {
    private final RubberBand rubberBand;
    private final boolean multipleSelectionEnabled = true;
    private final boolean selectOnPopupTrigger = false;
    private boolean isSelectionMode = true;
    private Point last;
    private Row selectOnRelease = null;
    private Point zoomOnRelease = null;
    private Point zoomingPoint = null;
    private Point pressedPoint = null;

    public GenericMouseListener(RubberBand rubberBand) {
        this.rubberBand = rubberBand;
        rubberBand.getRubberBand().addSingleSelectionListener((SingleSelectionListener)new SingleSelectionListener<Rectangle2D>(){

            public void selectionChanged(SingleSelectionEvent<Rectangle2D> event) {
                if (event.getCurrentSelection() != null && ((Rectangle2D)event.getCurrentSelection()).getWidth() > 0.0 && ((Rectangle2D)event.getCurrentSelection()).getHeight() > 0.0) {
                    Rectangle2D rect = GenericMouseListener.this.getRubberBand().getRubberBandScreen();
                    if (rect != null) {
                        Collection toSelect = GenericMouseListener.this.getRows(rect);
                        GenericMouseListener.this.getSelection().setSelectedIterable(toSelect);
                    }
                } else {
                    GenericMouseListener.this.getSelection().clearSelection();
                }
            }
        });
    }

    protected abstract InteractionMode getMode();

    protected abstract void setMode(InteractionMode var1);

    public boolean isSelectionMode() {
        return this.isSelectionMode;
    }

    public void setSelectionMode(boolean value) {
        this.isSelectionMode = value;
    }

    protected abstract MutableSingleSelection<Row> getProbing();

    protected abstract MutableSelection<Row> getSelection();

    protected abstract MutableFilter<Row> getFilter();

    protected abstract Row getClosestRow(int var1, int var2);

    protected abstract Collection<Row> getRows(Rectangle2D var1);

    protected RubberBand getRubberBand() {
        return this.rubberBand;
    }

    public void mouseClicked(CPCanvas.MouseEvent e) {
    }

    public void mousePressed(CPCanvas.MouseEvent event) {
        this.pressedPoint = new Point(event.getX(), event.getY());
        Row bestrow = this.getClosestRow(event.getX(), event.getY());
        switch (this.getMode()) {
            case Selection: {
                if (bestrow != null) {
                    if (!event.isMultipleSelectionKey()) {
                        if (this.getSelection().isSelected(bestrow) && this.getSelection().getSelectedCount() <= 1) break;
                        this.getSelection().clearSelection();
                        this.getSelection().setSelected(bestrow);
                        this.setSelectionMode(this.getSelection().isSelected(bestrow));
                        break;
                    }
                    this.setSelectionMode(!this.getSelection().isSelected(bestrow));
                    if (this.isSelectionMode()) {
                        this.getSelection().setSelectedState(bestrow, true);
                        break;
                    }
                    this.getSelection().setSelectedState(bestrow, false);
                    break;
                }
                this.getSelection().clearSelection();
                break;
            }
            case Toggle: {
                boolean selected = this.getSelection().isSelected(bestrow);
                this.getSelection().setSelectedState(bestrow, !selected);
                break;
            }
            case Filter: {
                boolean filtered = this.getFilter().isFilteredBy(bestrow, (Object)this);
                this.getFilter().setFiltered(bestrow, !filtered, (Object)this);
            }
        }
    }

    public void mouseReleased(CPCanvas.MouseEvent event) {
        if (!event.isPopupTrigger()) {
            switch (this.getMode()) {
                case Selection: {
                    if (this.selectOnRelease != null && event.isLeftMouseButton()) {
                        this.getSelection().clearSelection();
                        this.addToSelection(this.selectOnRelease);
                        this.selectOnRelease = null;
                    }
                    if (this.zoomOnRelease != null) {
                        if (event.isLeftMouseButton()) {
                            // empty if block
                        }
                        this.zoomOnRelease = null;
                    }
                    this.getRubberBand().stopRubberBand();
                    break;
                }
                case Toggle: {
                    if (this.selectOnRelease != null && event.isLeftMouseButton()) {
                        this.getSelection().clearSelection();
                        this.addToSelection(this.selectOnRelease);
                        this.selectOnRelease = null;
                    }
                    if (this.zoomOnRelease != null) {
                        if (event.isLeftMouseButton()) {
                            // empty if block
                        }
                        this.zoomOnRelease = null;
                    }
                    this.getRubberBand().stopRubberBand();
                    break;
                }
            }
        }
        this.last = null;
    }

    public void mouseEntered(CPCanvas.MouseEvent e) {
    }

    public void mouseExited(CPCanvas.MouseEvent e) {
        this.getProbing().clearSelection();
    }

    public void mouseDragged(CPCanvas.MouseEvent event) {
        Point point = new Point(event.getX(), event.getY());
        if (this.last != null) {
            switch (this.getMode()) {
                case Selection: {
                    boolean isAlreadySelected;
                    if (!event.isLeftMouseButton()) break;
                    if (event.isAltKeyDown() || event.isShiftKeyDown()) {
                        this.getProbing().clearSelection();
                        if (!this.getRubberBand().getRubberBand().isActive()) {
                            this.getRubberBand().startRubberBand(this.pressedPoint.x, this.pressedPoint.y);
                        }
                        this.getRubberBand().stretchRubberBand(event.getX(), event.getY());
                        Rectangle2D rect = this.getRubberBand().getRubberBandScreen();
                        if (rect == null) break;
                        Collection<Row> toSelect = this.getRows(rect);
                        if (event.isMultipleSelectionKey()) {
                            this.addToSelection(toSelect);
                        } else {
                            this.getSelection().setSelectedIterable(toSelect);
                        }
                        this.selectOnRelease = null;
                        break;
                    }
                    Row observation = this.getClosestRow(point.x, point.y);
                    this.getProbing().setSelected(observation);
                    this.selectOnRelease = null;
                    boolean bl = isAlreadySelected = this.getSelection() != null && this.getSelection().isSelected(observation);
                    if (!isAlreadySelected && !event.isMenuShortcutKeyDown()) {
                        this.getSelection().clearSelection();
                    }
                    if (event.isMenuShortcutKeyDown()) {
                        this.addToSelection(observation);
                        break;
                    }
                    if (isAlreadySelected) {
                        this.selectOnRelease = observation;
                        break;
                    }
                    this.addToSelection(observation);
                }
            }
        }
        this.last = new Point(event.getX(), event.getY());
    }

    public void mouseMoved(CPCanvas.MouseEvent event) {
        Row closest = this.getClosestRow(event.getX(), event.getY());
        this.getProbing().setSelected(closest);
    }

    private void removeFromSelection(Row observation) {
        this.getSelection().setSelectedState(observation, false);
    }

    private void setSelection(Row observation) {
        if (observation != null) {
            this.getSelection().setSelectedElements(new Object[]{observation});
        } else {
            this.getSelection().clearSelection();
        }
    }

    private void addToSelection(Row observation) {
        this.getSelection().setSelectedState(observation, true);
    }

    private void addToSelection(Collection<Row> newSelection) {
        this.getSelection().setSelectedIterableState(newSelection, true);
    }
}

