/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.mds;

import com.macrofocus.common.collection.PluggableCollectionFactory;
import com.macrofocus.high_d.mds.MDSEngine;
import com.macrofocus.high_d.mds.MDSEngineEvent;
import com.macrofocus.high_d.mds.MDSEngineListener;
import com.macrofocus.high_d.mds.quality.QualityEngine;
import com.macrofocus.molap.dataframe.matrix.Matrix;
import com.macrofocus.timer.CPExecutor;
import java.util.List;

public abstract class AbstractMDSEngine
implements MDSEngine {
    private final List<MDSEngineListener> listeners = PluggableCollectionFactory.getInstance().copyOnWriteArrayList();
    private final CPExecutor executor;
    private CPExecutor.Cancelable cancelable;

    public AbstractMDSEngine(CPExecutor executor) {
        this.executor = executor;
    }

    @Override
    public double computeStress() {
        return QualityEngine.computeStress(this.getModel(), this.getDistanceTable());
    }

    protected abstract Matrix getDistanceTable();

    @Override
    public void startEngine() {
        this.cancelable = this.executor.scheduleIncremental(this.createRunCommand());
    }

    @Override
    public void stopEngine() {
        if (this.cancelable != null) {
            this.cancelable.cancel();
        }
    }

    @Override
    public boolean isAlive() {
        return this.cancelable != null && !this.cancelable.isCancelled();
    }

    public boolean isInterrupted() {
        return this.cancelable == null || this.cancelable.isCancelled();
    }

    public abstract CPExecutor.Command createRunCommand();

    @Override
    public void addEngineListener(MDSEngineListener engineListener) {
        this.listeners.add(engineListener);
    }

    @Override
    public void removeEngineListener(MDSEngineListener engineListener) {
        this.listeners.remove(engineListener);
    }

    protected void notifyEngineIterated(MDSEngineEvent event) {
        for (MDSEngineListener listener : this.listeners) {
            listener.engineIterated(event);
        }
    }

    protected void notifyEngineFinished(MDSEngineEvent event) {
        for (MDSEngineListener listener : this.listeners) {
            listener.engineFinished(event);
        }
    }
}

