/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.mds;

import com.macrofocus.common.collection.Iterables;
import com.macrofocus.common.command.Command;
import com.macrofocus.crossplatform.CPButton;
import com.macrofocus.crossplatform.CPComboBox;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.CPFillMiddlePanel;
import com.macrofocus.crossplatform.CPHorizontalFlowPanel;
import com.macrofocus.crossplatform.CPVerticalFillMiddlePanel;
import com.macrofocus.high_d.mds.MDS;
import com.macrofocus.high_d.mds.MDSPanel;
import com.macrofocus.high_d.mds.MDSScatterPlotModel;
import com.macrofocus.high_d.scatterplot.ScatterPlotListener;

public class AbstractMDSPanel<Component>
implements MDSPanel<Component> {
    private final MDS<Component, ?, ?, ?, ?> mds;
    private final CPVerticalFillMiddlePanel<Component> nativeComponent;
    private final CPButton<Component> startButton;
    private final CPButton<Component> stopButton;
    private CPComboBox algorithmComboBox;
    private final ScatterPlotListener listener = new ScatterPlotListener(){

        @Override
        public void scatterPlotChanged() {
            AbstractMDSPanel.this.updateButtons(AbstractMDSPanel.this.mds.getModel().isRunning(), true);
        }
    };

    public AbstractMDSPanel(CPFactory<Component, ?, ?, ?> factory, final MDS<Component, ?, ?, ?, ?> mds) {
        this.mds = mds;
        this.nativeComponent = factory.createVerticalFillMiddlePanel();
        this.nativeComponent.setStyleClass(new String[]{"mdsPanel"});
        CPFillMiddlePanel south = factory.createFillMiddlePanel();
        CPHorizontalFlowPanel palettePanel = factory.createHorizontalFlowPanel(new CPComponent[0]);
        south.setWest((CPComponent)palettePanel);
        this.algorithmComboBox = factory.createComboBox(mds.getModel().getAlgorithm(), Iterables.forArray((Object[])MDSScatterPlotModel.Algorithm.values()));
        palettePanel.add((CPComponent)this.algorithmComboBox);
        this.startButton = factory.createButton("Start");
        this.startButton.setCommand(new Command(){

            public void execute() {
                AbstractMDSPanel.this.updateButtons(true, false);
                mds.getModel().start();
            }
        });
        palettePanel.add(this.startButton);
        this.stopButton = factory.createButton("Stop");
        this.stopButton.setCommand(new Command(){

            public void execute() {
                mds.getModel().stop();
            }
        });
        palettePanel.add(this.stopButton);
        this.nativeComponent.setSouth((CPComponent)south);
        this.nativeComponent.setCenter(factory.createComponent(mds.getNativeComponent()));
        this.setModel(mds.getModel());
    }

    public void setModel(MDSScatterPlotModel model) {
        if (this.mds.getModel() != null) {
            this.mds.getModel().removeScatterPlotListener(this.listener);
        }
        if (model != null) {
            this.mds.getModel().addScatterPlotListener(this.listener);
        }
        this.updateButtons(this.mds.getModel().isRunning(), true);
    }

    private void updateButtons(boolean running, boolean stopable) {
        this.startButton.setEnabled(!running);
        this.stopButton.setEnabled(running && stopable);
        this.algorithmComboBox.setEnabled(!running);
        this.startButton.setVisible(!running);
        this.stopButton.setVisible(running);
    }

    public void setStyleClass(String ... styleClasses) {
        this.nativeComponent.setStyleClass(styleClasses);
    }

    public Component getNativeComponent() {
        return (Component)this.nativeComponent.getNativeComponent();
    }
}

