/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.mds;

import com.macrofocus.coloring.MutableColoring;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormapping.MutableColorMapping;
import com.macrofocus.colormapping.implementation.SimpleColorMapping;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SimpleSingleSelection;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.filter.Filter;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.high_d.axis.AbstractAxisModel;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.AxisOrderDataFrame;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.axis.group.DefaultAxisGroupModel;
import com.macrofocus.high_d.mds.MDSEngine;
import com.macrofocus.high_d.mds.MDSEngineEvent;
import com.macrofocus.high_d.mds.MDSEngineListener;
import com.macrofocus.high_d.mds.MDSModel;
import com.macrofocus.high_d.mds.MutableMDSModel;
import com.macrofocus.high_d.mds.distance.DistanceMatrix;
import com.macrofocus.high_d.mds.distance.EuclideanDistanceStrategy;
import com.macrofocus.high_d.mds.pca.PCAMDSEngine;
import com.macrofocus.high_d.mds.pca.PCAModel;
import com.macrofocus.high_d.mds.pca.SimplePCAModel;
import com.macrofocus.high_d.mds.sammon.SammonMDSEngine;
import com.macrofocus.high_d.mds.sammon.SimpleSammonModel;
import com.macrofocus.high_d.mds.spring.FastNeighbouringSamplingSpringMDSEngine;
import com.macrofocus.high_d.mds.spring.SimpleSpringModel;
import com.macrofocus.high_d.mds.tsne.MatrixOperationsFactory;
import com.macrofocus.high_d.mds.tsne.SimpleTSNEModel;
import com.macrofocus.high_d.mds.tsne.TSNEMDSEngine;
import com.macrofocus.high_d.scatterplot.AbstractScatterPlotModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.DataFrameHelper;
import com.macrofocus.molap.dataframe.NumberDataFrame;
import com.macrofocus.molap.dataframe.matrix.CacheDistanceMatrix;
import com.macrofocus.molap.dataframe.matrix.CacheMatrix;
import com.macrofocus.molap.dataframe.matrix.CalibratedDistanceMatrix;
import com.macrofocus.molap.dataframe.matrix.ColumnCorrelationMatrix;
import com.macrofocus.molap.dataframe.matrix.Matrix;
import com.macrofocus.molap.dataframe.matrix.NormalizedMatrix;
import com.macrofocus.molap.dataframe.matrix.StatMatrix;
import com.macrofocus.molap.subset.OrdinalDimension;
import com.macrofocus.order.Order;
import com.macrofocus.timer.CPExecutor;
import com.macrofocus.visual.SimpleVisual;
import com.macrofocus.visual.SimpleVisualObjects;
import com.macrofocus.visual.Visual;
import com.macrofocus.visual.VisualObjects;
import java.util.Iterator;

public class MDSScatterPlotModel<Color, Row, C>
extends AbstractScatterPlotModel<Color, Row, C>
implements VisualObjects<Row> {
    private final AxisOrderDataFrame<Row, C, ?> dataModel;
    private final Visual<Color, Row, C> visual;
    private final MutableSingleSelection<Algorithm> algorithm = new SimpleSingleSelection((Object)Algorithm.Spring);
    private final DataFrame<Row, C, ?> dataFrame;
    private MDSModel mdsModel;
    private int length = 100000;
    private final AxisModel xAxisModel;
    private final AxisModel yAxisModel;
    private double minX = -1.0;
    private double minY = -1.0;
    private double maxX = 1.0;
    private double maxY = 1.0;
    private final boolean centerOfMass = true;
    private MDSEngine engine;
    private final MatrixOperationsFactory matrixOperationsFactory;
    private final CPExecutor executor;
    private final MutableSingleSelection<AxisModel<Row, C>> x = new SimpleSingleSelection();
    private final MutableSingleSelection<AxisModel<Row, C>> y = new SimpleSingleSelection();
    private long lastUpdate = System.currentTimeMillis();
    private long lastIteration;
    final MDSEngineListener engineListener = new MDSEngineListener(){

        @Override
        public void engineIterated(MDSEngineEvent event) {
            MDSScatterPlotModel.this.updateMinMax();
            long current = System.currentTimeMillis();
            long timePerIteration = current - MDSScatterPlotModel.this.lastIteration;
            MDSScatterPlotModel.this.lastIteration = System.currentTimeMillis();
            if (current - MDSScatterPlotModel.this.lastUpdate > 250L) {
                MDSScatterPlotModel.this.fireScatterPlotChanged();
                MDSScatterPlotModel.this.lastUpdate = current;
            }
        }

        @Override
        public void engineFinished(MDSEngineEvent event) {
            MDSScatterPlotModel.this.stop();
            MDSScatterPlotModel.this.fireScatterPlotChanged();
        }
    };

    public MDSScatterPlotModel(DataFrame<Row, C, ?> dataFrame, CPFactory factory, ColorMapFactory<Color> colorMapFactory, MatrixOperationsFactory matrixOperationsFactory, CPExecutor executor) {
        this(dataFrame, (Visual<Color, Row, C>)new SimpleVisual((VisualObjects)new SimpleVisualObjects(dataFrame), (MutableColorMapping)new SimpleColorMapping(colorMapFactory, dataFrame)), factory, matrixOperationsFactory, executor);
    }

    public MDSScatterPlotModel(DataFrame<Row, C, ?> dataFrame, Visual<Color, Row, C> visual, CPFactory factory, MatrixOperationsFactory matrixOperationsFactory, CPExecutor executor) {
        this((DataFrame)dataFrame, visual, (AxisGroupModel<Row, C>)new DefaultAxisGroupModel(factory, "Root", dataFrame, null, (SingleSelection)visual.getProbing(), (Selection)visual.getSelection(), (MutableFilter)visual.getFilter()), matrixOperationsFactory, executor);
    }

    public <V> MDSScatterPlotModel(final DataFrame<Row, C, V> dataFrame, Visual<Color, Row, C> visual, AxisGroupModel<Row, C> axisGroupModel, MatrixOperationsFactory matrixOperationsFactory, CPExecutor executor) {
        this.dataFrame = dataFrame;
        this.visual = visual;
        this.matrixOperationsFactory = matrixOperationsFactory;
        this.executor = executor;
        this.dataModel = new AxisOrderDataFrame(dataFrame, (Order)axisGroupModel.getAxisOrder());
        this.algorithm.addSingleSelectionListener((SingleSelectionListener)new SingleSelectionListener<Algorithm>(){

            public void selectionChanged(SingleSelectionEvent<Algorithm> event) {
                MDSScatterPlotModel.this.createMapModel();
            }
        });
        this.createMapModel();
        this.xAxisModel = new MapAxisModel(){

            public String getName() {
                return "X";
            }

            public Class getType() {
                return Double.class;
            }

            public Iterator<Row> iterator() {
                return dataFrame.rows().iterator();
            }

            public Number getValue(Row row) {
                return MDSScatterPlotModel.this.mdsModel.getX(dataFrame.getRowAddress(row));
            }

            public Number getValue(int layer, Row row) {
                if (layer == 0) {
                    return this.getValue(row);
                }
                return null;
            }

            public String getFormattedValue(int layer, Row row) {
                if (layer == 0) {
                    return this.getFormattedValue(row);
                }
                return null;
            }

            public double getMinimum() {
                return MDSScatterPlotModel.this.minX;
            }

            public double getMean() {
                throw new UnsupportedOperationException();
            }

            public double getStdDev() {
                throw new UnsupportedOperationException();
            }

            public double getMaximum() {
                return MDSScatterPlotModel.this.maxX;
            }

            public boolean isDegenerate() {
                return MDSScatterPlotModel.this.minX == MDSScatterPlotModel.this.maxX;
            }
        };
        this.yAxisModel = new MapAxisModel(){

            public String getName() {
                return "Y";
            }

            public Class getType() {
                return Double.class;
            }

            public Iterator<Row> iterator() {
                return dataFrame.rows().iterator();
            }

            public Number getValue(Row row) {
                return MDSScatterPlotModel.this.mdsModel.getY(dataFrame.getRowAddress(row));
            }

            public Number getValue(int layer, Row row) {
                if (layer == 0) {
                    return this.getValue(row);
                }
                return null;
            }

            public String getFormattedValue(int layer, Row row) {
                if (layer == 0) {
                    return this.getFormattedValue(row);
                }
                return null;
            }

            public double getMinimum() {
                return MDSScatterPlotModel.this.minY;
            }

            public double getMean() {
                throw new UnsupportedOperationException();
            }

            public double getStdDev() {
                throw new UnsupportedOperationException();
            }

            public double getMaximum() {
                return MDSScatterPlotModel.this.maxY;
            }

            public boolean isDegenerate() {
                return MDSScatterPlotModel.this.minX == MDSScatterPlotModel.this.maxX;
            }
        };
        this.getX().setSelected((Object)this.xAxisModel);
        this.getY().setSelected((Object)this.yAxisModel);
    }

    public void start() {
        if (this.engine == null) {
            this.createEngine();
            this.engine.addEngineListener(this.engineListener);
            this.lastIteration = System.currentTimeMillis();
            this.startEngine(this.engine);
        }
    }

    public boolean isRunning() {
        return this.engine != null && this.engine.isAlive();
    }

    private void createMapModel() {
        switch (((Algorithm)((Object)this.algorithm.getSelected())).ordinal()) {
            case 0: {
                this.mdsModel = new SimpleSammonModel((DataFrame)this.dataModel);
                break;
            }
            case 1: {
                this.mdsModel = new SimpleSpringModel((DataFrame)this.dataModel);
                break;
            }
            case 2: {
                this.mdsModel = new SimpleTSNEModel((DataFrame)this.dataModel);
                break;
            }
            case 3: {
                this.mdsModel = new SimplePCAModel((DataFrame)this.dataModel);
                break;
            }
            default: {
                throw new UnsupportedOperationException(((Algorithm)((Object)this.algorithm.getSelected())).name());
            }
        }
        this.updateMinMax();
        this.fireScatterPlotChanged();
    }

    private void createEngine() {
        switch (((Algorithm)((Object)this.algorithm.getSelected())).ordinal()) {
            case 0: {
                NumberDataFrame matrixModel = new NumberDataFrame(this.dataModel);
                NormalizedMatrix normMatrixModel = new NormalizedMatrix((Matrix)matrixModel, new StatMatrix((Matrix)matrixModel));
                CacheDistanceMatrix dist = new DistanceMatrix(normMatrixModel, new EuclideanDistanceStrategy());
                try {
                    dist = new CacheDistanceMatrix(dist);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                this.engine = new SammonMDSEngine((MutableMDSModel)this.mdsModel, (Matrix)dist, this.length, this.executor);
                break;
            }
            case 1: {
                NumberDataFrame matrixModel = new NumberDataFrame(this.dataModel);
                NormalizedMatrix normMatrixModel = new NormalizedMatrix((Matrix)matrixModel, new StatMatrix((Matrix)matrixModel));
                CalibratedDistanceMatrix dist = new DistanceMatrix(normMatrixModel, new EuclideanDistanceStrategy());
                dist = new CalibratedDistanceMatrix(dist, 0.167, 100.0);
                try {
                    dist = new CacheDistanceMatrix((Matrix)dist);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                this.engine = new FastNeighbouringSamplingSpringMDSEngine((SimpleSpringModel)this.mdsModel, (Matrix)dist, this.length, this.executor);
                break;
            }
            case 2: {
                NumberDataFrame matrixModel = new NumberDataFrame(this.dataModel);
                NormalizedMatrix normMatrixModel = new NormalizedMatrix((Matrix)matrixModel, new StatMatrix((Matrix)matrixModel));
                try {
                    normMatrixModel = new CacheMatrix((Matrix)normMatrixModel);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                this.engine = new TSNEMDSEngine((MutableMDSModel)this.mdsModel, (Matrix)normMatrixModel, this.matrixOperationsFactory, this.executor);
                break;
            }
            case 3: {
                NumberDataFrame matrixModel = new NumberDataFrame(this.dataModel);
                this.engine = new PCAMDSEngine((PCAModel)this.mdsModel, (Matrix)matrixModel, (Matrix)new ColumnCorrelationMatrix((Matrix)matrixModel), this.executor);
                break;
            }
            default: {
                throw new UnsupportedOperationException(((Algorithm)((Object)this.algorithm.getSelected())).name());
            }
        }
    }

    private void updateMinMax() {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        for (int i = 0; i < this.mdsModel.getRowCount(); ++i) {
            double x = this.mdsModel.getX(i);
            double y = this.mdsModel.getY(i);
            if (minX > x) {
                minX = x;
            }
            if (maxX < x) {
                maxX = x;
            }
            if (minY > y) {
                minY = y;
            }
            if (!(maxY < y)) continue;
            maxY = y;
        }
        double originX = 0.0;
        double originY = 0.0;
        int count = 0;
        for (int i = 0; i < this.mdsModel.getRowCount(); ++i) {
            if (!this.mdsModel.isAvailable(i)) continue;
            originX += this.mdsModel.getX(i);
            originY += this.mdsModel.getY(i);
            ++count;
        }
        double max = Math.max(maxX - minX, maxY - minY);
        double mX = Math.max((originX /= (double)count) - minX, maxX - originX);
        double mY = Math.max((originY /= (double)count) - minY, maxY - originY);
        double halfMax = Math.max(mX, mY);
        minX = originX - halfMax;
        maxX = originX + halfMax;
        minY = originY - halfMax;
        maxY = originY + halfMax;
        double marginX = (maxX - minX) * 0.05;
        double marginY = (maxY - minY) * 0.05;
        this.minX = minX - marginX;
        this.maxX = maxX + marginX;
        this.minY = minY - marginY;
        this.maxY = maxY + marginY;
    }

    private void startEngine(MDSEngine engine) {
        engine.startEngine();
        this.fireScatterPlotChanged();
    }

    public void stop() {
        if (this.engine != null) {
            this.engine.removeEngineListener(this.engineListener);
            this.engine.stopEngine();
            this.engine = null;
            this.fireScatterPlotChanged();
        }
    }

    public void setLength(int length) {
        this.length = length;
    }

    public MutableSingleSelection<Algorithm> getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public Visual<Color, Row, C> getVisual() {
        return this.visual;
    }

    @Override
    public AxisGroupModel getAxisGroupModel() {
        return null;
    }

    @Override
    public MutableSingleSelection<Row> getProbing() {
        return this.visual.getProbing();
    }

    @Override
    public MutableSelection<Row> getSelection() {
        return this.visual.getSelection();
    }

    @Override
    public Filter<Row> getFilter() {
        return this.visual.getFilter();
    }

    @Override
    public MutableColorMapping<Color, Row, C> getColorMapping() {
        return this.visual.getColorMapping();
    }

    @Override
    public MutableColoring<Color, Row> getColoring() {
        return this.visual.getColoring();
    }

    @Override
    public int getObjectCount() {
        return this.dataFrame.getRowCount();
    }

    @Override
    public Row getObject(int index) {
        return (Row)this.dataFrame.getRowKey(index);
    }

    @Override
    public AxisModel getXAxisModel() {
        return this.xAxisModel;
    }

    @Override
    public AxisModel getYAxisModel() {
        return this.yAxisModel;
    }

    @Override
    public AxisModel getY2AxisModel() {
        return null;
    }

    @Override
    public AxisModel getSizeAxisModel() {
        return null;
    }

    @Override
    public DataFrame getDataFrame() {
        return this.dataFrame;
    }

    @Override
    public DataFrame getAnnotationDataFrame() {
        return null;
    }

    @Override
    public MutableSingleSelection<AxisModel<Row, C>> getX() {
        return this.x;
    }

    @Override
    public MutableSingleSelection<AxisModel<Row, C>> getY() {
        return this.y;
    }

    @Override
    public MutableSingleSelection<AxisModel<Row, C>> getY2() {
        return null;
    }

    @Override
    public MutableSingleSelection<AxisModel> getSize() {
        return null;
    }

    public static enum Algorithm {
        Sammon,
        Spring,
        TSNE{

            public String toString() {
                return "t-SNE";
            }
        }
        ,
        PCA;

    }

    private abstract class MapAxisModel
    extends AbstractAxisModel<Row, C> {
        private MapAxisModel() {
        }

        public MutableProperty<Boolean> getButtonModel() {
            return null;
        }

        public boolean isNumerical() {
            return true;
        }

        public int getRowCount() {
            return MDSScatterPlotModel.this.mdsModel.getRowCount();
        }

        public Row getRow(int row) {
            return MDSScatterPlotModel.this.getObject(row);
        }

        public SingleSelection<Row> getProbing() {
            return null;
        }

        public Selection<Row> getSelection() {
            return null;
        }

        public MutableFilter<Row> getFilter() {
            return null;
        }

        public void setMinimum(double min) {
        }

        public void setMaximum(double max) {
        }

        public void setMinMax(double min, double max) {
        }

        public DataFrameHelper.ColumnStatistics getColumnStatistics() {
            return null;
        }

        public MutableBoundedInterval getInterval() {
            return null;
        }

        public MutableBoundedInterval getScaledInterval() {
            return null;
        }

        public C getColumn() {
            return null;
        }

        public String getFormattedMinimum() {
            return null;
        }

        public String getFormattedMaximum() {
            return null;
        }

        public String getFormattedValue(Row row) {
            return null;
        }

        public String getFormattedValue(double value) {
            return null;
        }

        public Object getOriginalFloorValue(double value) {
            return null;
        }

        public Object getOriginalCeilValue(double value) {
            return null;
        }

        public OrdinalDimension getDimension() {
            return null;
        }
    }
}

