/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.mds.tsne;

import com.macrofocus.high_d.mds.tsne.MatrixOperations;

public abstract class AbstractMatrixOperations
implements MatrixOperations {
    @Override
    public double[][] mean(double[][] matrix, int axis) {
        double[][] result;
        if (axis == 0) {
            result = new double[1][matrix[0].length];
            for (int j = 0; j < matrix[0].length; ++j) {
                double colsum = 0.0;
                for (int i = 0; i < matrix.length; ++i) {
                    colsum += matrix[i][j];
                }
                result[0][j] = colsum / (double)matrix.length;
            }
        } else if (axis == 1) {
            result = new double[matrix.length][1];
            for (int i = 0; i < matrix.length; ++i) {
                double rowsum = 0.0;
                for (int j = 0; j < matrix[0].length; ++j) {
                    rowsum += matrix[i][j];
                }
                result[i][0] = rowsum / (double)matrix[0].length;
            }
        } else if (axis == 2) {
            result = new double[1][1];
            for (int j = 0; j < matrix[0].length; ++j) {
                for (int i = 0; i < matrix.length; ++i) {
                    double[] dArray = result[0];
                    dArray[0] = dArray[0] + matrix[i][j];
                }
            }
            double[] dArray = result[0];
            dArray[0] = dArray[0] / (double)(matrix[0].length * matrix.length);
        } else {
            throw new IllegalArgumentException("Axes other than 0,1,2 is unsupported");
        }
        return result;
    }

    @Override
    public double[][] exp(double[][] v1) {
        double[][] matrix = new double[v1.length][v1[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                matrix[i][j] = Math.exp(v1[i][j]);
            }
        }
        return matrix;
    }

    @Override
    public double[][] scalarInverse(double[][] m1) {
        double[][] matrix = new double[m1.length][m1[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                matrix[i][j] = 1.0 / m1[i][j];
            }
        }
        return matrix;
    }

    @Override
    public double[][] rnorm(int m, int n) {
        double[][] array = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                array[i][j] = this.dnrom(0.0, 1.0);
            }
        }
        return array;
    }

    @Override
    public boolean[][] equal(boolean[][] matrix1, boolean[][] matrix2) {
        boolean[][] equals = new boolean[matrix1.length][matrix1[0].length];
        if (matrix1.length != matrix2.length) {
            throw new IllegalArgumentException("Dimensions does not match");
        }
        if (matrix1[0].length != matrix2[0].length) {
            throw new IllegalArgumentException("Dimensions does not match");
        }
        for (int i = 0; i < matrix1.length; ++i) {
            for (int j = 0; j < matrix1[0].length; ++j) {
                equals[i][j] = matrix1[i][j] == matrix2[i][j];
            }
        }
        return equals;
    }

    @Override
    public boolean[][] biggerThan(double[][] matrix, double value) {
        boolean[][] equals = new boolean[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                equals[i][j] = Double.compare(matrix[i][j], value) == 1;
            }
        }
        return equals;
    }

    @Override
    public boolean[][] negate(boolean[][] booleans) {
        boolean[][] negates = new boolean[booleans.length][booleans[0].length];
        for (int i = 0; i < booleans.length; ++i) {
            for (int j = 0; j < booleans[0].length; ++j) {
                negates[i][j] = !booleans[i][j];
            }
        }
        return negates;
    }

    @Override
    public double[][] abs(boolean[][] booleans) {
        double[][] absolutes = new double[booleans.length][booleans[0].length];
        for (int i = 0; i < booleans.length; ++i) {
            for (int j = 0; j < booleans[0].length; ++j) {
                absolutes[i][j] = booleans[i][j] ? 1.0 : 0.0;
            }
        }
        return absolutes;
    }

    @Override
    public double[][] sum(double[][] matrix, int axis) {
        double[][] result;
        if (axis == 0) {
            result = new double[1][matrix[0].length];
            for (int j = 0; j < matrix[0].length; ++j) {
                double rowsum = 0.0;
                for (int i = 0; i < matrix.length; ++i) {
                    rowsum += matrix[i][j];
                }
                result[0][j] = rowsum;
            }
        } else if (axis == 1) {
            result = new double[matrix.length][1];
            for (int i = 0; i < matrix.length; ++i) {
                double colsum = 0.0;
                for (int j = 0; j < matrix[0].length; ++j) {
                    colsum += matrix[i][j];
                }
                result[i][0] = colsum;
            }
        } else {
            throw new IllegalArgumentException("Axes other than 0,1 is unsupported");
        }
        return result;
    }

    @Override
    public double sum(double[][] matrix) {
        double sum = 0.0;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                sum += matrix[i][j];
            }
        }
        return sum;
    }

    @Override
    public double[][] maximum(double[][] matrix, double maxval) {
        double[][] maxed = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                maxed[i][j] = matrix[i][j] > maxval ? matrix[i][j] : maxval;
            }
        }
        return maxed;
    }

    @Override
    public void assignAllLessThan(double[][] matrix, double lessthan, double assign) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                if (!(matrix[i][j] < lessthan)) continue;
                matrix[i][j] = assign;
            }
        }
    }

    @Override
    public double[][] square(double[][] matrix) {
        return this.scalarPow(matrix, 2.0);
    }

    @Override
    public double[][] scalarPow(double[][] matrix, double power) {
        double[][] result = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                double[] dArray = result[i];
                int n = j;
                dArray[n] = dArray[n] + Math.pow(matrix[i][j], power);
            }
        }
        return result;
    }

    @Override
    public double[][] addColumnVector(double[][] matrix, double[][] colvector) {
        double[][] result = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                result[i][j] = matrix[i][j] + colvector[i][0];
            }
        }
        return result;
    }

    @Override
    public double[][] addRowVector(double[][] matrix, double[][] rowvector) {
        double[][] result = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                result[i][j] = matrix[i][j] + rowvector[0][j];
            }
        }
        return result;
    }

    @Override
    public double[][] tile(double[][] matrix, int rowtimes, int coltimes) {
        double[][] result = new double[matrix.length * rowtimes][matrix[0].length * coltimes];
        int resultrow = 0;
        for (int i = 0; i < rowtimes; ++i) {
            for (int j = 0; j < matrix.length; ++j) {
                int resultcol = 0;
                for (int k = 0; k < coltimes; ++k) {
                    for (int l = 0; l < matrix[0].length; ++l) {
                        result[resultrow][resultcol++] = matrix[j][l];
                    }
                }
                ++resultrow;
            }
        }
        return result;
    }

    @Override
    public int[] range(int n) {
        int[] result = new int[n];
        for (int i = 0; i < n; ++i) {
            result[i] = i;
        }
        return result;
    }

    @Override
    public int[] range(int a, int b) {
        if (b < a) {
            throw new IllegalArgumentException("b has to be larger than a");
        }
        int val = a;
        int[] result = new int[b - a];
        for (int i = 0; i < b - a; ++i) {
            result[i] = val++;
        }
        return result;
    }

    @Override
    public int[] concatenate(int[] v1, int[] v2) {
        int[] result = new int[v1.length + v2.length];
        int index = 0;
        int i = 0;
        while (i < v1.length) {
            result[index] = v1[index];
            ++i;
            ++index;
        }
        i = 0;
        while (i < v2.length) {
            result[index] = v2[i];
            ++i;
            ++index;
        }
        return result;
    }

    @Override
    public void assignAtIndex(double[][] num, int[] range, int[] range1, double value) {
        for (int j = 0; j < range.length; ++j) {
            num[range[j]][range1[j]] = value;
        }
    }

    @Override
    public double[][] getValuesFromRow(double[][] matrix, int row, int[] indicies) {
        double[][] values = new double[1][indicies.length];
        for (int j = 0; j < indicies.length; ++j) {
            values[0][j] = matrix[row][indicies[j]];
        }
        return values;
    }

    @Override
    public void assignValuesToRow(double[][] matrix, int row, int[] indicies, double[] values) {
        assert (indicies.length == values.length) : "Length of indicies and values have to be equal";
        for (int j = 0; j < indicies.length; ++j) {
            matrix[row][indicies[j]] = values[j];
        }
    }

    @Override
    public double[][] fillMatrix(int rows, int cols, double fillvalue) {
        double[][] matrix = new double[rows][cols];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                matrix[i][j] = fillvalue;
            }
        }
        return matrix;
    }

    @Override
    public double[][] plus(double[][] m1, double[][] m2) {
        double[][] matrix = new double[m1.length][m1[0].length];
        for (int i = 0; i < m1.length; ++i) {
            for (int j = 0; j < m1[0].length; ++j) {
                matrix[i][j] = m1[i][j] + m2[i][j];
            }
        }
        return matrix;
    }

    @Override
    public double[][] scalarPlus(double[][] m1, double m2) {
        double[][] matrix = new double[m1.length][m1[0].length];
        for (int i = 0; i < m1.length; ++i) {
            for (int j = 0; j < m1[0].length; ++j) {
                matrix[i][j] = m1[i][j] + m2;
            }
        }
        return matrix;
    }

    @Override
    public double[][] scalarDivide(double[][] numerator, double denom) {
        double[][] matrix = new double[numerator.length][numerator[0].length];
        for (int i = 0; i < numerator.length; ++i) {
            for (int j = 0; j < numerator[i].length; ++j) {
                matrix[i][j] = numerator[i][j] / denom;
            }
        }
        return matrix;
    }

    @Override
    public double[][] scalarMult(double[][] m1, double mul) {
        double[][] matrix = new double[m1.length][m1[0].length];
        for (int i = 0; i < m1.length; ++i) {
            for (int j = 0; j < m1[i].length; ++j) {
                matrix[i][j] = m1[i][j] * mul;
            }
        }
        return matrix;
    }

    @Override
    public double[][] times(double[][] a, double[][] b) {
        int a_m = a.length;
        int a_n = a[0].length;
        int b_n = b[0].length;
        double[][] matrix = new double[a_m][b_n];
        double[] bcolj = new double[a_n];
        for (int j = 0; j < b_n; ++j) {
            for (int k = 0; k < a_n; ++k) {
                bcolj[k] = b[k][j];
            }
            for (int i = 0; i < a_m; ++i) {
                double[] arowi = a[i];
                double s = 0.0;
                for (int k = 0; k < a_n; ++k) {
                    s += arowi[k] * bcolj[k];
                }
                matrix[i][j] = s;
            }
        }
        return matrix;
    }

    @Override
    public double[][] diag(double[][] ds) {
        boolean isLong = ds.length > ds[0].length;
        int dim = Math.max(ds.length, ds[0].length);
        double[][] result = new double[dim][dim];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result.length; ++j) {
                if (i != j) continue;
                result[i][j] = isLong ? ds[i][0] : ds[0][i];
            }
        }
        return result;
    }
}

