/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinates;

import com.macrofocus.coloring.MutableColoring;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormapping.MutableColorMapping;
import com.macrofocus.colormapping.implementation.SimpleColorMapping;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.properties.SimpleProperties;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.high_d.axis.AxisFactory;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.axis.hierarchy.AxisHierarchy;
import com.macrofocus.high_d.axis.hierarchy.DefaultAxisHierarchy;
import com.macrofocus.high_d.axis.locations.AxisLocations;
import com.macrofocus.high_d.axis.locations.DefaultAxisLocations;
import com.macrofocus.high_d.parallelcoordinates.AbstractParallelCoordinatesModel;
import com.macrofocus.high_d.parallelcoordinates.DefaultParallelCoordinatesSettings;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesSettings;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.DataFrameHelper;
import com.macrofocus.order.MutableVisibleOrder;
import com.macrofocus.visual.SimpleVisual;
import com.macrofocus.visual.SimpleVisualObjects;
import com.macrofocus.visual.Visual;
import com.macrofocus.visual.VisualObjects;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;

public class DefaultParallelCoordinatesModel<Color, Row, C>
extends AbstractParallelCoordinatesModel<Color, Row, C> {
    private DataFrame<Row, C, ?> dataFrame;
    private final Visual<Color, Row, C> visual;
    private final ParallelCoordinatesSettings settings;
    private final AxisHierarchy<Row, C> axisHierarchy;
    private final Map<AxisGroupModel, AxisLocations> axisLocationsMap = new WeakHashMap<AxisGroupModel, AxisLocations>();
    private final MutableProperties properties = new SimpleProperties();
    private final Property<Integer> maxDimensions = this.properties.createProperty((Object)"maxDimensions", (Object)Integer.MAX_VALUE);

    public DefaultParallelCoordinatesModel(ColorMapFactory<Color> colorMapFactory, CPFactory factory, DataFrame<Row, C, ?> dataFrame) {
        this(factory, dataFrame, (Visual<Color, Row, C>)new SimpleVisual((VisualObjects)new SimpleVisualObjects(dataFrame), (MutableColorMapping)new SimpleColorMapping(colorMapFactory, dataFrame)));
    }

    public DefaultParallelCoordinatesModel(CPFactory factory, DataFrame<Row, C, ?> dataFrame, Visual<Color, Row, C> visual) {
        this(dataFrame, visual, (AxisHierarchy<Row, C>)new DefaultAxisHierarchy(new AxisFactory(factory, dataFrame, null, null, (SingleSelection)visual.getProbing(), (Selection)visual.getSelection(), (MutableFilter)visual.getFilter()), factory, dataFrame, true, false, 10), new DefaultParallelCoordinatesSettings());
    }

    public DefaultParallelCoordinatesModel(DataFrame<Row, C, ?> dataFrame, Visual<Color, Row, C> visual, AxisHierarchy<Row, C> axisHierarchy, ParallelCoordinatesSettings settings) {
        this.dataFrame = dataFrame;
        this.visual = visual;
        this.axisHierarchy = axisHierarchy;
        this.settings = settings;
    }

    public void setDataFrame(DataFrame<Row, C, ?> dataFrame) {
        this.dataFrame = dataFrame;
    }

    @Override
    public int getObjectCount() {
        return this.dataFrame.getRowCount();
    }

    @Override
    public Visual<Color, Row, C> getVisual() {
        return this.visual;
    }

    @Override
    public MutableSingleSelection<Row> getProbing() {
        return this.visual.getProbing();
    }

    @Override
    public MutableSelection<Row> getSelection() {
        return this.visual.getSelection();
    }

    @Override
    public MutableFilter<Row> getFilter() {
        return this.visual.getFilter();
    }

    @Override
    public MutableColorMapping<Color, Row, C> getColorMapping() {
        return this.visual.getColorMapping();
    }

    @Override
    public MutableColoring<Color, Row> getColoring() {
        return this.visual.getColoring();
    }

    @Override
    public Row getObject(int index) {
        return (Row)this.dataFrame.getRowKey(index);
    }

    @Override
    public ParallelCoordinatesSettings getSettings() {
        return this.settings;
    }

    @Override
    public AxisHierarchy<Row, C> getAxisHierarchy() {
        return this.axisHierarchy;
    }

    @Override
    public Iterable<AxisModel> getSelectedAxis() {
        ArrayList<AxisModel> list = new ArrayList<AxisModel>();
        for (Object c : this.dataFrame.columns()) {
            AxisModel axisModel = this.getAxisHierarchy().getAxisModel(c);
            MutableProperty buttonModel = axisModel.getButtonModel();
            if (!((Boolean)buttonModel.getValue()).booleanValue()) continue;
            list.add(axisModel);
        }
        return list;
    }

    @Override
    public boolean isHidden(AxisModel axisModel) {
        return !this.axisHierarchy.getAxisGroup(axisModel).getAxisOrder().isVisible((Object)axisModel);
    }

    @Override
    public void setHidden(AxisModel axisModel, boolean hidden) {
        this.axisHierarchy.getAxisGroup(axisModel).getAxisOrder().setVisible((Object)axisModel, !hidden);
        this.fireParallelCoordinatesChanged();
    }

    @Override
    public void unhideAllAxis() {
        for (AxisGroupModel axisGroup : this.axisHierarchy.getAxisGroupHierarchy().breadthFirstIterator()) {
            for (AxisModel axisModel : axisGroup.getAxisModels()) {
                this.setHidden(axisModel, false);
            }
        }
        this.fireParallelCoordinatesChanged();
    }

    @Override
    public AxisLocations getAxisLocations(AxisGroupModel group) {
        if (!this.axisLocationsMap.containsKey(group)) {
            DefaultAxisLocations value = new DefaultAxisLocations(group.getAxisOrder(), this.maxDimensions);
            this.axisLocationsMap.put(group, (AxisLocations)value);
            return value;
        }
        return this.axisLocationsMap.get(group);
    }

    @Override
    public void showAllNumerical() {
        MutableVisibleOrder axisOrder = ((AxisGroupModel)this.getAxisHierarchy().getAxisGroupHierarchy().getRoot()).getAxisOrder();
        for (AxisModel axisModel : axisOrder.iterableAll()) {
            if (!axisModel.isNumerical() || axisModel.getName() == null) continue;
            axisOrder.show((Object[])new AxisModel[]{axisModel});
        }
    }

    @Override
    public void makeDataRange(Iterable<AxisModel<Row, C>> axisModels) {
        for (AxisModel<Row, C> axisModel : axisModels) {
            DataFrameHelper.ColumnStatistics statistics = axisModel.getColumnStatistics();
            if (statistics.getMin() != null && statistics.getMax() != null) {
                axisModel.setMinMax(statistics.getMin().doubleValue(), statistics.getMax().doubleValue());
                continue;
            }
            axisModel.setMinMax(Double.NaN, Double.NaN);
        }
    }

    @Override
    public void makeCommonRange(Iterable<AxisModel<Row, C>> axisModels) {
        Number sharedMin = null;
        Number sharedMax = null;
        for (AxisModel<Row, C> axisModel : axisModels) {
            Double min = axisModel.getMinimum();
            Double max = axisModel.getMaximum();
            if (min == null || max == null) continue;
            double minimum = min;
            double maximum = max;
            if (Double.isNaN(minimum) || Double.isNaN(maximum)) continue;
            if (sharedMin == null || sharedMin.doubleValue() > minimum) {
                sharedMin = min;
            }
            if (sharedMax != null && !(sharedMax.doubleValue() < maximum)) continue;
            sharedMax = max;
        }
        if (sharedMin != null && sharedMax != null) {
            for (AxisModel<Row, C> axisModel : axisModels) {
                axisModel.setMinMax(sharedMin.doubleValue(), sharedMax.doubleValue());
                axisModel.getInterval().setValue(sharedMin.doubleValue(), sharedMax.doubleValue() - sharedMin.doubleValue());
            }
        }
    }

    @Override
    public void resetRanges(Iterable<AxisModel<Row, C>> axisModels) {
        for (AxisModel<Row, C> axisModel : axisModels) {
            axisModel.getInterval().setValue(axisModel.getMinimum(), axisModel.getMaximum() - axisModel.getMinimum());
        }
    }
}

