/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.scatterplot;

import com.macrofocus.coloring.MutableColoring;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormapping.MutableColorMapping;
import com.macrofocus.colormapping.implementation.SimpleColorMapping;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SimpleSingleSelection;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.filter.Filter;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.axis.group.DefaultAxisGroupModel;
import com.macrofocus.high_d.scatterplot.AbstractScatterPlotModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.visual.SimpleVisual;
import com.macrofocus.visual.SimpleVisualObjects;
import com.macrofocus.visual.Visual;
import com.macrofocus.visual.VisualObjects;

public class DefaultScatterPlotModel<Color, Row, C>
extends AbstractScatterPlotModel<Color, Row, C>
implements VisualObjects<Row> {
    private final DataFrame<Row, C, ?> dataFrame;
    private final DataFrame<?, C, ?> annotationDataFrame;
    private final Visual<Color, Row, C> visual;
    private final MutableSingleSelection<AxisModel<Row, C>> x = new SimpleSingleSelection();
    private final MutableSingleSelection<AxisModel<Row, C>> y = new SimpleSingleSelection();
    private final MutableSingleSelection<AxisModel<Row, C>> y2 = new SimpleSingleSelection();
    private final MutableSingleSelection<AxisModel> size = new SimpleSingleSelection();
    private final AxisGroupModel<Row, C> root;
    private AxisModel<Row, C> xAxisModel;
    private AxisModel<Row, C> yAxisModel;
    private AxisModel<Row, C> y2AxisModel;
    private AxisModel<Row, C> sizeAxisModel;

    public DefaultScatterPlotModel(CPFactory factory, ColorMapFactory<Color> colorMapFactory, DataFrame<Row, C, ?> dataFrame) {
        this(factory, colorMapFactory, dataFrame, (Visual<Color, Row, C>)new SimpleVisual((VisualObjects)new SimpleVisualObjects(dataFrame), (MutableColorMapping)new SimpleColorMapping(colorMapFactory, dataFrame)));
    }

    public DefaultScatterPlotModel(CPFactory factory, ColorMapFactory<Color> colorMapFactory, DataFrame<Row, C, ?> dataFrame, Visual<Color, Row, C> visual) {
        this(dataFrame, null, (Visual<Color, Row, C>)new SimpleVisual((VisualObjects)new SimpleVisualObjects(dataFrame), (MutableColorMapping)new SimpleColorMapping(colorMapFactory, dataFrame)), (AxisGroupModel<Row, C>)new DefaultAxisGroupModel(factory, "Root", dataFrame, null, (SingleSelection)visual.getProbing(), (Selection)visual.getSelection(), (MutableFilter)visual.getFilter()));
    }

    public DefaultScatterPlotModel(DataFrame<Row, C, ?> dataFrame, DataFrame<?, C, ?> annotationDataFrame, Visual<Color, Row, C> visual, AxisGroupModel<Row, C> root) {
        this.dataFrame = dataFrame;
        this.annotationDataFrame = annotationDataFrame;
        this.visual = visual;
        this.root = root;
        for (AxisModel axisModel : root.getAxisOrder()) {
            if (!axisModel.isNumerical()) continue;
            if (this.xAxisModel == null) {
                this.xAxisModel = axisModel;
                continue;
            }
            if (this.yAxisModel != null) continue;
            this.yAxisModel = axisModel;
            break;
        }
        if (this.yAxisModel == null) {
            for (AxisModel axisModel : root.getAxisOrder()) {
                if (axisModel.isNumerical()) continue;
                if (this.xAxisModel == null) {
                    this.xAxisModel = axisModel;
                    continue;
                }
                if (this.yAxisModel != null) continue;
                this.yAxisModel = axisModel;
                break;
            }
        }
        this.sizeAxisModel = null;
        this.x.addSingleSelectionListener(new SingleSelectionListener<AxisModel<Row, C>>(){

            public void selectionChanged(SingleSelectionEvent<AxisModel<Row, C>> event) {
                DefaultScatterPlotModel.this.xAxisModel = (AxisModel)event.getCurrentSelection();
                DefaultScatterPlotModel.this.fireScatterPlotChanged();
            }
        });
        this.y.addSingleSelectionListener(new SingleSelectionListener<AxisModel<Row, C>>(){

            public void selectionChanged(SingleSelectionEvent<AxisModel<Row, C>> event) {
                DefaultScatterPlotModel.this.yAxisModel = (AxisModel)event.getCurrentSelection();
                DefaultScatterPlotModel.this.fireScatterPlotChanged();
            }
        });
        this.y2.addSingleSelectionListener(new SingleSelectionListener<AxisModel<Row, C>>(){

            public void selectionChanged(SingleSelectionEvent<AxisModel<Row, C>> event) {
                DefaultScatterPlotModel.this.y2AxisModel = (AxisModel)event.getCurrentSelection();
                DefaultScatterPlotModel.this.fireScatterPlotChanged();
            }
        });
        this.size.addSingleSelectionListener((SingleSelectionListener)new SingleSelectionListener<AxisModel>(){

            public void selectionChanged(SingleSelectionEvent<AxisModel> event) {
                DefaultScatterPlotModel.this.sizeAxisModel = (AxisModel)event.getCurrentSelection();
                DefaultScatterPlotModel.this.fireScatterPlotChanged();
            }
        });
        if (this.xAxisModel != null) {
            this.x.setSelected(this.xAxisModel);
        }
        if (this.yAxisModel != null) {
            this.y.setSelected(this.yAxisModel);
        }
        if (this.sizeAxisModel != null) {
            this.size.setSelected(this.sizeAxisModel);
        }
    }

    @Override
    public int getObjectCount() {
        return this.dataFrame.getRowCount();
    }

    @Override
    public Visual<Color, Row, C> getVisual() {
        return this.visual;
    }

    @Override
    public AxisGroupModel getAxisGroupModel() {
        return this.root;
    }

    @Override
    public MutableSingleSelection<Row> getProbing() {
        return this.visual.getProbing();
    }

    @Override
    public MutableSelection<Row> getSelection() {
        return this.visual.getSelection();
    }

    @Override
    public Filter<Row> getFilter() {
        return this.visual.getFilter();
    }

    @Override
    public MutableColorMapping<Color, Row, C> getColorMapping() {
        return this.visual.getColorMapping();
    }

    @Override
    public MutableColoring<Color, Row> getColoring() {
        return this.visual.getColoring();
    }

    @Override
    public Row getObject(int index) {
        return (Row)this.dataFrame.getRowKey(index);
    }

    @Override
    public MutableSingleSelection<AxisModel<Row, C>> getX() {
        return this.x;
    }

    @Override
    public MutableSingleSelection<AxisModel<Row, C>> getY() {
        return this.y;
    }

    @Override
    public MutableSingleSelection<AxisModel<Row, C>> getY2() {
        return this.y2;
    }

    @Override
    public MutableSingleSelection<AxisModel> getSize() {
        return this.size;
    }

    @Override
    public DataFrame getDataFrame() {
        return this.dataFrame;
    }

    @Override
    public DataFrame getAnnotationDataFrame() {
        return this.annotationDataFrame;
    }

    @Override
    public AxisModel<Row, C> getXAxisModel() {
        return this.xAxisModel;
    }

    @Override
    public AxisModel<Row, C> getYAxisModel() {
        return this.yAxisModel;
    }

    @Override
    public AxisModel getY2AxisModel() {
        return this.y2AxisModel;
    }

    @Override
    public AxisModel getSizeAxisModel() {
        return this.sizeAxisModel;
    }
}

