/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.axis;

import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.interval.SimpleBoundedInterval;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.high_d.axis.DefaultAxisModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.series.Series;
import com.macrofocus.molap.subset.SubsetDataFrame;
import com.macrofocus.utils.UniversalComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class CategoricalAxisModel<Row, C>
extends DefaultAxisModel<Row, C> {
    private List<Object> list;
    private Map<Object, Integer> index;

    /*
     * WARNING - void declaration
     */
    public CategoricalAxisModel(DataFrame<Row, C, ?> dataFrame, DataFrame<?, C, ?> annotationDataFrame, SubsetDataFrame<Row, C, ?> subsetDataFrame, C column, SingleSelection<Row> probing, Selection<Row> selection, MutableFilter<Row> mutableFilter) {
        super(var1_1, var2_2, var3_3, column, probing, selection, mutableFilter);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected MutableBoundedInterval createBoundedInterval() {
        void var1_1;
        this.min = this.getIndex().size() - 1;
        this.max = 0.0;
        SimpleBoundedInterval interval = new SimpleBoundedInterval(this.min, this.max - this.min, this.min, this.max);
        interval.setMinimumExtent(-(this.min - this.max));
        return var1_1;
    }

    @Override
    protected MutableBoundedInterval createScaledBoundedInterval() {
        return this.getInterval();
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Number getValue(Row row) {
        void var1_1;
        return ((DefaultAxisModel)this).getValue(0, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Number getValue(int layer, Row row) {
        Map<Object, Integer> index = this.getIndex();
        Series series = this.series[layer];
        if (series != null) {
            Integer n;
            void var3_4;
            void var2_3;
            Object v = series.get((Object)var2_3);
            assert (index != null);
            n = (Integer)var3_4.get(n);
            return n;
        }
        return null;
    }

    @Override
    public boolean isDegenerate() {
        return this.getIndex().size() == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedMinimum() {
        List<Object> l = this.getList();
        Object value = l.size() > 0 ? l.get(Math.max(0, (int)this.getMinimum())) : null;
        if (value != null) {
            void var1_1;
            return var1_1.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedMaximum() {
        List<Object> l = this.getList();
        Object value = l.size() > 0 ? l.get(Math.min(this.getIndex().size() - 1, (int)this.getMaximum())) : null;
        if (value != null) {
            void var1_1;
            return var1_1.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedValue(Row row) {
        void var1_1;
        return ((DefaultAxisModel)this).getFormattedValue(0, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedValue(int layer, Row row) {
        void var2_3;
        Object value = this.series[layer].get((Object)var2_3);
        if (value != null) {
            void var1_2;
            return var1_2.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedFloorValue(double value) {
        Object o = ((DefaultAxisModel)this).getOriginalFloorValue(value);
        if (o != null) {
            void var1_2;
            return var1_2.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedCeilValue(double value) {
        Object o = ((DefaultAxisModel)this).getOriginalCeilValue(value);
        if (o != null) {
            void var1_2;
            return var1_2.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedValue(double value) {
        double min;
        if (!this.getScaledInterval().isInvertedScale()) {
            double d = Math.max(value, this.getMinimum());
            min = Math.min(d, this.getMaximum());
        } else {
            double d = Math.max(value, this.getMaximum());
            min = Math.min(d, this.getMinimum());
        }
        Object v = this.getList().get((int)min);
        if (v != null) {
            void var1_2;
            return var1_2.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getOriginalFloorValue(double value) {
        double min;
        if (!this.getScaledInterval().isInvertedScale()) {
            double d = Math.max(value, this.getMinimum());
            min = Math.min(d, this.getMaximum());
        } else {
            void var1_1;
            double d = Math.max((double)var1_1, this.getMaximum());
            min = Math.min(d, this.getMinimum());
        }
        Object object = this.getList().get((int)Math.floor(min));
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getOriginalCeilValue(double value) {
        double min;
        if (!this.getScaledInterval().isInvertedScale()) {
            double d = Math.max(value, this.getMinimum());
            min = Math.min(d, this.getMaximum());
        } else {
            void var1_1;
            double d = Math.max((double)var1_1, this.getMaximum());
            min = Math.min(d, this.getMinimum());
        }
        Object object = this.getList().get((int)Math.ceil(min));
        return object;
    }

    private List<Object> getList() {
        if (this.index == null) {
            this.createIndex();
        }
        return this.list;
    }

    private Map<Object, Integer> getIndex() {
        if (this.index == null) {
            this.createIndex();
        }
        return this.index;
    }

    /*
     * WARNING - void declaration
     */
    private void createIndex() {
        void var1_1;
        TreeSet<Iterator<Object>> set = new TreeSet<Iterator<Object>>((Comparator<Iterator<Object>>)new UniversalComparator());
        for (Object r : this.dataFrame.rows()) {
            Iterator<Object> iterator;
            Object value;
            Series series = this.series[0];
            if (series == null || (value = series.get(r)) == null || !(value instanceof Comparable)) continue;
            set.add(iterator);
        }
        this.list = new ArrayList<Object>((Collection<Object>)var1_1);
        this.index = new HashMap<Object, Integer>();
        int i = 0;
        for (Object o : this.list) {
            this.index.put(o, i);
            ++i;
        }
    }
}

