/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.DelegateAction;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class TextComponentSearchable
extends Searchable
implements DocumentListener,
PropertyChangeListener {
    private Highlighter.HighlightPainter _highlightPainter;
    private static final Color DEFAULT_HIGHLIGHT_COLOR = new Color(204, 204, 255);
    private Color _highlightColor = null;
    private int _selectedIndex = -1;
    private HighlighCache _highlighCache = new HighlighCache();
    private String _text = null;

    public TextComponentSearchable(JTextComponent jTextComponent) {
        super(jTextComponent);
        this.installHighlightsRemover();
        this.setHighlightColor(DEFAULT_HIGHLIGHT_COLOR);
    }

    public void uninstallHighlightsRemover() {
        DelegateAction.restoreAction(this._component, 0, KeyStroke.getKeyStroke(27, 0));
    }

    public void installHighlightsRemover() {
        DelegateAction.replaceAction(this._component, 0, KeyStroke.getKeyStroke(27, 0), new DelegateAction(){
            private static final long serialVersionUID = 8572103995404313032L;

            @Override
            public boolean isDelegateEnabled() {
                Iterator iterator;
                if (TextComponentSearchable.this._component instanceof JTextComponent && !(iterator = TextComponentSearchable.this._highlighCache.getAllHighlights()).hasNext()) {
                    return false;
                }
                return super.isDelegateEnabled();
            }

            @Override
            public boolean delegateActionPerformed(ActionEvent actionEvent) {
                Iterator iterator;
                if (TextComponentSearchable.this._component instanceof JTextComponent && !(iterator = TextComponentSearchable.this._highlighCache.getAllHighlights()).hasNext()) {
                    return false;
                }
                TextComponentSearchable.this.removeAllHighlights();
                return true;
            }
        });
    }

    @Override
    public void installListeners() {
        super.installListeners();
        if (this._component instanceof JTextComponent) {
            ((JTextComponent)this._component).getDocument().addDocumentListener(this);
            this._component.addPropertyChangeListener("document", this);
        }
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JTextComponent) {
            ((JTextComponent)this._component).getDocument().removeDocumentListener(this);
            this._component.removePropertyChangeListener("document", this);
        }
    }

    @Override
    protected void setSelectedIndex(int n, boolean bl) {
        if (this._component instanceof JTextComponent) {
            if (n == -1) {
                this.removeAllHighlights();
                this._selectedIndex = -1;
                return;
            }
            if (!bl) {
                this.removeAllHighlights();
            }
            String string = this.getSearchingText();
            try {
                this.addHighlight(n, string, bl);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    protected void addHighlight(final int n, final String string, boolean bl) throws BadLocationException {
        if (this._component instanceof JTextComponent) {
            final JTextComponent jTextComponent = (JTextComponent)this._component;
            Object object = jTextComponent.getHighlighter().addHighlight(n, n + string.length(), this._highlightPainter);
            this._highlighCache.addHighlight(object);
            this._selectedIndex = n;
            if (!bl) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        TextComponentSearchable.this.scrollTextVisible(jTextComponent, n, string.length());
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    private void scrollTextVisible(JTextComponent jTextComponent, int n, int n2) {
        if (n != -1) {
            try {
                Rectangle rectangle = jTextComponent.modelToView(n);
                if (rectangle == null) {
                    return;
                }
                Rectangle rectangle2 = jTextComponent.modelToView(n + n2);
                if (rectangle2 == null) {
                    return;
                }
                Rectangle rectangle3 = this._component.getVisibleRect();
                if (rectangle.x <= rectangle3.width) {
                    rectangle.width = rectangle2.x;
                    rectangle.x = 0;
                } else {
                    rectangle.width = rectangle2.x - rectangle.x;
                }
                jTextComponent.scrollRectToVisible(rectangle);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    protected void removeAllHighlights() {
        if (this._component instanceof JTextComponent) {
            Iterator iterator = this._highlighCache.getAllHighlights();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                ((JTextComponent)this._component).getHighlighter().removeHighlight(e);
            }
            this._highlighCache.removeAllHighlights();
        }
    }

    @Override
    protected int getSelectedIndex() {
        if (this._component instanceof JTextComponent) {
            return this._selectedIndex;
        }
        return 0;
    }

    @Override
    protected Object getElementAt(int n) {
        String string = this.getSearchingText();
        if (string != null && this._component instanceof JTextComponent) {
            int n2;
            int n3 = n + string.length();
            if (n3 > (n2 = this.getElementCount())) {
                n3 = this.getElementCount();
            }
            try {
                return ((JTextComponent)this._component).getDocument().getText(n, n3 - n + 1);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return "";
    }

    @Override
    protected int getElementCount() {
        if (this._component instanceof JTextComponent) {
            return ((JTextComponent)this._component).getDocument().getLength();
        }
        return 0;
    }

    @Override
    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this._text = null;
            if (propertyChangeEvent.getOldValue() instanceof Document) {
                ((Document)propertyChangeEvent.getNewValue()).removeDocumentListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof Document) {
                ((Document)propertyChangeEvent.getNewValue()).addDocumentListener(this);
            }
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this._text = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this._text = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this._text = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    protected boolean isActivateKey(KeyEvent keyEvent) {
        if (this._component instanceof JTextComponent && ((JTextComponent)this._component).isEditable()) {
            return keyEvent.getID() == 401 && keyEvent.getKeyCode() == 70 && JideSwingUtilities.isMenuShortcutKeyDown(keyEvent);
        }
        return super.isActivateKey(keyEvent);
    }

    public Color getHighlightColor() {
        if (this._highlightColor != null) {
            return this._highlightColor;
        }
        return DEFAULT_HIGHLIGHT_COLOR;
    }

    public void setHighlightColor(Color color) {
        this._highlightColor = color;
        this._highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(this._highlightColor);
    }

    @Override
    public int findLast(String string) {
        if (this._component instanceof JTextComponent) {
            String string2 = this.getDocumentText();
            if (this.isCaseSensitive()) {
                return string2.lastIndexOf(string);
            }
            return TextComponentSearchable.lastIndexOf(string2, string, string2.length());
        }
        return super.findLast(string);
    }

    private String getDocumentText() {
        if (this._text == null) {
            Document document = ((JTextComponent)this._component).getDocument();
            try {
                String string;
                this._text = string = document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                return "";
            }
        }
        return this._text;
    }

    @Override
    public int findFirst(String string) {
        if (this._component instanceof JTextComponent) {
            String string2 = this.getDocumentText();
            if (this.isCaseSensitive()) {
                return string2.indexOf(string);
            }
            return TextComponentSearchable.indexOf(string2, string, 0);
        }
        return super.findFirst(string);
    }

    static int lastIndexOf(String string, String string2, int n) {
        int n2 = string.length();
        int n3 = string2.length();
        int n4 = n2 - n3;
        if (n < 0) {
            return -1;
        }
        if (n > n4) {
            n = n4;
        }
        if (n3 == 0) {
            return n;
        }
        char[] cArray = string2.toLowerCase().toCharArray();
        char[] cArray2 = string2.toUpperCase().toCharArray();
        int n5 = n3 - 1;
        int n6 = n3 - 1;
        int n7 = n6 + n;
        while (n7 >= n6) {
            while (n7 >= n6 && string.charAt(n7) != cArray[n5] && string.charAt(n7) != cArray2[n5]) {
                --n7;
            }
            if (n7 < n6) break;
            int n8 = n7 - 1;
            int n9 = n8 - (n3 - 1);
            int n10 = n5 - 1;
            while (n8 > n9) {
                char c2 = string.charAt(n8);
                if (c2 != cArray[n10] && c2 != cArray2[n10]) {
                    --n7;
                    break;
                }
                --n8;
                --n10;
            }
            if (n8 > n9) continue;
            return n9 + 1;
        }
        return -1;
    }

    private static int indexOf(String string, String string2, int n) {
        int n2 = string.length();
        int n3 = string2.length();
        if (n >= n2) {
            return n3 == 0 ? n2 : -1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n3 == 0) {
            return n;
        }
        char[] cArray = string2.toLowerCase().toCharArray();
        char[] cArray2 = string2.toUpperCase().toCharArray();
        int n4 = n2 - n3;
        for (int i = n; i <= n4; ++i) {
            char c2;
            int n5;
            char c3 = string.charAt(i);
            if (c3 != cArray[0] && c3 != cArray2[0]) {
                ++i;
                while (i <= n4 && string.charAt(i) != cArray[0] && string.charAt(i) != cArray2[0]) {
                    ++i;
                }
            }
            if (i > n4) continue;
            int n6 = n5 + n3 - 1;
            int n7 = 1;
            for (n5 = i + 1; n5 < n6 && ((c2 = string.charAt(n5)) == cArray[n7] || c2 == cArray2[n7]); ++n5) {
                ++n7;
            }
            if (n5 != n6) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int findFromCursor(String string) {
        int n;
        int n2;
        String string2;
        if (this.isCountMatch()) {
            string2 = this.getDocumentText();
            n2 = 0;
            this._matchCount = -1;
            do {
                n = n2;
                n2 = (this.isCaseSensitive() ? string2.indexOf(string, n) : TextComponentSearchable.indexOf(string2, string, n)) + 1;
                ++this._matchCount;
            } while (n2 > n);
        }
        if (this.isReverseOrder()) {
            return this.reverseFindFromCursor(string);
        }
        if (this._component instanceof JTextComponent) {
            int n3;
            string2 = this.getDocumentText();
            int n4 = n = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (n < 0) {
                n = 0;
            }
            if ((n2 = this.getElementCount()) == 0) {
                return string.length() > 0 ? -1 : 0;
            }
            int n5 = n3 = this.isCaseSensitive() ? string2.indexOf(string, n) : TextComponentSearchable.indexOf(string2, string, n);
            if (n3 == -1) {
                int n6 = n3 = this.isCaseSensitive() ? string2.indexOf(string, 0) : TextComponentSearchable.indexOf(string2, string, 0);
                if (n3 >= n) {
                    n3 = -1;
                }
            }
            return n3;
        }
        return super.findFromCursor(string);
    }

    @Override
    public int reverseFindFromCursor(String string) {
        if (!this.isReverseOrder()) {
            return this.findFromCursor(string);
        }
        if (this._component instanceof JTextComponent) {
            int n;
            int n2;
            int n3;
            String string2 = this.getDocumentText();
            int n4 = n3 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (n3 < 0) {
                n3 = 0;
            }
            if ((n2 = this.getElementCount()) == 0) {
                return string.length() > 0 ? -1 : 0;
            }
            int n5 = n = this.isCaseSensitive() ? string2.lastIndexOf(string, n3) : TextComponentSearchable.lastIndexOf(string2, string, n3);
            if (n == -1) {
                int n6 = n = this.isCaseSensitive() ? string2.lastIndexOf(string, string2.length() - 1) : TextComponentSearchable.lastIndexOf(string2, string, string2.length() - 1);
                if (n <= n3) {
                    n = -1;
                }
            }
            return n;
        }
        return super.findFromCursor(string);
    }

    @Override
    public int findNext(String string) {
        if (this._component instanceof JTextComponent) {
            int n;
            int n2;
            int n3;
            String string2 = this.getDocumentText();
            int n4 = n3 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (n3 < 0) {
                n3 = 0;
            }
            if ((n2 = this.getElementCount()) == 0) {
                return string.length() > 0 ? -1 : 0;
            }
            int n5 = n = this.isCaseSensitive() ? string2.indexOf(string, n3 + 1) : TextComponentSearchable.indexOf(string2, string, n3 + 1);
            if (n == -1 && this.isRepeats()) {
                int n6 = n = this.isCaseSensitive() ? string2.indexOf(string, 0) : TextComponentSearchable.indexOf(string2, string, 0);
                if (n > n3) {
                    n = -1;
                }
            }
            return n;
        }
        return super.findNext(string);
    }

    @Override
    public int findPrevious(String string) {
        if (this._component instanceof JTextComponent) {
            int n;
            int n2;
            int n3;
            String string2 = this.getDocumentText();
            int n4 = n3 = this.getCursor() != -1 ? this.getCursor() : this.getSelectedIndex();
            if (n3 < 0) {
                n3 = 0;
            }
            if ((n2 = this.getElementCount()) == 0) {
                return string.length() > 0 ? -1 : 0;
            }
            int n5 = n = this.isCaseSensitive() ? string2.lastIndexOf(string, n3 - 1) : TextComponentSearchable.lastIndexOf(string2, string, n3 - 1);
            if (n == -1 && this.isRepeats()) {
                int n6 = n = this.isCaseSensitive() ? string2.lastIndexOf(string, n2 - 1) : TextComponentSearchable.lastIndexOf(string2, string, n2 - 1);
                if (n < n3) {
                    n = -1;
                }
            }
            return n;
        }
        return super.findPrevious(string);
    }

    @Override
    public void hidePopup() {
        super.hidePopup();
        this._selectedIndex = -1;
    }

    @Override
    protected void searchingTextEmpty() {
        this.setSelectedIndex(-1, false);
    }

    private class HighlighCache
    extends HashMap {
        private HighlighCache() {
        }

        public void addHighlight(Object object) {
            this.put(object, null);
        }

        public void removeHighlight(Object object) {
            this.remove(object);
        }

        public Iterator getAllHighlights() {
            return this.keySet().iterator();
        }

        public void removeAllHighlights() {
            this.clear();
        }
    }
}

