/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot;

import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.swing.SwingIGraphics;
import com.macrofocus.plot.AbstractAxisPlotPanel;
import com.macrofocus.plot.guide.Guide;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;

public class SwingAxisPlotPanel
extends AbstractAxisPlotPanel<JComponent, Color, Font> {
    private JPanel panel = new JPanel(){

        @Override
        public void setBounds(int x, int y, int width, int height) {
            Rectangle c = this.getBounds();
            if (x != c.x || y != c.y || width != c.width || height != c.height) {
                super.setBounds(x, y, width, height);
                SwingAxisPlotPanel.this.valideAxis();
            }
        }

        @Override
        public void setSize(int width, int height) {
            Rectangle c = this.getBounds();
            if (width != c.width || height != c.height) {
                super.setSize(width, height);
                SwingAxisPlotPanel.this.valideAxis();
            }
        }
    };
    private JPanel snapshotPanel;
    private JPanel mainContainer;
    private JPanel rightYAxisContainer;
    private JPanel bottomTimeAxisContainer;
    private JPanel leftYAxisContainer;
    private JPanel topTimeAxisContainer;

    public SwingAxisPlotPanel() {
        this.panel.setLayout(new CustomLayoutManager(this));
        this.panel.setOpaque(false);
        this.topTimeAxisContainer = new JPanel();
        this.topTimeAxisContainer.setLayout(new OverlayLayout(this.topTimeAxisContainer));
        this.topTimeAxisContainer.setVisible(false);
        this.panel.add(this.topTimeAxisContainer);
        this.snapshotPanel = new JPanel();
        this.snapshotPanel.setLayout(null);
        this.panel.add(this.snapshotPanel);
        this.mainContainer = new JPanel();
        this.mainContainer.setLayout(new GridBagLayout());
        this.snapshotPanel.add(this.mainContainer);
        this.leftYAxisContainer = new JPanel();
        this.leftYAxisContainer.setLayout(new GridBagLayout());
        this.leftYAxisContainer.setVisible(false);
        this.snapshotPanel.add(this.leftYAxisContainer);
        this.bottomTimeAxisContainer = new JPanel();
        this.bottomTimeAxisContainer.setLayout(new GridBagLayout());
        this.bottomTimeAxisContainer.setVisible(false);
        this.snapshotPanel.add(this.bottomTimeAxisContainer);
        this.rightYAxisContainer = new JPanel();
        this.rightYAxisContainer.setLayout(new GridBagLayout());
        this.rightYAxisContainer.setVisible(false);
        this.panel.add(this.rightYAxisContainer);
        this.mainContainer.setLayout(new OverlayLayout(this.mainContainer));
        this.mainContainer.setInheritsPopupMenu(true);
        this.leftYAxisContainer.setLayout(new OverlayLayout(this.leftYAxisContainer));
        this.rightYAxisContainer.setLayout(new OverlayLayout(this.rightYAxisContainer));
        this.bottomTimeAxisContainer.setLayout(new OverlayLayout(this.bottomTimeAxisContainer));
        this.panel.validate();
    }

    public SwingAxisPlotPanel(Guide<JComponent, Color, Font> xGuide, Guide<JComponent, Color, Font> yGuide) {
        this();
        this.xGuide = xGuide;
        this.yGuide = yGuide;
        this.addBottomTimeAxisComponent((JComponent)xGuide.getNativeComponent());
        this.addLeftYAxisComponent((JComponent)yGuide.getNativeComponent());
    }

    public void setStyleClass(String ... styleClasses) {
    }

    public JComponent getNativeComponent() {
        return this.panel;
    }

    public JPanel getMainContainer() {
        return this.mainContainer;
    }

    public JPanel getRightYAxisContainer() {
        return this.rightYAxisContainer;
    }

    public JPanel getBottomTimeAxisContainer() {
        return this.bottomTimeAxisContainer;
    }

    public JPanel getLeftYAxisContainer() {
        return this.leftYAxisContainer;
    }

    public JPanel getTopTimeAxisContainer() {
        return this.topTimeAxisContainer;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public JPanel getSnapshotPanel() {
        return this.snapshotPanel;
    }

    public void valideAxis() {
        boolean topAxisVisible = this.showTopTimeAxis;
        boolean bottomAxisVisible = this.showBottomTimeAxis && this.xGuide != null;
        boolean leftAxisVisible = this.showLeftYAxis && this.yGuide != null;
        this.setTopAxisVisible(topAxisVisible);
        this.setBottomAxisVisible(bottomAxisVisible);
        this.setLeftAxisVisible(leftAxisVisible);
        if (topAxisVisible) {
            Dimension topAxisPreferredSize = this.getTopAxisPreferredSize();
        } else {
            Dimension topAxisPreferredSize = new Dimension(0, 0);
        }
        Dimension bottomAxisPreferredSize = bottomAxisVisible ? this.getBottomAxisPreferredSize() : new Dimension(0, 0);
        Dimension leftAxisPreferredSize = leftAxisVisible ? this.getLeftAxisPreferredSize() : new Dimension(0, 0);
        this.setBottomAxisSize(bottomAxisPreferredSize);
        this.setLeftAxisSize(leftAxisPreferredSize);
        if (this.getNativeComponent().isPaintingForPrint()) {
            this.getNativeComponent().doLayout();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingAxisPlotPanel.this.getNativeComponent().validate();
                }
            });
        }
    }

    public Dimension getTopAxisPreferredSize() {
        if (this.showTopTimeAxis && this.getTopTimeAxisContainer() != null) {
            return this.getTopTimeAxisContainer().getPreferredSize();
        }
        return new Dimension(0, 0);
    }

    public Dimension getBottomAxisPreferredSize() {
        if (this.showBottomTimeAxis && this.xGuide != null) {
            Rectangle dataArea = this.getNativeComponent().getBounds();
            Graphics2D g2 = (Graphics2D)this.getNativeComponent().getGraphics();
            double space = this.xGuide.computeSpace((IGraphics)new SwingIGraphics(g2), dataArea);
            return new Dimension(this.getMainContainer().getBounds().width, (int)space);
        }
        return new Dimension(0, 0);
    }

    public Dimension getLeftAxisPreferredSize() {
        if (this.showLeftYAxis && this.yGuide != null) {
            Rectangle dataArea = this.getNativeComponent().getBounds();
            Graphics2D g2 = (Graphics2D)this.getNativeComponent().getGraphics();
            double space = this.yGuide.computeSpace((IGraphics)new SwingIGraphics(g2), dataArea);
            return new Dimension((int)space, this.getMainContainer().getBounds().height);
        }
        return new Dimension(0, 0);
    }

    public Dimension getRightAxisPreferredSize() {
        if (this.showRightYAxis) {
            return this.getRightYAxisContainer().getPreferredSize();
        }
        return new Dimension(0, 0);
    }

    public void addComponent(JComponent component) {
        if (this.getMainContainer() != null) {
            this.getMainContainer().add(component);
        }
    }

    public void addBottomTimeAxisComponent(JComponent component) {
        if (this.getBottomTimeAxisContainer() != null) {
            this.getBottomTimeAxisContainer().add(component);
            this.valideAxis();
        }
    }

    public void addTopTimeAxisComponent(JComponent component) {
        if (this.getTopTimeAxisContainer() != null) {
            this.getTopTimeAxisContainer().add(component);
            this.valideAxis();
        }
    }

    public void addLeftYAxisComponent(JComponent component) {
        if (this.getLeftYAxisContainer() != null) {
            this.getLeftYAxisContainer().add(component);
            this.valideAxis();
        }
    }

    public void addRightYAxisComponent(JComponent component) {
        if (this.getRightYAxisContainer() != null) {
            this.getRightYAxisContainer().add(component);
            this.valideAxis();
        }
    }

    public void setLeftAxisSize(Dimension d) {
        this.getLeftYAxisContainer().setPreferredSize(d);
        this.getNativeComponent().validate();
        this.getNativeComponent().repaint();
    }

    public void setTopAxisSize(Dimension d) {
        this.getTopTimeAxisContainer().setPreferredSize(d);
        this.getNativeComponent().validate();
        this.getNativeComponent().repaint();
    }

    public void setBottomAxisSize(Dimension d) {
        this.getBottomTimeAxisContainer().setPreferredSize(d);
        this.getNativeComponent().validate();
        this.getNativeComponent().repaint();
    }

    public void setLeftAxisVisible(boolean visible) {
        if (this.getLeftYAxisContainer().isVisible() != visible) {
            this.getLeftYAxisContainer().setVisible(visible);
            this.getLeftYAxisContainer().revalidate();
            this.getNativeComponent().validate();
            this.getNativeComponent().repaint();
        }
    }

    public void setRightAxisVisible(boolean visible) {
        if (this.getRightYAxisContainer().isVisible() != visible) {
            this.getRightYAxisContainer().setVisible(visible);
            this.getRightYAxisContainer().revalidate();
            this.getNativeComponent().validate();
            this.getNativeComponent().repaint();
        }
    }

    public void setTopAxisVisible(boolean visible) {
        if (this.getTopTimeAxisContainer().isVisible() != visible) {
            this.getTopTimeAxisContainer().setVisible(visible);
            this.getTopTimeAxisContainer().revalidate();
            this.getNativeComponent().validate();
            this.getNativeComponent().repaint();
        }
    }

    public void setBottomAxisVisible(boolean visible) {
        if (this.getBottomTimeAxisContainer().isVisible() != visible) {
            this.getBottomTimeAxisContainer().setVisible(visible);
            this.getBottomTimeAxisContainer().revalidate();
            this.getNativeComponent().validate();
            this.getNativeComponent().repaint();
        }
    }

    private class CustomLayoutManager
    implements LayoutManager {
        SwingAxisPlotPanel axisPlotPanel;

        private CustomLayoutManager(SwingAxisPlotPanel axisPlotPanel) {
            this.axisPlotPanel = axisPlotPanel;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int width = SwingAxisPlotPanel.this.getMainContainer().getPreferredSize().width + SwingAxisPlotPanel.this.getLeftAxisPreferredSize().width + SwingAxisPlotPanel.this.getRightYAxisContainer().getPreferredSize().width;
            int height = SwingAxisPlotPanel.this.getMainContainer().getPreferredSize().height + SwingAxisPlotPanel.this.getTopTimeAxisContainer().getPreferredSize().height + SwingAxisPlotPanel.this.getBottomAxisPreferredSize().height;
            return new Dimension(width, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            int width = SwingAxisPlotPanel.this.getMainContainer().getMinimumSize().width + SwingAxisPlotPanel.this.getLeftAxisPreferredSize().width + SwingAxisPlotPanel.this.getRightYAxisContainer().getMinimumSize().width;
            int height = SwingAxisPlotPanel.this.getMainContainer().getMinimumSize().height + SwingAxisPlotPanel.this.getTopTimeAxisContainer().getMinimumSize().height + SwingAxisPlotPanel.this.getBottomAxisPreferredSize().height;
            return new Dimension(width, height);
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension d = parent.getSize();
            int x1 = SwingAxisPlotPanel.this.getLeftAxisPreferredSize().width;
            int x2 = d.width - SwingAxisPlotPanel.this.getRightYAxisContainer().getPreferredSize().width;
            int y1 = SwingAxisPlotPanel.this.getTopAxisPreferredSize().height;
            int y2 = d.height - SwingAxisPlotPanel.this.getBottomTimeAxisContainer().getPreferredSize().height;
            SwingAxisPlotPanel.this.snapshotPanel.setBounds(0, y1, x2, d.height - y1);
            SwingAxisPlotPanel.this.topTimeAxisContainer.setBounds(x1, 0, x2 - x1, y1);
            SwingAxisPlotPanel.this.rightYAxisContainer.setBounds(x2, y1, d.width - x2, y2 - y1);
            SwingAxisPlotPanel.this.leftYAxisContainer.setBounds(0, 0, x1, y2 - y1);
            SwingAxisPlotPanel.this.bottomTimeAxisContainer.setBounds(x1, d.height - y1 - (d.height - y2), x2 - x1, d.height - y2);
            SwingAxisPlotPanel.this.mainContainer.setBounds(x1, 0, x2 - x1, y2 - y1);
        }
    }
}

