/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot.guide;

import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.format.CPFormat;
import com.macrofocus.format.FormatFactory;
import com.macrofocus.format.swing.SwingFormatFactory;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.igraphics.CPFontFactory;
import com.macrofocus.igraphics.CPFontMetrics;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.IHeadless;
import com.macrofocus.igraphics.swing.SwingColor;
import com.macrofocus.igraphics.swing.SwingFont;
import com.macrofocus.igraphics.swing.SwingIHeadless;
import com.macrofocus.plot.guide.AbstractSwingGuide;
import com.macrofocus.plot.guide.AxisGuide;
import com.macrofocus.plot.guide.AxisSpace;
import com.macrofocus.plot.guide.Guide;
import com.macrofocus.plot.guide.NumberAxis;
import com.macrofocus.plot.guide.RectangleEdge;
import com.macrofocus.plot.guide.ValueAxis;
import com.macrofocus.plot.guide.ValueTick;
import com.macrofocus.transform.OneDScreenTransform;
import com.macrofocus.transform.ScreenTransformEvent;
import com.macrofocus.transform.ScreenTransformListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JComponent;

public abstract class AbstractSwingAxisGuide
extends AbstractSwingGuide
implements AxisGuide<JComponent, Color, Font> {
    private CPColor labelColor = new SwingColor(Color.black);
    private CPColor gridLinesColor = new SwingColor(199, 199, 196);
    private boolean paintTicks = true;
    private final Guide.Type type;
    private final ScreenTransformListener coordinateAxisListener = new ScreenTransformListener(){

        public void transformChanged(ScreenTransformEvent event) {
            AbstractSwingAxisGuide.this.refresh();
        }
    };
    private OneDScreenTransform coordinateAxis;
    private ValueAxis axis;
    private CPFormat format;

    private void refresh() {
        this.revalidate();
        this.repaint();
    }

    public AbstractSwingAxisGuide(Guide.Type type, OneDScreenTransform coordinateAxis) {
        this(type);
        this.setCoordinateAxis(coordinateAxis);
    }

    public AbstractSwingAxisGuide(OneDScreenTransform coordinateAxis) {
        this(Guide.Type.Bottom);
        this.setCoordinateAxis(coordinateAxis);
    }

    public AbstractSwingAxisGuide(Guide.Type type) {
        this.type = type;
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                AbstractSwingAxisGuide.this.refresh();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                AbstractSwingAxisGuide.this.refresh();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    public AbstractSwingAxisGuide() {
        this(Guide.Type.Bottom);
    }

    public void setCoordinateAxis(OneDScreenTransform coordinateAxis) {
        if (this.coordinateAxis != null) {
            this.coordinateAxis.removeScreenTransformListener(this.coordinateAxisListener);
        }
        this.coordinateAxis = coordinateAxis;
        if (this.coordinateAxis != null) {
            this.coordinateAxis.addScreenTransformListener(this.coordinateAxisListener);
        }
        this.refresh();
    }

    public double computeSpace(IGraphics g2, Rectangle dataArea) {
        AxisSpace space = new AxisSpace();
        switch (this.type) {
            case Top: {
                this.getAxis().reserveSpace(g2, (Rectangle2D)dataArea, RectangleEdge.Top, space);
                return space.getBottom();
            }
            case Bottom: {
                this.getAxis().reserveSpace(g2, (Rectangle2D)dataArea, RectangleEdge.Bottom, space);
                return space.getBottom() + 4.0;
            }
            case Left: {
                this.getAxis().reserveSpace(g2, (Rectangle2D)dataArea, RectangleEdge.Left, space);
                return space.getLeft();
            }
            case Right: {
                this.getAxis().reserveSpace(g2, (Rectangle2D)dataArea, RectangleEdge.Right, space);
                return space.getLeft();
            }
        }
        throw new IllegalArgumentException();
    }

    public void setFormat(CPFormat format) {
        this.format = format;
        if (this.axis != null) {
            this.axis.setFormatOverride(this.format);
        }
        this.refresh();
    }

    public void drawGrid(IGraphics g2, Dimension d) {
        this.gridRenderer.drawGrid(g2, this.type, this.coordinateAxis, this.getAxis(), this.gridLineRenderer, d);
    }

    public void paintComponent(IGraphics g) {
        double max;
        double min;
        Dimension d = this.getSize();
        if (this.coordinateAxis != null && (min = Math.min(this.coordinateAxis.getWorldMin(), this.coordinateAxis.getWorldMax())) <= (max = Math.max(this.coordinateAxis.getWorldMin(), this.coordinateAxis.getWorldMax()))) {
            List ticks;
            Rectangle2D.Float dataArea = new Rectangle2D.Float(0.0f, 0.0f, d.width, d.height);
            this.getAxis().setRange(min, max);
            switch (this.type) {
                case Top: {
                    ticks = this.getAxis().refreshTicks(g, (Rectangle2D)dataArea, RectangleEdge.Top);
                    break;
                }
                case Bottom: {
                    ticks = this.getAxis().refreshTicks(g, (Rectangle2D)dataArea, RectangleEdge.Bottom);
                    break;
                }
                case Left: {
                    ticks = this.getAxis().refreshTicks(g, (Rectangle2D)dataArea, RectangleEdge.Left);
                    break;
                }
                case Right: {
                    ticks = this.getAxis().refreshTicks(g, (Rectangle2D)dataArea, RectangleEdge.Right);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            for (ValueTick tick : ticks) {
                int position = this.coordinateAxis.worldToScreen(tick.getValue());
                if (this.paintTicks) {
                    g.setColor(this.gridLinesColor);
                    switch (this.type) {
                        case Top: {
                            g.drawLine(position, d.height - 5, position, d.height);
                            break;
                        }
                        case Bottom: {
                            g.drawLine(position, 0, position, 5);
                            break;
                        }
                        case Left: {
                            g.drawLine(d.width - 5, position, d.width, position);
                            break;
                        }
                        case Right: {
                            g.drawLine(0, position, 5, position);
                        }
                    }
                }
                g.setColor(this.labelColor);
                String text = tick.getText();
                if (text == null || text.length() <= 0) continue;
                double parsed = Double.NaN;
                if (this.format != null) {
                    try {
                        Object parse = this.format.parse(text);
                        if (parse instanceof Number) {
                            parsed = ((Number)parse).doubleValue();
                        }
                    }
                    catch (CPFormat.ParsingException parse) {}
                } else {
                    try {
                        parsed = Double.parseDouble(text);
                    }
                    catch (NumberFormatException parse) {
                        // empty catch block
                    }
                }
                if (!(Math.abs(parsed - tick.getValue()) < 1.0E-9)) continue;
                CPFontMetrics fontMetrics = g.getFontMetrics();
                int width = (int)g.getStringWidth(text);
                switch (this.type) {
                    case Top: {
                        g.drawString(text, (float)(position - (width >> 1)), fontMetrics.getHeight());
                        break;
                    }
                    case Bottom: {
                        g.drawString(text, (float)(position - (width >> 1)), (float)(d.height - 2));
                        break;
                    }
                    case Left: {
                        g.drawString(text, (float)(d.width - width - 7), (float)(position + (fontMetrics.getAscent() >> 1)));
                        break;
                    }
                    case Right: {
                        g.drawString(text, 7.0f, (float)(position + (fontMetrics.getAscent() >> 1)));
                    }
                }
            }
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.getAxis().setTickLabelFont((CPFont)new SwingFont(font));
    }

    private ValueAxis getAxis() {
        if (this.axis == null) {
            this.axis = new NumberAxis((CPFontFactory)SwingFactory.getInstance(), (IHeadless)new SwingIHeadless(), (FormatFactory)SwingFormatFactory.getInstance());
            this.axis.setTickLabelFont(SwingFactory.getInstance().createFont("Tahoma", 0, 10));
            if (this.format != null) {
                this.axis.setFormatOverride(this.format);
            }
        }
        return this.axis;
    }

    public void setAxis(ValueAxis axis) {
        this.axis = axis;
        this.refresh();
    }

    public void setGridLinesColor(CPColor gridLinesColor) {
        this.gridLinesColor = gridLinesColor;
        this.repaint();
    }

    public void setLabelColor(CPColor labelColor) {
        this.labelColor = labelColor;
        this.repaint();
    }

    public void setPaintTicks(boolean paintTicks) {
        this.paintTicks = paintTicks;
        this.repaint();
    }

    public String toString() {
        return "AbstractAxisGuide{coordinateAxis=" + String.valueOf(this.coordinateAxis) + ", axis=" + String.valueOf(this.axis) + "}";
    }
}

