/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider.plaf.synth;

import com.macrofocus.crossplatform.swing.MJComponent;
import com.macrofocus.slider.RangeSliderModel;
import com.macrofocus.slider.plaf.basic.BasicRangeSliderUI;
import com.macrofocus.slider.swing.JRangeSlider;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.ArrowButtonPainter;
import de.javasoft.plaf.synthetica.painter.ScrollBarPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.RasterFormatException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;

public class SynthRangeSliderUI
extends BasicRangeSliderUI {
    private static final SynthRangeSliderUI rangeSliderUI = new SynthRangeSliderUI();
    private final JScrollBar scrollBar = new JScrollBar();
    private final JButton button = new JButton();

    public SynthRangeSliderUI() {
        this.button.setEnabled(true);
        this.button.setFocusable(false);
        this.button.setName("ScrollBar.button");
        this.button.setDefaultCapable(false);
        this.scrollBar.add(this.button);
        this.backgroundControlColor = new Color(189, 218, 240);
        this.thumbColor = new Color(189, 218, 240);
        this.backgroundColor = new Color(220, 235, 246);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.scrollBar.setOrientation(((JRangeSlider)c).getOrientation() == 0 ? 0 : 1);
        this.scrollBar.setSize(c.getSize());
        MJComponent.configureRenderingHints((Graphics)g);
        super.paint(g, c);
    }

    public static ComponentUI createUI(JComponent c) {
        return rangeSliderUI;
    }

    @Override
    public void paintRange(RangeSliderModel rangeSliderModel, JRangeSlider view, Graphics g, int orientation, Rectangle trackBounds, Rectangle thumbBounds) {
        if (view.isPaintTrack()) {
            if (view.getHistogramRenderer() != null) {
                Component c = view.getHistogramRenderer().getRangeSliderHistogramRendererComponent(view, rangeSliderModel.getHistogram());
                if (c != null) {
                    c.setSize(trackBounds.width, trackBounds.height);
                    Graphics g2 = g.create(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
                    c.paint(g2);
                    g2.dispose();
                }
            } else {
                int x = thumbBounds.x;
                int y = thumbBounds.y;
                int w = thumbBounds.width;
                int h = thumbBounds.height;
                SynthContext context = SyntheticaLookAndFeel.createContext((JComponent)this.scrollBar, (Region)Region.SCROLL_BAR, (int)1024);
                ScrollBarPainter.getInstance().paintScrollBarTrackBackground(context, g, x, y, w, h);
                ScrollBarPainter.getInstance().paintScrollBarTrackBorder(context, g, trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
            }
        }
    }

    @Override
    public void paintThumb(JRangeSlider view, Graphics g, int orientation, Rectangle thumbBounds) {
        if (view.isPaintThumb() && view.getHistogramRenderer() == null) {
            if (thumbBounds.isEmpty() || !view.isEnabled()) {
                return;
            }
            int x = thumbBounds.x;
            int y = thumbBounds.y;
            int w = thumbBounds.width;
            int h = thumbBounds.height;
            SynthContext context = SyntheticaLookAndFeel.createContext((JComponent)this.scrollBar, (Region)Region.SCROLL_BAR, (int)1024);
            ScrollBarPainter.getInstance().paintScrollBarThumbBackground(context, g, x, y, w, h, view.getOrientation() == 0 ? 0 : 1);
            ScrollBarPainter.getInstance().paintScrollBarThumbBorder(context, g, thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height, this.scrollBar.getOrientation());
        }
    }

    @Override
    public void paintArrowButton(JComponent sliderView, Graphics g, int direction, Rectangle bounds) {
        int x = bounds.x;
        int y = bounds.y;
        int w = bounds.width;
        int h = bounds.height;
        this.button.putClientProperty("__arrow_direction__", direction);
        this.button.setSize(w, h);
        this.button.validate();
        SynthContext context = SyntheticaLookAndFeel.createContext((JComponent)this.button, (Region)Region.ARROW_BUTTON, (int)1);
        try {
            ArrowButtonPainter.getInstance().paintArrowButtonBackground(context, g, x, y, w, h);
            ArrowButtonPainter.getInstance().paintArrowButtonBorder(context, g, x, y, w, h);
            ArrowButtonPainter.getInstance().paintArrowButtonForeground(context, g, x, y, w, h, direction);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (RasterFormatException e) {
            e.printStackTrace();
        }
    }

    public static String getString(String key, Component c) {
        return (String)SynthRangeSliderUI.get(key, c);
    }

    public static Insets getInsets(String key, Component c) {
        Insets insets = (Insets)SynthRangeSliderUI.get(key, c);
        if (insets != null) {
            return insets;
        }
        return new Insets(0, 0, 0, 0);
    }

    public static Object get(String key, Component c) {
        String name = c.getName();
        if (name == null) {
            return UIManager.get(key);
        }
        Object o = UIManager.get(String.valueOf(key) + "." + name);
        if (o != null) {
            return o;
        }
        return UIManager.get(key);
    }
}

