/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider.swing;

import com.macrofocus.slider.RangeSliderEvent;
import com.macrofocus.slider.RangeSliderListener;
import com.macrofocus.slider.RangeSliderModel;
import com.macrofocus.slider.swing.JSliderView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.UIManager;

public class TrapezoidSliderView
extends JSliderView {
    protected boolean leftToRight = true;
    protected Rectangle thumbBounds = new Rectangle();
    protected Rectangle trackBounds = new Rectangle();
    private int orientation;
    protected RangeSliderModel rangeSliderModel;
    protected Rectangle minRectangle = new Rectangle();
    protected Rectangle maxRectangle = new Rectangle();
    protected Rectangle rangeRectangle = new Rectangle();

    public TrapezoidSliderView(RangeSliderModel rangeSliderModel, int orientation) {
        this.rangeSliderModel = rangeSliderModel;
        this.orientation = orientation;
        this.updateRectangles();
        rangeSliderModel.addSliderListener(new RangeSliderListener(){

            public void sliderChanged(RangeSliderEvent e) {
                TrapezoidSliderView.this.updateRectangles();
                TrapezoidSliderView.this.repaint();
            }

            public void sliderScaleChanged(RangeSliderEvent e) {
                TrapezoidSliderView.this.updateRectangles();
                TrapezoidSliderView.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TrapezoidSliderView.this.updateRectangles();
                TrapezoidSliderView.this.repaint();
            }
        });
    }

    public RangeSliderModel getRangeSliderModel() {
        return this.rangeSliderModel;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Rectangle getTrackBounds() {
        return this.trackBounds;
    }

    public Rectangle getThumbBounds() {
        return this.thumbBounds;
    }

    public Rectangle getMinBounds() {
        return this.minRectangle;
    }

    public Rectangle getMaxBounds() {
        return this.maxRectangle;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.rangeSliderModel.getMaximum() != this.rangeSliderModel.getMinimum()) {
            Polygon poly = new Polygon();
            g.setColor(Color.lightGray);
            if (this.getOrientation() == 1) {
                poly.addPoint(this.thumbBounds.x, this.thumbBounds.y);
                poly.addPoint(this.thumbBounds.x, this.thumbBounds.y + this.thumbBounds.height);
                poly.addPoint(this.trackBounds.x + this.thumbBounds.width, this.thumbBounds.y + this.trackBounds.height - this.maxRectangle.height);
                poly.addPoint(this.trackBounds.x + this.thumbBounds.width, this.rangeRectangle.y + this.minRectangle.height);
            } else {
                poly.addPoint(this.thumbBounds.x, this.thumbBounds.y);
                poly.addPoint(this.thumbBounds.x + this.thumbBounds.width, this.thumbBounds.y);
                poly.addPoint(this.trackBounds.x + this.trackBounds.width - this.maxRectangle.width, this.thumbBounds.y + this.thumbBounds.height);
                poly.addPoint(this.trackBounds.x + this.minRectangle.width, this.rangeRectangle.y + this.thumbBounds.height);
            }
            g.fillPolygon(poly);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (UIManager.get("ScrollBar.width") != null) {
            int scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
            if (this.getOrientation() == 1) {
                return new Dimension(scrollBarWidth, scrollBarWidth * 3 + 10);
            }
            return new Dimension(scrollBarWidth * 3 + 10, scrollBarWidth);
        }
        return this.getOrientation() == 1 ? new Dimension(16, 48) : new Dimension(48, 16);
    }

    protected void updateRectangles() {
        if (this.getOrientation() == 1) {
            int width;
            int x = 0;
            int height = width = this.getWidth() - 0;
            int minY = height + this.toScreen(this.rangeSliderModel.getCurrentMinimum());
            int maxY = this.toScreen(this.rangeSliderModel.getCurrentMaximum());
            this.maxRectangle.setBounds(x, maxY, width, height);
            this.minRectangle.setBounds(x, minY, width, height);
        } else {
            int height;
            int y = 0;
            int width = height = this.getHeight() - 0;
            int minX = this.toScreen(this.rangeSliderModel.getCurrentMinimum());
            int maxX = width + this.toScreen(this.rangeSliderModel.getCurrentMaximum());
            this.maxRectangle.setBounds(maxX, y, width, height);
            this.minRectangle.setBounds(minX, y, width, height);
        }
        if (this.getOrientation() == 1) {
            Dimension size = this.getSize();
            this.trackBounds.setBounds(0, 0, size.width - 0, size.height - 0);
            this.rangeRectangle.setBounds(0, this.maxRectangle.y + this.maxRectangle.height, size.width, this.minRectangle.y - this.maxRectangle.y - this.maxRectangle.height);
            this.thumbBounds.setBounds(0, this.maxRectangle.y + this.maxRectangle.height, size.width, this.minRectangle.y - this.maxRectangle.y - this.maxRectangle.height);
        } else {
            Dimension size = this.getSize();
            this.trackBounds.setBounds(0, 0, size.width - 0, size.height - 0);
            this.rangeRectangle.setBounds(this.minRectangle.x + this.minRectangle.width, 0, this.maxRectangle.x - this.minRectangle.x - this.minRectangle.width, size.height);
            this.thumbBounds.setBounds(this.minRectangle.x + this.minRectangle.width, 0, this.maxRectangle.x - this.minRectangle.x - this.minRectangle.width, size.height);
        }
    }

    public int toScreen(double value) {
        if (this.getOrientation() == 1) {
            double screenRange = this.getHeight() - 2 * this.getWidth();
            double worldRange = this.rangeSliderModel.getMaximum() - this.rangeSliderModel.getMinimum();
            return (int)Math.round(screenRange * (worldRange - (value - this.rangeSliderModel.getMinimum())) / worldRange);
        }
        double screenRange = this.getWidth() - 2 * this.getHeight();
        double worldRange = this.rangeSliderModel.getMaximum() - this.rangeSliderModel.getMinimum();
        return (int)Math.round(screenRange * (value - this.rangeSliderModel.getMinimum()) / worldRange);
    }

    public double toWorld(int value) {
        if (this.getOrientation() == 1) {
            Dimension size = this.getSize();
            int screenWidth = size.width;
            int screenHeight = size.height;
            double screenRange = screenHeight - 2 * screenWidth;
            double worldRange = this.rangeSliderModel.getMaximum() - this.rangeSliderModel.getMinimum();
            return worldRange * (screenRange - (double)value) / screenRange;
        }
        Dimension size = this.getSize();
        int screenWidth = size.width;
        int screenHeight = size.height;
        double screenRange = screenWidth - 2 * screenHeight;
        double worldRange = this.rangeSliderModel.getMaximum() - this.rangeSliderModel.getMinimum();
        return worldRange * (double)value / screenRange;
    }

    public int getScreenRange() {
        Dimension size = this.getSize();
        int screenWidth = size.width;
        int screenHeight = size.height;
        if (this.getOrientation() == 1) {
            int screenRange = screenHeight - 2 * screenWidth;
            return screenRange;
        }
        int screenRange = screenWidth - 2 * screenHeight;
        return screenRange;
    }

    public Component getComponent() {
        return this;
    }
}

