/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.colormap.swing;

import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.MutableColorMap;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.helper.TableHelper;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.palette.PaletteFactory;
import com.macrofocus.palette.swing.SwingPaletteFactory;
import com.macrofocus.utils.UniversalComparator;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import javax.swing.table.TableModel;

public class SwingColorMapFactory
extends ColorMapFactory {
    private static SwingColorMapFactory ourInstance = new SwingColorMapFactory();

    public static SwingColorMapFactory getInstance() {
        return ourInstance;
    }

    private SwingColorMapFactory() {
        super((CPColorFactory)SwingFactory.getInstance(), (PaletteFactory)SwingPaletteFactory.getInstance());
    }

    public MutableColorMap createColorMap(TableModel tableModel, int column) {
        TableHelper.ColumnStatistics stat = TableHelper.getColumnStatistics((TableModel)tableModel, (int)column);
        if (stat.getMin() != null && stat.getMax() != null) {
            return this.createContinuousColorMap(tableModel, column);
        }
        return this.createQualitativeColorMap(tableModel, column);
    }

    public MutableColorMap createContinuousColorMap(TableModel tableModel, int column) {
        if (column >= 0 && column < tableModel.getColumnCount()) {
            TableHelper.ColumnStatistics stat = TableHelper.getColumnStatistics((TableModel)tableModel, (int)column);
            return this.createAutoContinuousColorMap(stat.getMin(), stat.getMax());
        }
        return null;
    }

    public MutableColorMap createSegmentedColorMap(TableModel tableModel, int column) {
        if (column >= 0 && column < tableModel.getColumnCount()) {
            TableHelper.ColumnStatistics stat = TableHelper.getColumnStatistics((TableModel)tableModel, (int)column);
            return this.createAutoSegmentedColorMap(stat.getMin(), stat.getMax());
        }
        return null;
    }

    public MutableColorMap createQualitativeColorMap(TableModel tableModel, int column) {
        if (tableModel != null && column >= 0 && column < tableModel.getColumnCount()) {
            Object value;
            int row;
            AbstractSet values = new TreeSet(new UniversalComparator());
            int valueCount = 0;
            for (row = 0; row < tableModel.getRowCount(); ++row) {
                value = tableModel.getValueAt(row, column);
                if (value == null || !(value instanceof Comparable)) continue;
                values.add(value);
                ++valueCount;
            }
            if (valueCount == 0) {
                values = new LinkedHashSet();
                for (row = 0; row < tableModel.getRowCount(); ++row) {
                    value = tableModel.getValueAt(row, column);
                    if (value == null) continue;
                    values.add(value);
                    ++valueCount;
                }
            }
            return this.createQualitativeColorMap(values);
        }
        return this.createQualitativeColorMap(Collections.emptySet());
    }
}

