/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.swing;

import com.macrofocus.crossplatform.swing.SwingTimer;
import com.macrofocus.timer.CPTimerListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class PostponingTimerDemo
extends JPanel {
    private static final int ONE_SECOND = 1000;
    private static final String NEW_LINE_DLIM = "\n";
    private JProgressBar progressBar;
    private SwingTimer timer = new SwingTimer("Test", 1000, 20000, true);
    private JButton restartButton;
    private JTextArea taskOutput;

    public PostponingTimerDemo() {
        super(new BorderLayout());
        this.timer.addTimerListener(new CPTimerListener(){

            public void timerTriggered() {
                PostponingTimerDemo.this.taskOutput.append(String.valueOf((Object)PostponingTimerDemo.this.timer) + PostponingTimerDemo.NEW_LINE_DLIM);
                PostponingTimerDemo.this.taskOutput.setCaretPosition(PostponingTimerDemo.this.taskOutput.getDocument().getLength());
            }
        });
        this.restartButton = new JButton("Restart");
        this.restartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PostponingTimerDemo.this.timer.restart();
            }
        });
        JButton stopButton = new JButton("Stop");
        stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PostponingTimerDemo.this.timer.stop();
                PostponingTimerDemo.this.taskOutput.append("Stop " + String.valueOf((Object)PostponingTimerDemo.this.timer) + PostponingTimerDemo.NEW_LINE_DLIM);
                PostponingTimerDemo.this.taskOutput.setCaretPosition(PostponingTimerDemo.this.taskOutput.getDocument().getLength());
            }
        });
        JButton statusButton = new JButton("Status");
        statusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PostponingTimerDemo.this.taskOutput.append("Status " + String.valueOf((Object)PostponingTimerDemo.this.timer) + PostponingTimerDemo.NEW_LINE_DLIM);
                PostponingTimerDemo.this.taskOutput.setCaretPosition(PostponingTimerDemo.this.taskOutput.getDocument().getLength());
            }
        });
        this.progressBar = new JProgressBar(0, 1);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.taskOutput = new JTextArea(50, 80);
        this.taskOutput.setMargin(new Insets(5, 5, 5, 5));
        this.taskOutput.setEditable(false);
        this.taskOutput.setCursor(null);
        JPanel panel = new JPanel();
        panel.add(this.restartButton);
        panel.add(stopButton);
        panel.add(statusButton);
        panel.add(this.progressBar);
        this.add((Component)panel, "First");
        this.add((Component)new JScrollPane(this.taskOutput), "Center");
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("SwingTimerDemo");
        frame.setDefaultCloseOperation(3);
        PostponingTimerDemo newContentPane = new PostponingTimerDemo();
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PostponingTimerDemo.createAndShowGUI();
            }
        });
    }
}

