/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.swing.layer;

import com.macrofocus.crossplatform.AbstractDensityLayer;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.swing.layer.SwingLayer;
import com.macrofocus.crossplatform.swing.layer.filter.AntiAliasingBufferedImageOp;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.igraphics.IDrawing;
import com.macrofocus.igraphics.pressure.Pressure;
import com.macrofocus.timer.VisualizationExecutorService;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Hashtable;

public class DensitySwingLayer
extends AbstractDensityLayer
implements SwingLayer {
    private static final boolean MULTITHREADED = false;
    private static final VisualizationExecutorService executor = null;
    private final IDrawing iDrawing;
    private final boolean antialiasing;
    private BufferedImage image;
    private final Pressure pressure;
    private final CPCanvas.PaletteProvider palette;

    public DensitySwingLayer(IDrawing iDrawing, int width, int height, boolean antialiasing, Pressure pressure, CPCanvas.PaletteProvider palette) {
        this.iDrawing = iDrawing;
        this.antialiasing = antialiasing;
        this.resize(width, height);
        this.pressure = pressure;
        this.palette = palette;
    }

    @Override
    public void prepare(int width, int height) {
        this.resize(width, height);
        if (this.iDrawing.isActive() && width > 0 && height > 0) {
            this.iDrawing.draw(this.g, null, (double)this.width, (double)this.height, new Rectangle(0, 0, this.width, this.height));
            int m = this.computeMax();
            double min = this.pressure.transform(1.0);
            double max = this.pressure.transform((double)m);
            int[] pixels = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
            double range = max - min;
            for (int i = 0; i < this.overlay.length; ++i) {
                int v = this.overlay[i];
                if (v > 0) {
                    double value = this.pressure.transform((double)v);
                    int color = (int)(value * (double)(this.palette.getPalette().getColorCount() - 1) / range);
                    pixels[i] = this.palette.getPalette().getColorAt(color).getRGB();
                    continue;
                }
                pixels[i] = 0xFFFFFF;
            }
        }
        if (this.antialiasing) {
            this.image = this.createAntiAliasedImage(this.image);
        }
    }

    void resize(int width, int height) {
        if ((this.width != width || this.height != height) && width > 0 && height > 0) {
            WritableRaster ras = Raster.createWritableRaster(new SinglePixelPackedSampleModel(3, width, height, new int[]{0xFF0000, 65280, 255, -16777216}), new Point(0, 0));
            BufferedImage bufferedImage = new BufferedImage(new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216), ras, false, new Hashtable());
            int[] o = new int[width * height];
            this.width = width;
            this.height = height;
            this.image = bufferedImage;
            this.overlay = o;
            this.cx1 = 0;
            this.cy1 = 0;
            this.cx2 = width - 1;
            this.cy2 = height - 1;
        } else {
            this.clear();
        }
    }

    @Override
    public void render(Graphics2D g) {
        if (this.iDrawing.isActive() && this.image != null) {
            g.drawImage((Image)this.image, 0, 0, null);
        }
    }

    private BufferedImage createAntiAliasedImage(BufferedImage img) {
        return img != null ? new AntiAliasingBufferedImageOp().filter(img, null) : null;
    }

    void clear() {
        if (this.image != null) {
            Arrays.fill(this.overlay, 0);
        }
    }

    int computeMax() {
        int max = 0;
        for (int v : this.overlay) {
            if (v <= max) continue;
            max = v;
        }
        return max;
    }
}

