/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.swing.layer.filter;

import com.macrofocus.crossplatform.swing.layer.filter.AbstractBufferedImageOp;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Kernel;

public class AntiAliasingBufferedImageOp
extends AbstractBufferedImageOp {
    public static int ZERO_EDGES = 0;
    private static final int CLAMP_EDGES = 1;
    private static final int WRAP_EDGES = 2;
    private Kernel kernel = null;
    private final boolean alpha = true;
    private int edgeAction = 1;
    private final int transparency;

    public AntiAliasingBufferedImageOp() {
        this(1.0f, 0.0f, 127);
    }

    private AntiAliasingBufferedImageOp(float factor, float diagonal, int tranparency) {
        this(new float[]{diagonal, factor, diagonal, factor, 0.0f, factor, diagonal, factor, diagonal}, tranparency);
    }

    private AntiAliasingBufferedImageOp(float[] matrix, int transparency) {
        this(new Kernel(3, 3, matrix), transparency);
    }

    private AntiAliasingBufferedImageOp(Kernel kernel, int transparency) {
        this.kernel = kernel;
        this.transparency = transparency;
    }

    private static int clamp(int c) {
        if (c < 0) {
            return 0;
        }
        if (c > 255) {
            return 255;
        }
        return c;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setEdgeAction(int edgeAction) {
        this.edgeAction = edgeAction;
    }

    public int getEdgeAction() {
        return this.edgeAction;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int[] inPixels = new int[width * height];
        int[] outPixels = new int[width * height];
        this.getRGB(src, 0, 0, width, height, inPixels);
        AntiAliasingBufferedImageOp.convolve(this.kernel, inPixels, outPixels, width, height, true, this.edgeAction, this.transparency);
        this.setRGB(dst, 0, 0, width, height, outPixels);
        return dst;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel dstCM) {
        if (dstCM == null) {
            dstCM = src.getColorModel();
        }
        return new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(src.getWidth(), src.getHeight()), dstCM.isAlphaPremultiplied(), null);
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle(0, 0, src.getWidth(), src.getHeight());
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = new Point2D.Double();
        }
        dstPt.setLocation(srcPt.getX(), srcPt.getY());
        return dstPt;
    }

    private static void convolve(Kernel kernel, int[] inPixels, int[] outPixels, int width, int height, boolean alpha, int edgeAction, int transparency) {
        AntiAliasingBufferedImageOp.convolveHV(kernel, inPixels, outPixels, width, height, alpha, edgeAction, transparency);
    }

    private static void convolveHV(Kernel kernel, int[] inPixels, int[] outPixels, int width, int height, boolean alpha, int edgeAction, int transparency) {
        int index = 0;
        float[] matrix = kernel.getKernelData(null);
        int rows = kernel.getHeight();
        int cols = kernel.getWidth();
        int rows2 = rows / 2;
        int cols2 = cols / 2;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = inPixels[y * width + x];
                if (x < width - cols2 && y < height - rows2) {
                    if ((pixel >> 24 & 0xFF) == 0) {
                        float r = 0.0f;
                        float g = 0.0f;
                        float b = 0.0f;
                        float a = 0.0f;
                        int count = 0;
                        for (int row = -rows2; row <= rows2; ++row) {
                            int ioffset;
                            int iy = y + row;
                            if (0 <= iy && iy < height) {
                                ioffset = iy * width;
                            } else if (edgeAction == 1) {
                                ioffset = y * width;
                            } else {
                                if (edgeAction != 2) continue;
                                ioffset = (iy + height) % height * width;
                            }
                            int moffset = cols * (row + rows2) + cols2;
                            for (int col = -cols2; col <= cols2; ++col) {
                                int rgb;
                                int t;
                                float f = matrix[moffset + col];
                                if (f == 0.0f) continue;
                                int ix = x + col;
                                if (0 > ix || ix >= width) {
                                    if (edgeAction == 1) {
                                        ix = x;
                                    } else {
                                        if (edgeAction != 2) continue;
                                        ix = (x + width) % width;
                                    }
                                }
                                if ((t = (rgb = inPixels[ioffset + ix]) >> 24 & 0xFF) == 0) continue;
                                ++count;
                                a += f * (float)transparency;
                                r += f * (float)(rgb >> 16 & 0xFF);
                                g += f * (float)(rgb >> 8 & 0xFF);
                                b += f * (float)(rgb & 0xFF);
                            }
                        }
                        if (count >= 2) {
                            a = transparency;
                            int ia = alpha ? AntiAliasingBufferedImageOp.clamp((int)((double)a + 0.5)) : 255;
                            int ir = AntiAliasingBufferedImageOp.clamp((int)((double)(r /= (float)count) + 0.5));
                            int ig = AntiAliasingBufferedImageOp.clamp((int)((double)(g /= (float)count) + 0.5));
                            int ib = AntiAliasingBufferedImageOp.clamp((int)((double)(b /= (float)count) + 0.5));
                            outPixels[index++] = ia << 24 | ir << 16 | ig << 8 | ib;
                            continue;
                        }
                        outPixels[index++] = pixel;
                        continue;
                    }
                    outPixels[index++] = pixel;
                    continue;
                }
                outPixels[index++] = pixel;
            }
        }
    }

    public String toString() {
        return "AntiAliasing...";
    }
}

