/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.igraphics.swing;

import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.igraphics.AbstractCPColor;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import java.awt.Color;

public class SwingColor
extends AbstractCPColor<Color> {
    private final Color nativeColor;

    public SwingColor(Color nativeColor) {
        assert (nativeColor != null);
        this.nativeColor = nativeColor;
    }

    public SwingColor(int rgba) {
        this.nativeColor = new Color(rgba, true);
    }

    public SwingColor(int r, int g, int b) {
        this.nativeColor = new Color(r, g, b);
    }

    public SwingColor(int r, int g, int b, int a) {
        this.nativeColor = new Color(r, g, b, a);
    }

    public CPColorFactory<Color> getFactory() {
        return SwingFactory.getInstance();
    }

    protected CPColor<Color> create(int rgba) {
        return new SwingColor(rgba);
    }

    public int getRed() {
        return this.nativeColor.getRed();
    }

    public int getGreen() {
        return this.nativeColor.getGreen();
    }

    public int getBlue() {
        return this.nativeColor.getBlue();
    }

    public int getAlpha() {
        return this.nativeColor.getAlpha();
    }

    public int getRGB() {
        return this.nativeColor.getRGB();
    }

    public Color getNativeColor() {
        return this.nativeColor;
    }

    public CPColor<Color> brightenAndSaturate(float brightness, float saturation) {
        float[] hsb = Color.RGBtoHSB(this.getRed(), this.getGreen(), this.getBlue(), null);
        if (brightness != 0.0f) {
            hsb[2] = Math.max(0.0f, Math.min(1.0f, hsb[2] + brightness));
        }
        if (saturation != 0.0f) {
            hsb[1] = Math.max(0.0f, Math.min(1.0f, hsb[1] + saturation));
        }
        return new SwingColor(Color.getHSBColor(hsb[0], hsb[1], hsb[2]));
    }

    public CPColor<Color> alpha(float alpha) {
        return new SwingColor(this.getRed(), this.getGreen(), this.getBlue(), (int)(255.0f * alpha));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SwingColor that = (SwingColor)((Object)o);
        return this.nativeColor != null ? this.nativeColor.equals(that.nativeColor) : that.nativeColor == null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.nativeColor != null ? this.nativeColor.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SwingColor{nativeColor=" + String.valueOf(this.nativeColor) + "}";
    }
}

