/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.igraphics.swing;

import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPTextMetrics;
import com.macrofocus.igraphics.GraphicsContext2D;
import com.macrofocus.igraphics.swing.SwingTextMetrics;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Stack;

public class SwingGraphicsContext2D
implements GraphicsContext2D<Color, Font> {
    private final Stack<Graphics2D> stack = new Stack();
    private Graphics2D gc;
    private GeneralPath path = null;
    private CPColor<Color> fill;
    private CPColor<Color> stroke;

    public SwingGraphicsContext2D(Graphics2D gc) {
        this.gc = gc;
    }

    public CPTextMetrics getTextMetrics(String text) {
        return new SwingTextMetrics(this.gc, text);
    }

    public void drawGradient(CPColor<Color> color1, CPColor<Color> color2, double x, double y, double w, double h, boolean isVertical) {
        if (isVertical) {
            GradientPaint gradient = new GradientPaint(0.0f, (float)y, (Color)color1.getNativeColor(), 0.0f, (float)(y + h), (Color)color2.getNativeColor());
            this.gc.setPaint(gradient);
            this.gc.fill(new Rectangle2D.Double(x, y, w, h));
        } else {
            GradientPaint gradient = new GradientPaint((float)x, 0.0f, (Color)color1.getNativeColor(), (float)(x + w), 0.0f, (Color)color2.getNativeColor());
            this.gc.setPaint(gradient);
            this.gc.fill(new Rectangle2D.Double(x, y, w, h));
        }
    }

    public void save() {
        this.stack.push(this.gc);
        this.gc = (Graphics2D)this.gc.create();
    }

    public void restore() {
        this.gc.dispose();
        this.gc = this.stack.pop();
    }

    public void translate(double x, double y) {
        this.gc.translate(x, y);
    }

    public void scale(double x, double y) {
        this.gc.scale(x, y);
    }

    public void rotate(double degrees) {
        this.gc.rotate(degrees);
    }

    public void transform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        this.gc.transform(new AffineTransform(mxx, myx, mxy, myy, mxt, myt));
    }

    public void setTransform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        this.gc.setTransform(new AffineTransform(mxx, myx, mxy, myy, mxt, myt));
    }

    public void setGlobalAlpha(double alpha) {
        this.gc.setComposite(AlphaComposite.getInstance(3, (float)alpha));
    }

    public void setFill(CPColor<Color> p) {
        this.fill = p;
        this.gc.setColor((Color)p.getNativeColor());
    }

    public void setStroke(CPColor<Color> p) {
        this.stroke = p;
        this.gc.setColor((Color)p.getNativeColor());
    }

    public void setLineWidth(double lw) {
        this.gc.setStroke(new BasicStroke((float)lw));
    }

    public Font getFont() {
        return this.gc.getFont();
    }

    public void setFont(Font f) {
        this.gc.setFont(f);
    }

    public void fillText(String text, double x, double y) {
        this.gc.drawString(text, (float)x, (float)y);
    }

    public void beginPath() {
        this.path = new GeneralPath();
    }

    public void moveTo(double x0, double y0) {
        this.path.moveTo(x0, y0);
    }

    public void lineTo(double x1, double y1) {
        this.path.lineTo(x1, y1);
    }

    public void quadraticCurveTo(double xc, double yc, double x1, double y1) {
        this.path.quadTo(xc, yc, x1, y1);
    }

    public void bezierCurveTo(double xc1, double yc1, double xc2, double yc2, double x1, double y1) {
        this.path.curveTo(xc1, yc1, xc2, yc2, x1, y1);
    }

    public void rect(double x, double y, double w, double h) {
        this.path.moveTo(x, y);
        this.path.lineTo(x + w, y);
        this.path.lineTo(x + w, y + h);
        this.path.lineTo(x, y + h);
        this.path.lineTo(x, y);
    }

    public void closePath() {
        this.path.closePath();
    }

    public void fill() {
        this.gc.fill(this.path);
    }

    public void stroke() {
        this.gc.draw(this.path);
    }

    public void clip() {
        this.gc.clip(this.path);
    }

    public void fillRect(double x, double y, double w, double h) {
        this.gc.fill(new Rectangle2D.Double(x, y, w, h));
    }

    public void strokeRect(double x, double y, double w, double h) {
        this.gc.draw(new Rectangle2D.Double(x, y, w, h));
    }

    public void strokeLine(double x1, double y1, double x2, double y2) {
        this.gc.draw(new Line2D.Double(x1, y1, x2, y2));
    }

    public void fillRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
        this.gc.fill(new RoundRectangle2D.Double(x, y, w, h, arcWidth, arcHeight));
    }
}

