/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.igraphics.swing;

import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.IHeadless;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;

public class SwingIHeadless
implements IHeadless<Font> {
    private final FontRenderContext frc = new FontRenderContext(null, true, true);

    public com.macrofocus.geom.Rectangle2D getStringBounds(IGraphics<?, Font> g, CPFont<Font> font, String text) {
        if (g != null) {
            g.setFont(font);
            return g.getStringBounds(text);
        }
        Rectangle2D stringBounds = new TextLayout(text, (Font)font.getNativeFont(), this.frc).getBounds();
        return new Rectangle2D.Double(stringBounds.getX(), stringBounds.getY(), stringBounds.getWidth(), stringBounds.getHeight());
    }

    public float getStringWidth(IGraphics<?, Font> g, CPFont<Font> font, String text) {
        if (g != null) {
            g.setFont(font);
            return g.getStringWidth(text);
        }
        if (text != null && text.length() > 0) {
            Rectangle2D stringBounds = new TextLayout(text, (Font)font.getNativeFont(), this.frc).getBounds();
            return (float)stringBounds.getWidth();
        }
        return 0.0f;
    }

    public float getStringHeight(IGraphics<?, Font> g, CPFont<Font> font, String text) {
        if (g != null) {
            g.setFont(font);
            return g.getStringHeight(text);
        }
        LineMetrics metrics = ((Font)font.getNativeFont()).getLineMetrics(text, this.frc);
        return metrics.getHeight();
    }
}

