/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.igraphics;

import com.macrofocus.geom.Ellipse2D;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.igraphics.CPFontMetrics;
import com.macrofocus.igraphics.ICallback;
import com.macrofocus.igraphics.IGraphics;

public abstract class AbstractIGraphics<Color, Font>
implements IGraphics<Color, Font> {
    protected Object value;
    protected ICallback callback;

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public void setLineDash(float[] dashPatern) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawShape(Shape shape) {
        void var1_1;
        this.draw((Shape)var1_1);
    }

    @Override
    public void drawPoint(Point2D point) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fillCircle(Rectangle2D rectangle) {
        void var1_1;
        this.fill(new Ellipse2D.Double(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), var1_1.getHeight()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fillRectangle2D(Rectangle2D rectangle) {
        void var1_1;
        this.fill((Shape)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fillRectangle(int x, int y, int width, int height) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.fill(new Rectangle2D.Double((double)var1_1, (double)var2_2, (double)var3_3, height));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawRectange(int x, int y, int width, int height) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.draw(new Rectangle2D.Double((double)var1_1, (double)var2_2, (double)var3_3, height));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fillShape(Shape shape) {
        void var1_1;
        this.fill((Shape)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> void pickDraw(Shape geometry, Point2D point, T value, ICallback<T> callback) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.a(geometry, (Point2D)var2_2, var3_3, callback);
        this.draw((Shape)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> void pickFill(Shape geometry, Point2D point, T value, ICallback<T> callback) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.a(geometry, (Point2D)var2_2, var3_3, callback);
        this.fill((Shape)var1_1);
    }

    private <T> void a(Shape shape, Point2D point2D, T t, ICallback<T> iCallback) {
        if (point2D != null && shape.contains(point2D)) {
            this.value = t;
            this.callback = iCallback;
        }
    }

    protected abstract void draw(Shape var1);

    protected abstract void fill(Shape var1);

    @Override
    public void beginPick() {
        this.value = null;
        this.callback = null;
    }

    @Override
    public void endPick() {
        if (this.callback != null) {
            this.callback.callingBack(this.value);
        }
    }

    @Override
    public void setTextBaseline(IGraphics.TextBaseline baseline) {
    }

    @Override
    public void setFont(CPFont<Font> font) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Rectangle2D getStringBounds(String text) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public float getStringWidth(String text) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public float getStringHeight(String text) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void drawString(String text, float x, float y) {
        throw new UnsupportedOperationException("Not implemented");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawCircularString(String text, float centerX, float centerY, float radius, float startAngle, float extent) {
        void var3_3;
        void var2_2;
        double d2;
        this.translate((int)centerX, (int)centerY);
        double d3 = startAngle;
        if (d2 > 180.0) {
            if (d3 <= 540.0) {
                d3 -= 360.0;
            } else if ((d3 = AbstractIGraphics.IEEEremainder(d3, 360.0)) == -180.0) {
                d3 = 180.0;
            }
        } else if (d3 <= -180.0) {
            if (d3 > -540.0) {
                d3 += 360.0;
            } else if ((d3 = AbstractIGraphics.IEEEremainder(d3, 360.0)) == -180.0) {
                d3 = 180.0;
            }
        }
        double d4 = Math.toRadians(d3);
        this.rotate(d4);
        float f2 = this.getStringHeight(text);
        for (int i = 0; i < text.length(); ++i) {
            String string = String.valueOf(text.charAt(i));
            float f3 = this.getStringWidth(string);
            float f4 = f3 / 2.0f / (radius - f2);
            this.rotate(f4);
            d4 += (double)f4;
            this.drawString(string, 0.0f, 1.0f * (0.0f - radius + f2 / 2.0f));
            float f5 = (f3 / 2.0f + 0.0f) / (radius - f2);
            this.rotate(f5);
            d4 += (double)f5;
        }
        this.rotate(-d4);
        this.translate((int)(-var2_2), (int)(-var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static double IEEEremainder(double f1, double f2) {
        void var2_1;
        double d2;
        double d3 = Math.abs(f1 % f2);
        if (Double.isNaN(d3) || d3 == f2 || d3 <= Math.abs(f2) / 2.0) {
            return d3;
        }
        return Math.signum(d2) * (d3 - var2_1);
    }

    @Override
    public double getAscent() {
        return 0.0;
    }

    @Override
    public double getDescent() {
        return 0.0;
    }

    @Override
    public CPFontMetrics getFontMetrics() {
        throw new UnsupportedOperationException("Not implemented");
    }
}

