/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing;

import com.macrofocus.plot.SwingAxisPlotPanel;
import com.macrofocus.slider.BoundedIntervalRangeSliderAdapter;
import com.macrofocus.slider.RangeSliderModel;
import com.macrofocus.slider.SliderView;
import com.macrofocus.slider.swing.JRangeSlider;
import com.macrofocus.slider.swing.SimpleRangeSliderController;
import com.macrofocus.slider.swing.TrapezoidRangeSlider;
import com.treemap.TreeMap;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class TreeMapPanel
extends JPanel {
    private final TreeMap treeMap;

    public TreeMapPanel(TreeMap<JComponent, ?, ?, ?, Color, Font> treeMap) {
        this.treeMap = treeMap;
        this.setLayout(new BorderLayout());
        SwingAxisPlotPanel axisPlotPanel = new SwingAxisPlotPanel();
        this.add((Component)axisPlotPanel.getNativeComponent(), "Center");
        axisPlotPanel.addComponent((Object)((JComponent)treeMap.getNativeComponent()));
        axisPlotPanel.setShowTopTimeAxis(true);
        axisPlotPanel.setTopAxisVisible(true);
        BoundedIntervalRangeSliderAdapter xSliderModel = new BoundedIntervalRangeSliderAdapter(treeMap.getView().getXRangeModel(), 0.0, 0.0);
        JRangeSlider xRangeSlider = new JRangeSlider((RangeSliderModel)xSliderModel, 0);
        TrapezoidRangeSlider xZoomTrapezoid = new TrapezoidRangeSlider(xRangeSlider);
        xZoomTrapezoid.setOpaque(true);
        JPanel xRange = new JPanel();
        xRange.setLayout(new BorderLayout());
        xRange.add((Component)xRangeSlider, "North");
        xZoomTrapezoid.setMinimumSize(new Dimension(12, 12));
        xRange.add((Component)xZoomTrapezoid, "South");
        new SimpleRangeSliderController((SliderView)xRangeSlider, true);
        axisPlotPanel.addTopTimeAxisComponent((Object)xRange);
        axisPlotPanel.setRightAxisVisible(true);
        BoundedIntervalRangeSliderAdapter ySliderModel = new BoundedIntervalRangeSliderAdapter(treeMap.getView().getYRangeModel(), 0.0, 0.0);
        JRangeSlider yRangeSlider = new JRangeSlider((RangeSliderModel)ySliderModel, 1);
        TrapezoidRangeSlider yZoomTrapezoid = new TrapezoidRangeSlider(yRangeSlider);
        yZoomTrapezoid.setOpaque(true);
        JPanel yRange = new JPanel();
        yRange.setLayout(new BorderLayout());
        yZoomTrapezoid.setMinimumSize(new Dimension(12, 12));
        yRange.add((Component)yZoomTrapezoid, "West");
        yRange.add((Component)yRangeSlider, "East");
        new SimpleRangeSliderController((SliderView)yRangeSlider, true);
        axisPlotPanel.addRightYAxisComponent((Object)yRange);
    }

    public void setModel(TreeMapModel model) {
        this.treeMap.setModel(model);
    }

    public TreeMap getTreeMap() {
        return this.treeMap;
    }

    public TreeMapView getTreeMapView() {
        return this.treeMap.getView();
    }
}

