/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing;

import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.hierarchy.Condition;
import com.treemap.NoTreeMapField;
import com.treemap.TreeMapEvent;
import com.treemap.TreeMapField;
import com.treemap.TreeMapListener;
import com.treemap.TreeMapModel;
import java.util.LinkedHashSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.tree.TreePath;

public class VariablesComboBoxModel<E>
extends DefaultComboBoxModel {
    private final TreeMapModel model;
    private final Condition<TreeMapField> condition;
    private final boolean includeNone;

    public VariablesComboBoxModel(TreeMapModel model, final MutableSelection<E> selection, boolean includeNone, Condition<TreeMapField> condition) {
        this(model, includeNone, condition);
        selection.addSelectionListener(new SelectionListener<E>(){

            public void selectionChanged(SelectionEvent<E> event) {
                VariablesComboBoxModel.this.setSelectedItem(selection.getSelectedSet().toArray());
            }
        });
        this.setSelectedItem(selection.getSelectedSet().toArray());
        this.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                Object selectedItem = VariablesComboBoxModel.this.getSelectedItem();
                if (selectedItem instanceof Object[]) {
                    Object[] array = (Object[])selectedItem;
                    selection.setSelectedElements(array);
                } else {
                    selection.setSelectedElements(new Object[]{selectedItem});
                }
            }
        });
    }

    public VariablesComboBoxModel(TreeMapModel model, final MutableSingleSelection<E> selection, boolean includeNone, Condition<TreeMapField> condition) {
        this(model, includeNone, condition);
        selection.addSingleSelectionListener(new SingleSelectionListener<E>(){

            public void selectionChanged(SingleSelectionEvent<E> event) {
                VariablesComboBoxModel.this.setSelectedItem(event.getCurrentSelection());
            }
        });
        this.setSelectedItem(selection.getSelected());
        this.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                Object[] array;
                Object o = VariablesComboBoxModel.this.getSelectedItem();
                Object variable = o instanceof TreePath ? ((TreePath)o).getLastPathComponent() : (o instanceof Object[] ? ((array = (Object[])o).length > 0 ? array[0] : null) : o);
                selection.setSelected(variable);
            }
        });
    }

    private VariablesComboBoxModel(TreeMapModel model, boolean includeNone, Condition<TreeMapField> condition) {
        this.model = model;
        this.condition = condition;
        this.includeNone = includeNone;
        if (includeNone) {
            this.addElement(new NoTreeMapField());
        }
        model.addListener(new TreeMapListener(){

            public void tableModelChanged() {
                VariablesComboBoxModel.this.updateVariables();
            }

            public void treeMapChanged(TreeMapEvent event) {
            }
        });
        this.updateVariables();
    }

    private void updateVariables() {
        Object variable;
        LinkedHashSet<TreeMapField> old = new LinkedHashSet<TreeMapField>();
        LinkedHashSet<TreeMapField> current = new LinkedHashSet<TreeMapField>();
        int firstIndex = this.includeNone ? 1 : 0;
        for (int i = firstIndex; i < this.getSize(); ++i) {
            variable = (TreeMapField)this.getElementAt(i);
            old.add((TreeMapField)variable);
        }
        for (int c = 0; c < this.model.getColumnCount(); ++c) {
            variable = this.model.getTreeMapField(c);
            if (!this.condition.accept(variable)) continue;
            current.add((TreeMapField)variable);
        }
        LinkedHashSet<TreeMapField> toRemove = new LinkedHashSet<TreeMapField>();
        toRemove.addAll(old);
        toRemove.removeAll(current);
        for (TreeMapField variable2 : toRemove) {
            this.removeElement(variable2);
        }
        int index = firstIndex;
        for (TreeMapField variable3 : current) {
            if (index >= this.getSize()) {
                this.addElement(variable3);
            } else if (!this.getElementAt(index).equals(variable3)) {
                this.insertElementAt(variable3, index);
            }
            ++index;
        }
        this.fireContentsChanged(this, -1, -1);
    }
}

