/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.crossplatform;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.Map;

public class SwingImage {
    private final int width;
    private final int height;
    private final int physicalWidth;
    private final int physicalHeight;
    private final double scaleFactor;
    private final BufferedImage image;
    private final Graphics2D g2;

    public SwingImage(Graphics2D g2, int width, int height) {
        this.g2 = g2;
        this.width = width;
        this.height = height;
        this.scaleFactor = SwingImage.findCurrentScaleFactor(g2);
        this.physicalWidth = (int)Math.floor((double)width * this.scaleFactor);
        this.physicalHeight = (int)Math.floor((double)height * this.scaleFactor);
        GraphicsConfiguration gc = g2 != null ? g2.getDeviceConfiguration() : null;
        this.image = gc != null ? gc.createCompatibleImage(this.physicalWidth, this.physicalHeight, 3) : new BufferedImage(this.physicalWidth, this.physicalHeight, 2);
    }

    public static double findCurrentScaleFactor(Graphics2D g2) {
        if (g2 != null) {
            return g2.getDeviceConfiguration().getDefaultTransform().getScaleX();
        }
        return 1.0;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public Graphics2D createGraphics() {
        Graphics2D g = this.image.createGraphics();
        if (this.g2 != null) {
            g.addRenderingHints(this.g2.getRenderingHints());
        } else {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Map map = (Map)tk.getDesktopProperty("awt.font.desktophints");
            if (map != null) {
                g.addRenderingHints(map);
            }
        }
        if (this.scaleFactor > 1.0) {
            g.scale(this.scaleFactor, this.scaleFactor);
        }
        return g;
    }

    public BufferedImage getImage() {
        return this.image;
    }
}

