/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.fastvoronoi;

import com.macrofocus.geom.Shape;
import com.treemap.swing.fastvoronoi.Site;
import com.treemap.swing.fastvoronoi.VoronoiDiagram;
import com.treemap.swing.fastvoronoi.originalconvexhull.OpenList;
import com.treemap.swing.fastvoronoi.originalconvexhull.PowerDiagram;
import com.treemap.swing.fastvoronoi.polygon.PolygonSimple;

public class OriginalVoronoiDiagram
implements VoronoiDiagram {
    private Shape[] clippedPolygons;
    private Shape[] polygons;
    public PowerDiagram diagram = new PowerDiagram();

    public OriginalVoronoiDiagram(Shape shape, Site[] sites, double[] weights) {
        int i;
        PolygonSimple rootPolygon;
        if (!(shape instanceof PolygonSimple)) {
            rootPolygon = new PolygonSimple();
            double x = shape.getBounds2D().getX();
            double y = shape.getBounds2D().getY();
            double width = shape.getBounds2D().getWidth();
            double height = shape.getBounds2D().getHeight();
            rootPolygon.add(x, y);
            rootPolygon.add(width, y);
            rootPolygon.add(width, height);
            rootPolygon.add(y, height);
        } else {
            rootPolygon = (PolygonSimple)shape;
        }
        OpenList openList = new OpenList();
        for (i = 0; i < sites.length; ++i) {
            Site site = sites[i];
            com.treemap.swing.fastvoronoi.originalconvexhull.Site site1 = new com.treemap.swing.fastvoronoi.originalconvexhull.Site(site.getPosition().getX(), site.getPosition().getY(), weights[i]);
            site1.setData(i);
            openList.add(site1);
        }
        this.diagram.setSites(openList);
        this.diagram.setClipPoly(rootPolygon);
        this.diagram.computeDiagram();
        this.polygons = new Shape[openList.size];
        this.clippedPolygons = new Shape[openList.size];
        for (i = 0; i < openList.size; ++i) {
            Integer data = (Integer)openList.get(i).getData();
            this.polygons[data.intValue()] = openList.get((int)i).nonClippedPolyon;
            this.clippedPolygons[data.intValue()] = openList.get(i).getPolygon();
        }
        if (sites.length < 4) {
            // empty if block
        }
    }

    @Override
    public Shape getPolygon(int i) {
        return this.polygons[i];
    }

    @Override
    public Shape getClippedPolygon(int i) {
        return this.clippedPolygons[i];
    }
}

