/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.fastvoronoi.convexhull;

import com.treemap.swing.fastvoronoi.convexhull.GraphArc;
import java.util.List;

public class ConflictList {
    private boolean facet;
    protected GraphArc head = null;

    public ConflictList(boolean facet) {
        this.facet = facet;
    }

    public void add(GraphArc arc) {
        if (this.facet) {
            if (this.head != null) {
                this.head.prevf = arc;
            }
            arc.nextf = this.head;
            this.head = arc;
        } else {
            if (this.head != null) {
                this.head.prevv = arc;
            }
            arc.nextv = this.head;
            this.head = arc;
        }
    }

    public boolean empty() {
        return this.head == null;
    }

    public void clear() {
        while (this.head != null) {
            this.head.delete();
        }
    }

    public void getVertices(List list) {
        GraphArc arc = this.head;
        while (arc != null) {
            list.add(arc.vertex);
            arc = arc.nextf;
        }
    }

    public void getFacets(List list) {
        GraphArc arc = this.head;
        while (arc != null) {
            list.add(arc.facet);
            arc = arc.nextv;
        }
    }

    public void fill(List list) {
        GraphArc arc = this.head;
        while (arc != null) {
            list.add(arc.facet);
            arc.facet.setMarked(true);
            arc = arc.nextv;
        }
    }

    public void printFacetList() {
        System.out.print("Facets [");
        GraphArc arc = this.head;
        while (arc != null) {
            System.out.print(" " + arc.facet.getIndex());
            arc = arc.nextv;
        }
        System.out.println(" ]");
    }

    public void printVertexList() {
        System.out.print("Vertices [");
        GraphArc arc = this.head;
        while (arc != null) {
            System.out.print(" " + arc.vertex.getIndex() + " ");
            arc = arc.nextf;
        }
        System.out.println(" ]");
    }
}

