/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.fastvoronoi.convexhull;

import com.treemap.swing.fastvoronoi.convexhull.ConflictList;
import com.treemap.swing.fastvoronoi.convexhull.Edge;
import com.treemap.swing.fastvoronoi.convexhull.Facet;
import com.treemap.swing.fastvoronoi.convexhull.GraphArc;
import com.treemap.swing.fastvoronoi.convexhull.Polytope;
import com.treemap.swing.fastvoronoi.convexhull.Vertex;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ConvexHull
extends Polytope {
    protected int current;
    protected List<Facet> created = new ArrayList<Facet>();
    protected List<Edge> horizon = new ArrayList<Edge>();
    protected List<Facet> visible = new ArrayList<Facet>();

    public void compute() {
        this.prep();
        while (this.current < this.points.size()) {
            Vertex next = (Vertex)this.points.get(this.current);
            if (next.getData().empty()) {
                ++this.current;
                continue;
            }
            this.created.clear();
            this.horizon.clear();
            this.visible.clear();
            next.getData().fill(this.visible);
            for (Facet jF : this.visible) {
                Edge e = jF.getHorizonEdge();
                if (e == null) continue;
                e.findHorizon(this.horizon);
                break;
            }
            Facet last = null;
            Facet first = null;
            for (Edge hE : this.horizon) {
                Facet fn = new Facet(next, hE.getSource(), hE.getDest(), hE.getTwin().getNext().getDest());
                fn.setData(new ConflictList(true));
                this.addFacet(fn);
                this.created.add(fn);
                System.err.println(String.valueOf(hE.getFacet()) + ", " + String.valueOf(hE.getTwin().getFacet()));
                this.addConflicts(hE.getFacet(), hE.getTwin().getFacet(), fn);
                fn.link(hE);
                if (last != null) {
                    fn.link(last, next, hE.getSource());
                }
                last = fn;
                if (first != null) continue;
                first = fn;
            }
            if (first != null && last != null) {
                last.link(first, next, this.horizon.get(0).getSource());
            }
            if (this.created.size() == 0) continue;
            for (Facet f : this.visible) {
                this.removeConflicts(f);
            }
            ++this.current;
            this.created.clear();
        }
    }

    public void restart() {
        this.clear();
        this.current = 0;
        this.created.clear();
        this.horizon.clear();
        this.visible.clear();
        Random rand = new Random(System.currentTimeMillis());
        double d = this.getDiameter();
        double r = d / 2.0;
        for (int i = 0; i < 40; ++i) {
            Vertex v = new Vertex((double)rand.nextFloat() * d - r, (double)rand.nextFloat() * d - r, (double)rand.nextFloat() * d - r);
            this.addVertex(v);
            v.setData(new ConflictList(false));
        }
    }

    public void step() {
        if (this.current == 0) {
            this.prep();
        } else if (this.created.size() == 0) {
            this.stepA();
            this.stepB();
        } else {
            this.stepC();
        }
    }

    private void prep() {
        int i;
        for (int i2 = 0; i2 < this.points.size(); ++i2) {
            ((Vertex)this.points.get(i2)).setIndex(i2);
        }
        Vertex v0 = this.getVertex(0);
        Vertex v1 = this.getVertex(1);
        Vertex v3 = null;
        Vertex v2 = null;
        for (i = 2; i < this.getVertexCount(); ++i) {
            if (v0.linearDependent(this.getVertex(i)) && v1.linearDependent(this.getVertex(i))) continue;
            v2 = this.getVertex(i);
            v2.setIndex(2);
            ((Vertex)this.points.get(2)).setIndex(i);
            this.points.set(i, (Vertex)this.points.get(2));
            this.points.set(2, v2);
            break;
        }
        if (v2 == null) {
            throw new RuntimeException("Not enough non-planar Points");
        }
        Facet f0 = new Facet(v0, v1, v2);
        for (i = 3; i < this.points.size(); ++i) {
            if (f0.getNormal().dot(f0.getVertex(0)) == f0.getNormal().dot((Vertex)this.points.get(i))) continue;
            v3 = (Vertex)this.points.get(i);
            v3.setIndex(3);
            ((Vertex)this.points.get(3)).setIndex(i);
            this.points.set(i, (Vertex)this.points.get(3));
            this.points.set(3, v3);
            break;
        }
        if (v3 == null) {
            throw new RuntimeException("Not enough non-planar Points");
        }
        f0.orient(v3);
        Facet f1 = new Facet(v0, v2, v3, v1);
        Facet f2 = new Facet(v0, v1, v3, v2);
        Facet f3 = new Facet(v1, v2, v3, v0);
        f0.setData(new ConflictList(true));
        f1.setData(new ConflictList(true));
        f2.setData(new ConflictList(true));
        f3.setData(new ConflictList(true));
        this.addFacet(f0);
        this.addFacet(f1);
        this.addFacet(f2);
        this.addFacet(f3);
        f0.link(f1, v0, v2);
        f0.link(f2, v0, v1);
        f0.link(f3, v1, v2);
        f1.link(f2, v0, v3);
        f1.link(f3, v2, v3);
        f2.link(f3, v3, v1);
        for (int i3 = this.current = 4; i3 < this.points.size(); ++i3) {
            Vertex v = (Vertex)this.points.get(i3);
            if (f0.behind(v)) {
                this.addConflict(f0, v);
            }
            if (f1.behind(v)) {
                this.addConflict(f1, v);
            }
            if (f2.behind(v)) {
                this.addConflict(f2, v);
            }
            if (!f3.behind(v)) continue;
            this.addConflict(f3, v);
        }
    }

    public void stepA() {
        if (this.current >= this.getVertexCount()) {
            return;
        }
        this.created.clear();
        this.horizon.clear();
        this.visible.clear();
        Vertex v = this.getVertex(this.current);
        v.getData().getFacets(this.visible);
        if (this.visible.size() == 0) {
            v.setVisible(false);
            ++this.current;
            this.stepA();
            return;
        }
        for (int i = 0; i < this.visible.size(); ++i) {
            this.visible.get(i).setMarked(true);
        }
        for (int i = 0; i < this.visible.size(); ++i) {
            Edge e = this.visible.get(i).getHorizonEdge();
            if (e == null) continue;
            e.findHorizon(this.horizon);
            break;
        }
    }

    public void stepB() {
        if (this.current >= this.getVertexCount()) {
            return;
        }
        Vertex v = this.getVertex(this.current);
        Facet last = null;
        Facet first = null;
        for (int i = 0; i < this.horizon.size(); ++i) {
            Edge e = this.horizon.get(i);
            Facet old = e.getTwin().getFacet();
            Facet f = new Facet(v, e.getDest(), e.getSource());
            f.setData(new ConflictList(true));
            this.addFacet(f);
            this.created.add(f);
            f.setFilled(false);
            f.connect(e);
            if (last != null) {
                f.connect(last, v, e.getSource());
            }
            last = f;
            if (first == null) {
                first = f;
            }
            this.addConflicts(f, old, e.getFacet());
        }
        if (last != null && first != null) {
            last.connect(first, v, first.getEdge(1).getDest());
        }
    }

    public void stepC() {
        int i;
        this.getVertex(this.current).setVisible(false);
        for (i = 0; i < this.visible.size(); ++i) {
            Facet f = this.visible.get(i);
            this.removeConflicts(f);
            this.removeFacet(f);
        }
        for (i = 0; i < this.created.size(); ++i) {
            this.created.get(i).setFilled(true);
        }
        this.created.clear();
        ++this.current;
    }

    public void addConflict(Facet f, Vertex v) {
        GraphArc arc = new GraphArc(f, v);
        f.getData().add(arc);
        v.getData().add(arc);
    }

    public void removeConflicts(Facet f) {
        f.getData().clear();
    }

    public void addConflicts(Facet f, Facet old1, Facet old2) {
        ArrayList l1 = new ArrayList();
        ArrayList l2 = new ArrayList();
        ArrayList<Vertex> l = new ArrayList<Vertex>();
        old1.getData().getVertices(l1);
        old2.getData().getVertices(l2);
        int i1 = 0;
        int i2 = 0;
        while (i1 < l1.size() || i2 < l2.size()) {
            if (i1 < l1.size() && i2 < l2.size()) {
                Vertex v1 = (Vertex)l1.get(i1);
                Vertex v2 = (Vertex)l2.get(i2);
                if (v1.getIndex() == v2.getIndex()) {
                    l.add(v1);
                    ++i1;
                    ++i2;
                    continue;
                }
                if (v1.getIndex() > v2.getIndex()) {
                    l.add(v1);
                    ++i1;
                    continue;
                }
                l.add(v2);
                ++i2;
                continue;
            }
            if (i1 < l1.size()) {
                l.add((Vertex)l1.get(i1++));
                continue;
            }
            l.add((Vertex)l2.get(i2++));
        }
        for (int i = l.size() - 1; i >= 0; --i) {
            Vertex v = (Vertex)l.get(i);
            if (f.behind(v)) continue;
            this.addConflict(f, v);
        }
    }
}

