/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.fastvoronoi.convexhull;

import com.treemap.swing.fastvoronoi.convexhull.Face;
import com.treemap.swing.fastvoronoi.convexhull.Facet;
import com.treemap.swing.fastvoronoi.convexhull.Vertex;
import java.util.List;

public class Edge
extends Face {
    private Vertex a;
    private Vertex b;
    private Facet facet;
    private Edge next;
    private Edge prev;
    private Edge twin;

    public Edge(Vertex a, Vertex b, Facet facet) {
        this.a = a;
        this.b = b;
        this.facet = facet;
        this.twin = null;
        this.next = null;
        this.prev = null;
    }

    public Facet getFacet() {
        return this.facet;
    }

    public Edge getNext() {
        return this.next;
    }

    public void setNext(Edge next) {
        this.next = next;
    }

    public Edge getPrev() {
        return this.prev;
    }

    public void setPrev(Edge prev) {
        this.prev = prev;
    }

    public Edge getTwin() {
        return this.twin;
    }

    public void setTwin(Edge twin) {
        this.twin = twin;
    }

    public Vertex getSource() {
        return this.a;
    }

    public Vertex getDest() {
        return this.b;
    }

    public boolean onHorizon() {
        if (this.twin == null) {
            return false;
        }
        return !this.facet.isMarked() && this.twin.getFacet().isMarked();
    }

    public void findHorizon(List horizon) {
        if (this.onHorizon()) {
            if (horizon.size() > 0 && this == horizon.get(0)) {
                return;
            }
            horizon.add(this);
            this.next.findHorizon(horizon);
        } else if (this.twin != null) {
            this.twin.getNext().findHorizon(horizon);
        }
    }

    public boolean matches(Vertex a, Vertex b) {
        return this.a == a && this.b == b || this.a == b && this.b == a;
    }
}

