/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.fastvoronoi.convexhull;

import com.treemap.swing.fastvoronoi.convexhull.Edge;
import com.treemap.swing.fastvoronoi.convexhull.Face;
import com.treemap.swing.fastvoronoi.convexhull.Vector;
import com.treemap.swing.fastvoronoi.convexhull.Vertex;
import java.util.Arrays;

public class Facet
extends Face {
    private Vertex[] v = new Vertex[3];
    private Edge[] e = new Edge[3];
    private Vector normal;
    private boolean filled;
    private boolean marked;

    public Facet(Vertex a, Vertex b, Vertex c) {
        this.v[0] = a;
        this.v[1] = b;
        this.v[2] = c;
        this.filled = true;
        this.marked = false;
        this.normal = Vertex.subtract(b, a).cross(Vertex.subtract(c, a));
        this.normal.normalize();
        this.createEdges();
    }

    public Facet(Vertex a, Vertex b, Vertex c, Vertex d) {
        this(a, b, c);
        this.orient(d);
    }

    public Vector getNormal() {
        return this.normal;
    }

    public Vertex getVertex(int index) {
        return this.v[index];
    }

    public int getVertexCount() {
        return this.v.length;
    }

    public Edge getEdge(int index) {
        if (index < 3 && index >= 0) {
            return this.e[index];
        }
        return null;
    }

    public int getEdgeCount() {
        return this.e.length;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setFilled(boolean filled) {
        this.filled = filled;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setMarked(boolean marked) {
        this.marked = marked;
    }

    public boolean behind(Vertex test) {
        return this.normal.dot(test) < this.normal.dot(this.v[0]);
    }

    public void link(Facet f0, Vertex v0, Vertex v1) {
        Edge twin = f0.getEdge(v0, v1);
        if (twin == null) {
            throw new RuntimeException("Twin of Edge is NULL. Cannot Connect Edges!");
        }
        Edge edge = this.getEdge(v0, v1);
        twin.setTwin(edge);
        edge.setTwin(twin);
    }

    public void link(Edge e) {
        Edge edge = this.getEdge(e.getSource(), e.getDest());
        assert (e != edge);
        e.setTwin(edge);
        edge.setTwin(e);
    }

    private Edge getEdge(Vertex v0, Vertex v1) {
        for (int i = 0; i < 3; ++i) {
            if (!this.e[i].matches(v0, v1)) continue;
            return this.e[i];
        }
        return null;
    }

    public void connect(Facet adjacent, Vertex a, Vertex b) {
        Edge inner = this.getMatchingEdge(a, b);
        Edge outter = adjacent.getMatchingEdge(a, b);
        inner.setTwin(outter);
        outter.setTwin(inner);
    }

    public void connect(Edge e) {
        Edge inner = this.getMatchingEdge(e.getSource(), e.getDest());
        inner.setTwin(e);
        e.setTwin(inner);
    }

    public Edge getMatchingEdge(Vertex a, Vertex b) {
        for (int i = 0; i < 3; ++i) {
            if (!this.e[i].matches(a, b)) continue;
            return this.e[i];
        }
        return null;
    }

    public Edge getHorizonEdge() {
        for (int i = 0; i < 3; ++i) {
            Edge opposite = this.e[i].getTwin();
            if (opposite == null || !opposite.onHorizon()) continue;
            return this.e[i];
        }
        return null;
    }

    public void orient(Vertex reference) {
        if (!this.behind(reference)) {
            Vertex tmp = this.v[1];
            this.v[1] = this.v[2];
            this.v[2] = tmp;
            this.normal.negate();
            this.createEdges();
        }
    }

    private void createEdges() {
        this.e[0] = null;
        this.e[1] = null;
        this.e[2] = null;
        this.e[0] = new Edge(this.v[0], this.v[1], this);
        this.e[1] = new Edge(this.v[1], this.v[2], this);
        this.e[2] = new Edge(this.v[2], this.v[0], this);
        this.e[0].setNext(this.e[1]);
        this.e[0].setPrev(this.e[2]);
        this.e[1].setNext(this.e[2]);
        this.e[1].setPrev(this.e[0]);
        this.e[2].setNext(this.e[0]);
        this.e[2].setPrev(this.e[1]);
    }

    public String toString() {
        return "Facet{, normal=" + String.valueOf(this.normal) + "v=" + Arrays.toString(this.v) + ", e=" + Arrays.toString(this.e) + ", filled=" + this.filled + ", marked=" + this.marked + "}";
    }
}

