/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.fastvoronoi.originalconvexhull;

import com.treemap.swing.fastvoronoi.originalconvexhull.ConflictList;
import com.treemap.swing.fastvoronoi.originalconvexhull.Edge;
import com.treemap.swing.fastvoronoi.originalconvexhull.Facet;
import com.treemap.swing.fastvoronoi.originalconvexhull.GraphArc;
import com.treemap.swing.fastvoronoi.originalconvexhull.NotEnoughPointsException;
import com.treemap.swing.fastvoronoi.originalconvexhull.Vertex;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ConvexHull {
    private List<Vertex> points;
    private List<Facet> facets;
    private List<Facet> created;
    private List<Edge> horizon;
    private List<Facet> visible;
    private int current = 0;
    private boolean permutate = false;
    protected final Random rand = new Random(1985L);

    public ConvexHull() {
        this.points = new ArrayList<Vertex>();
        this.facets = new ArrayList<Facet>();
        this.created = new ArrayList<Facet>();
        this.horizon = new ArrayList<Edge>();
        this.visible = new ArrayList<Facet>();
    }

    public void addPoint(Vertex v) {
        Vertex tempVertex = new Vertex(v.x, v.y, v.z);
        tempVertex.originalObject = v;
        tempVertex.setIndex(this.points.size());
        this.points.add(tempVertex);
    }

    public void addPoint(double x, double y, double z) {
        Vertex v = new Vertex(x, y, z);
        v.setIndex(this.points.size());
        this.points.add(v);
    }

    public List<Facet> compute() {
        this.prep();
        while (this.current < this.points.size()) {
            Vertex v = this.points.get(this.current);
            if (v.getList().empty()) {
                ++this.current;
                continue;
            }
            this.created.clear();
            this.horizon.clear();
            this.visible.clear();
            v.getList().fill(this.visible);
            for (Facet jF : this.visible) {
                Edge e = jF.getHorizon();
                if (e == null) continue;
                e.findHorizon(this.horizon);
                break;
            }
            Facet last = null;
            Facet first = null;
            for (Edge e : this.horizon) {
                Facet f = new Facet(v, e.getSource(), e.getDest(), e.getTwin().getNext().getDest());
                f.setList(new ConflictList(true));
                this.addFacet(f);
                this.created.add(f);
                this.addConflicts(e.getFacet(), e.getTwin().getFacet(), f);
                f.link(e);
                if (last != null) {
                    f.link(last, v, e.getSource());
                }
                last = f;
                if (first != null) continue;
                first = f;
            }
            if (first != null && last != null) {
                last.link(first, v, this.horizon.get(0).getSource());
            }
            if (this.created.size() == 0) continue;
            for (Facet f : this.visible) {
                this.removeConflict(f);
            }
            ++this.current;
            this.created.clear();
        }
        return this.facets;
    }

    private void addConflicts(Facet old1, Facet old2, Facet fn) {
        Vertex v1;
        ArrayList<Vertex> l1 = new ArrayList<Vertex>();
        old1.getList().getVertices(l1);
        ArrayList<Vertex> l2 = new ArrayList<Vertex>();
        old2.getList().getVertices(l2);
        ArrayList<Vertex> nCL = new ArrayList<Vertex>();
        int l = 0;
        int i = 0;
        while (i < l1.size() || l < l2.size()) {
            if (i < l1.size() && l < l2.size()) {
                v1 = (Vertex)l1.get(i);
                Vertex v2 = (Vertex)l2.get(l);
                if (v1.getIndex() == v2.getIndex()) {
                    nCL.add(v1);
                    ++i;
                    ++l;
                    continue;
                }
                if (v1.getIndex() > v2.getIndex()) {
                    nCL.add(v1);
                    ++i;
                    continue;
                }
                nCL.add(v2);
                ++l;
                continue;
            }
            if (i < l1.size()) {
                nCL.add((Vertex)l1.get(i++));
                continue;
            }
            nCL.add((Vertex)l2.get(l++));
        }
        for (i = nCL.size() - 1; i >= 0; --i) {
            v1 = (Vertex)nCL.get(i);
            if (!fn.conflict(v1)) continue;
            this.addConflict(fn, v1);
        }
    }

    private void removeConflict(Facet f) {
        f.removeConflict();
        int index = f.getIndex();
        f.setIndex(-1);
        if (index == this.facets.size() - 1) {
            this.facets.remove(this.facets.size() - 1);
            return;
        }
        if (index >= this.facets.size() || index < 0) {
            return;
        }
        Facet last = this.facets.remove(this.facets.size() - 1);
        last.setIndex(index);
        this.facets.set(index, last);
    }

    private void prep() {
        int i;
        if (this.points.size() <= 3) {
            throw new NotEnoughPointsException();
        }
        if (this.permutate) {
            this.permutation();
        }
        for (int i2 = 0; i2 < this.points.size(); ++i2) {
            this.points.get(i2).setIndex(i2);
        }
        Vertex v0 = this.points.get(0);
        Vertex v1 = this.points.get(1);
        Vertex v3 = null;
        Vertex v2 = null;
        for (i = 2; i < this.points.size(); ++i) {
            if (v0.linearDependent(this.points.get(i)) && v1.linearDependent(this.points.get(i))) continue;
            v2 = this.points.get(i);
            v2.setIndex(2);
            this.points.get(2).setIndex(i);
            this.points.set(i, this.points.get(2));
            this.points.set(2, v2);
            break;
        }
        if (v2 == null) {
            throw new NotEnoughPointsException("Not enough non-planar Points");
        }
        Facet f0 = new Facet(v0, v1, v2);
        for (i = 3; i < this.points.size(); ++i) {
            if (f0.getNormal().dot(f0.getVertex(0)) == f0.getNormal().dot(this.points.get(i))) continue;
            v3 = this.points.get(i);
            v3.setIndex(3);
            this.points.get(3).setIndex(i);
            this.points.set(i, this.points.get(3));
            this.points.set(3, v3);
            break;
        }
        if (v3 == null) {
            throw new NotEnoughPointsException("Not enough non-planar Points");
        }
        f0.orient(v3);
        Facet f1 = new Facet(v0, v2, v3, v1);
        Facet f2 = new Facet(v0, v1, v3, v2);
        Facet f3 = new Facet(v1, v2, v3, v0);
        this.addFacet(f0);
        this.addFacet(f1);
        this.addFacet(f2);
        this.addFacet(f3);
        f0.link(f1, v0, v2);
        f0.link(f2, v0, v1);
        f0.link(f3, v1, v2);
        f1.link(f2, v0, v3);
        f1.link(f3, v2, v3);
        f2.link(f3, v3, v1);
        for (int i3 = this.current = 4; i3 < this.points.size(); ++i3) {
            Vertex v = this.points.get(i3);
            if (f0.conflict(v)) {
                this.addConflict(f0, v);
            }
            if (f1.conflict(v)) {
                this.addConflict(f1, v);
            }
            if (f2.conflict(v)) {
                this.addConflict(f2, v);
            }
            if (!f3.conflict(v)) continue;
            this.addConflict(f3, v);
        }
    }

    private void permutation() {
        int pointSize = this.points.size();
        for (int i = pointSize - 1; i > 0; --i) {
            int ra = this.rand.nextInt(i);
            Vertex temp = this.points.get(ra);
            temp.setIndex(i);
            Vertex currentItem = this.points.get(i);
            currentItem.setIndex(ra);
            this.points.set(ra, currentItem);
            this.points.set(i, temp);
        }
    }

    private void addFacet(Facet f0) {
        f0.setIndex(this.facets.size());
        this.facets.add(f0);
    }

    private void addConflict(Facet f0, Vertex v) {
        GraphArc e = new GraphArc(f0, v);
        f0.getList().add(e);
        v.getList().add(e);
    }

    public int getVertexCount() {
        return this.points.size();
    }

    public Vertex getVertex(int i) {
        return this.points.get(i);
    }

    public int getFacetCount() {
        return this.facets.size();
    }

    public Facet getFacet(int i) {
        return this.facets.get(i);
    }

    private boolean isPermutate() {
        return this.permutate;
    }

    private void setPermutate(boolean permutate) {
        this.permutate = permutate;
    }
}

