/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.fastvoronoi.originalconvexhull;

import com.treemap.swing.fastvoronoi.originalconvexhull.Facet;
import com.treemap.swing.fastvoronoi.originalconvexhull.Vertex;
import java.util.List;

public class Edge {
    private Vertex a;
    private Vertex b;
    private Facet facet;
    private Edge next;
    private Edge prev;
    private Edge twin;

    public Edge(Vertex source, Vertex dest, Facet facet) {
        this.a = source;
        this.b = dest;
        this.facet = facet;
    }

    public void setDest(Vertex dest) {
        this.b = dest;
    }

    public boolean isEqual(Vertex origin, Vertex dest) {
        return this.a.equals(origin) && this.b.equals(dest) || this.a.equals(dest) && this.b.equals(origin);
    }

    public Vertex getSource() {
        return this.a;
    }

    public void setSource(Vertex source) {
        this.a = source;
    }

    public Edge getTwin() {
        return this.twin;
    }

    public void setTwin(Edge twin) {
        this.twin = twin;
    }

    public Facet getFacet() {
        return this.facet;
    }

    public void setFacet(Facet facet) {
        this.facet = facet;
    }

    public Edge getNext() {
        return this.next;
    }

    public void setNext(Edge next) {
        this.next = next;
    }

    public Edge getPrev() {
        return this.prev;
    }

    public void setPrev(Edge prev) {
        this.prev = prev;
    }

    public String toString() {
        return this.a.toString() + "->" + this.b.toString();
    }

    public Vertex getDest() {
        return this.b;
    }

    public boolean isHorizon() {
        return this.twin != null && this.twin.getFacet().isMarked() && !this.facet.isMarked();
    }

    public void findHorizon(List<Edge> horizon) {
        if (this.isHorizon()) {
            if (horizon.size() > 0 && this == horizon.get(0)) {
                return;
            }
            horizon.add(this);
            this.next.findHorizon(horizon);
        } else if (this.twin != null) {
            this.twin.getNext().findHorizon(horizon);
        }
    }
}

