/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.fastvoronoi.originalconvexhull;

import com.treemap.swing.fastvoronoi.originalconvexhull.Vertex;

public class Vector {
    public double x;
    public double y;
    public double z;

    public Vector() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public Vector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector(Vector a) {
        this.x = a.x;
        this.y = a.y;
        this.z = a.z;
    }

    public Vector subtract(Vector b) {
        return new Vector(this.x - b.x, this.y - b.y, this.z - b.z);
    }

    public Vector cross(Vector b) {
        return new Vector(this.y * b.z - this.z * b.y, this.z * b.x - this.x * b.z, this.x * b.y - this.y * b.x);
    }

    public double dot(Vector b) {
        return this.x * b.x + this.y * b.y + this.z * b.z;
    }

    public double dot(Vertex b) {
        return this.x * b.x + this.y * b.y + this.z * b.z;
    }

    public void normalize() {
        double len = this.length();
        if (len > 0.0) {
            this.x /= len;
            this.y /= len;
            this.z /= len;
        }
    }

    public void negate() {
        this.x *= -1.0;
        this.y *= -1.0;
        this.z *= -1.0;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public String toString() {
        return "X: " + this.x + "\t Y: " + this.y + "\t Z: " + this.z;
    }
}

