/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.fastvoronoi.polygon;

import com.treemap.swing.fastvoronoi.polygon.InfoPoint;
import com.treemap.swing.fastvoronoi.polygon.InsideFlag;
import com.treemap.swing.fastvoronoi.polygon.Point2D;
import com.treemap.swing.fastvoronoi.polygon.cVertex;
import com.treemap.swing.fastvoronoi.polygon.cVertexList;

public class ConvexClip {
    public cVertexList inters;

    public void Start(cVertexList list1, cVertexList list2) {
        cVertexList p = list1.copyList();
        cVertexList q = list2.copyList();
        if (!ConvexClip.isConvex(p)) {
            p.ReverseList();
            if (!ConvexClip.isConvex(p)) {
                System.out.println("Polygons are not Convex...");
                throw new RuntimeException("Polygons are not Convex...");
            }
        }
        if (!ConvexClip.isConvex(q)) {
            q.ReverseList();
            if (!ConvexClip.isConvex(q)) {
                System.out.println("Polygons are not Convex...");
                throw new RuntimeException("Polygons are not Convex...");
            }
        }
        this.inters = new cVertexList();
        this.ConvexIntersection(p, q, p.n, q.n);
    }

    private void ConvexIntersection(cVertexList p, cVertexList q, int n, int m) {
        cVertex currp = p.head;
        cVertex currq = q.head;
        InsideFlag flg = InsideFlag.UNKNOWN;
        int ap = 0;
        int aq = 0;
        Point2D nil = new Point2D();
        boolean FirstPoint = true;
        do {
            InfoPoint c = this.intersect(currp.prev.v, currp.v, currq.prev.v, currq.v);
            Point2D vQ = new Point2D(currq.v.x - currq.prev.v.x, currq.v.y - currq.prev.v.y);
            Point2D vP = new Point2D(currp.v.x - currp.prev.v.x, currp.v.y - currp.prev.v.y);
            int cross = ConvexClip.AreaSign(nil, vP, vQ);
            int pInQ = ConvexClip.AreaSign(currq.prev.v, currq.v, currp.v);
            int qInP = ConvexClip.AreaSign(currp.prev.v, currp.v, currq.v);
            if (c.code == '1') {
                if (flg == InsideFlag.UNKNOWN && FirstPoint) {
                    FirstPoint = false;
                    aq = 0;
                    ap = 0;
                }
                this.inters.InsertBeforeHead(new cVertex(c.erg));
                if (pInQ > 0) {
                    flg = InsideFlag.PIN;
                } else if (qInP > 0) {
                    flg = InsideFlag.QIN;
                }
            }
            if (c.code == 'e' && this.dot(vP, vQ) < 0.0) {
                this.inters.InsertBeforeHead(new cVertex(c.erg));
                this.inters.InsertBeforeHead(new cVertex(c.snd));
                return;
            }
            if (cross == 0 && pInQ < 0 && qInP < 0) {
                return;
            }
            if (cross == 0 && pInQ == 0 && qInP == 0) {
                if (flg == InsideFlag.PIN) {
                    ++aq;
                    currq = currq.next;
                    continue;
                }
                ++ap;
                currp = currp.next;
                continue;
            }
            if (cross >= 0) {
                if (qInP > 0) {
                    if (flg == InsideFlag.PIN) {
                        this.inters.InsertBeforeHead(new cVertex(currp.v));
                    }
                    ++ap;
                    currp = currp.next;
                    continue;
                }
                if (flg == InsideFlag.QIN) {
                    this.inters.InsertBeforeHead(new cVertex(currq.v));
                }
                ++aq;
                currq = currq.next;
                continue;
            }
            if (pInQ > 0) {
                if (flg == InsideFlag.QIN) {
                    this.inters.InsertBeforeHead(new cVertex(currq.v));
                }
                ++aq;
                currq = currq.next;
                continue;
            }
            if (flg == InsideFlag.PIN) {
                this.inters.InsertBeforeHead(new cVertex(currp.v));
            }
            ++ap;
            currp = currp.next;
        } while ((ap < n || aq < m) && ap < 2 * n && aq < 2 * m);
    }

    private double dot(Point2D vP, Point2D vQ) {
        return vP.x * vQ.x + vP.y * vQ.y;
    }

    private static boolean isConvex(cVertexList p2) {
        if (p2.n < 3) {
            return false;
        }
        cVertex curr = p2.head;
        curr = curr.next;
        while (curr != p2.head) {
            if (ConvexClip.AreaSign(curr.v, curr.next.v, curr.next.next.v) < 0) {
                return false;
            }
            curr = curr.next;
        }
        return true;
    }

    public static int AreaSign(Point2D a, Point2D b, Point2D c) {
        double area = (b.x - a.x) * (c.y - a.y) - (c.x - a.x) * (b.y - a.y);
        if (area > 5.0E-6) {
            return 1;
        }
        if (area < -5.0E-6) {
            return -1;
        }
        return 0;
    }

    private static boolean between(Point2D a, Point2D b, Point2D c) {
        if (a.x != b.x) {
            return c.x >= a.x && c.x <= b.x || c.x <= a.x && c.x >= b.x;
        }
        return c.y >= a.y && c.y <= b.y || c.y <= a.y && c.y >= b.y;
    }

    public InfoPoint intersect(Point2D a, Point2D b, Point2D c, Point2D d) {
        double denum = (d.x - c.x) * (b.y - a.y) - (b.x - a.x) * (d.y - c.y);
        if (denum == 0.0) {
            if (ConvexClip.AreaSign(a, b, c) == 0) {
                if (ConvexClip.between(a, b, c) && ConvexClip.between(a, b, d)) {
                    return new InfoPoint(c, d, 'e');
                }
                if (ConvexClip.between(c, d, a) && ConvexClip.between(c, d, b)) {
                    return new InfoPoint(a, b, 'e');
                }
                if (ConvexClip.between(a, b, c) && ConvexClip.between(c, d, b)) {
                    return new InfoPoint(c, b, 'e');
                }
                if (ConvexClip.between(a, b, c) && ConvexClip.between(c, d, a)) {
                    return new InfoPoint(c, a, 'e');
                }
                if (ConvexClip.between(a, b, d) && ConvexClip.between(c, d, b)) {
                    return new InfoPoint(d, b, 'e');
                }
                if (ConvexClip.between(a, b, d) && ConvexClip.between(c, d, a)) {
                    return new InfoPoint(d, a, 'e');
                }
            }
            return new InfoPoint(null, 'n');
        }
        double t = (a.x * (d.y - c.y) - a.y * (d.x - c.x) + c.y * (d.x - c.x) - c.x * (d.y - c.y)) / denum;
        double s = ((b.x - a.x) * a.y + c.x * (b.y - a.y) - a.x * (b.y - a.y) - c.y * (b.x - a.x)) / -denum;
        if (t >= 0.0 && t <= 1.0 && s >= 0.0 && s <= 1.0) {
            return new InfoPoint(new Point2D(a.x + t * (b.x - a.x), a.y + t * (b.y - a.y)), '1');
        }
        return new InfoPoint(null, 'n');
    }
}

