/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.originalfastvoronoi;

import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.AbstractAlgorithm;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapWorker;
import com.treemap.swing.originalfastvoronoi.StatusObject;
import com.treemap.swing.originalfastvoronoi.Tuple2ID;
import com.treemap.swing.originalfastvoronoi.VoronoiTreemap;
import com.treemap.swing.originalfastvoronoi.j2d.PolygonSimple;
import java.util.ArrayList;

public class OriginalFastVoronoiAlgorithm
extends AbstractAlgorithm {
    public String toString() {
        return "Fast Voronoi (Original)";
    }

    public boolean breadthFirstLayout(Shape shape, MutableTreeMapNode parent, final MutableTreeMapNode[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, TreeMapWorker worker) {
        if (children.length > 1) {
            StatusObject statusObject = new StatusObject(){

                @Override
                public void finishedNode(int node, int layer, int[] childrenxxx, PolygonSimple[] polygons) {
                    if (polygons != null) {
                        for (int i = 0; i < polygons.length; ++i) {
                            PolygonSimple polygon = polygons[i];
                            MutableTreeMapNode child = children[i];
                            child.setShape((Shape)polygon);
                        }
                    }
                }

                @Override
                public void finished() {
                }
            };
            VoronoiTreemap voronoiTreemap = new VoronoiTreemap(statusObject);
            if (shape instanceof PolygonSimple) {
                voronoiTreemap.setRootPolygon((PolygonSimple)shape);
            } else {
                Rectangle2D bounds = shape.getBounds2D();
                PolygonSimple root = new PolygonSimple(4);
                root.add(bounds.getMinX(), bounds.getMinY());
                root.add(bounds.getMaxX(), bounds.getMinY());
                root.add(bounds.getMaxX(), bounds.getMaxY());
                root.add(bounds.getMinX(), bounds.getMaxY());
                voronoiTreemap.setRootPolygon(root);
            }
            ArrayList<ArrayList<Integer>> treeList = new ArrayList<ArrayList<Integer>>();
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(0);
            for (int i = 0; i < children.length; ++i) {
                MutableTreeMapNode child = children[i];
                list.add(i + 1);
            }
            treeList.add(list);
            voronoiTreemap.setTree(treeList);
            ArrayList<Tuple2ID> areaGoals = new ArrayList<Tuple2ID>();
            for (int i = 0; i < children.length; ++i) {
                MutableTreeMapNode child = children[i];
                areaGoals.add(new Tuple2ID(i + 1, child.getSize()));
            }
            voronoiTreemap.setAreaGoals(areaGoals);
            voronoiTreemap.setUseNegativeWeights(false);
            voronoiTreemap.compute();
        } else if (children.length == 1) {
            children[0].setShape(shape);
        }
        return false;
    }

    public boolean isCompatible(Shape shape) {
        return shape instanceof Rectangle2D || shape instanceof PolygonSimple;
    }
}

