/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.originalfastvoronoi;

import com.treemap.swing.originalfastvoronoi.StatusObject;
import com.treemap.swing.originalfastvoronoi.Tuple2ID;
import com.treemap.swing.originalfastvoronoi.Tuple3ID;
import com.treemap.swing.originalfastvoronoi.VoroNode;
import com.treemap.swing.originalfastvoronoi.VoronoiTreemapInterface;
import com.treemap.swing.originalfastvoronoi.j2d.Point2D;
import com.treemap.swing.originalfastvoronoi.j2d.PolygonSimple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Stack;

public class VoronoiTreemap
implements Iterable<VoroNode>,
StatusObject,
VoronoiTreemapInterface {
    private boolean initialized = false;
    private boolean useBorder = false;
    private double shrinkPercentage = 1.0;
    private boolean showLeafs = false;
    private int numberThreads = 1;
    protected VoroNode root;
    private PolygonSimple rootPolygon;
    long timeStart;
    long timeEnd;
    private int numberMaxIterations = 200000;
    private double preflowPercentage = 0.08;
    private double preflowIncrease = 1.3;
    private boolean useNegativeWeights = true;
    private boolean useExtrapolation = false;
    private boolean cancelOnThreshold = false;
    private boolean cancelOnMaxIterat = true;
    protected double errorAreaThreshold = 0.001;
    protected boolean preflowFinished = false;
    private boolean guaranteeValidCells = false;
    private boolean aggressiveMode = false;
    private StatusObject statusObject;
    long randomSeed = 1985L;
    Random rand = new Random(this.randomSeed);
    private HashMap<Integer, VoroNode> idToNode;

    public VoronoiTreemap(StatusObject statusObject) {
        this();
        this.statusObject = statusObject;
    }

    public VoronoiTreemap() {
        this.init();
    }

    protected void init() {
        this.initialized = false;
        this.useBorder = false;
        this.shrinkPercentage = 1.0;
        this.showLeafs = false;
        this.numberThreads = 1;
        this.root = null;
        this.rootPolygon = null;
        this.numberMaxIterations = 200;
        this.preflowPercentage = 0.08;
        this.preflowIncrease = 1.3;
        this.useNegativeWeights = true;
        this.useExtrapolation = false;
        this.cancelOnThreshold = false;
        this.cancelOnMaxIterat = true;
        this.errorAreaThreshold = 0.001;
        this.preflowFinished = false;
        this.guaranteeValidCells = false;
        this.statusObject = null;
        this.rand = new Random(1985L);
        if (this.idToNode != null) {
            this.idToNode.clear();
        }
    }

    protected void initVoroNodes() {
        if (!this.initialized && this.root != null) {
            this.initialized = true;
            this.root.calculateWeights();
        }
    }

    @Override
    public void compute() {
        if (this.rootPolygon == null) {
            throw new RuntimeException("Root Polygon not set.");
        }
        this.timeStart = System.currentTimeMillis();
        this.initVoroNodes();
        this.root.iterate();
        this.statusObject.finishedNode(this.root.getNodeID(), this.root.getHeight(), this.root.getChildrenIDs(), this.root.getChildrenPolygons());
    }

    protected void setSettingsToVoroNode(VoroNode node) {
        node.setTreemap(this);
    }

    @Override
    public void setTreeAndWeights(PolygonSimple rootPolygon, ArrayList<ArrayList<Integer>> treeStructure, ArrayList<Tuple2ID> areaGoals, ArrayList<Tuple3ID> relativePositions) {
        this.rootPolygon = rootPolygon;
        this.setTree(treeStructure);
        if (relativePositions == null) {
            for (VoroNode voroNode : this.idToNode.values()) {
                double x = this.rand.nextDouble();
                double y = this.rand.nextDouble();
                voroNode.setRelativeVector(new Point2D(x, y));
            }
        } else {
            this.setReferenceMap(relativePositions);
        }
        this.root.setVoroPolygon(rootPolygon);
    }

    protected final VoroNode createVoroNode(HashMap<Integer, VoroNode> idToNode, ArrayList<Integer> adjacencyLine) {
        ArrayList<Integer> childList = adjacencyLine;
        if (adjacencyLine == null) {
            return null;
        }
        Integer parentId = childList.get(0);
        int numberChildren = 0;
        numberChildren = childList.size() - 1;
        VoroNode voroNode = null;
        voroNode = idToNode.get(parentId);
        if (voroNode == null) {
            voroNode = new VoroNode(parentId, numberChildren);
        }
        voroNode.setTreemap(this);
        this.setSettingsToVoroNode(voroNode);
        if (numberChildren >= 1) {
            for (int i = 1; i < numberChildren + 1; ++i) {
                Integer childId = childList.get(i);
                VoroNode voroChild = new VoroNode(childId);
                idToNode.put(childId, voroChild);
                voroNode.addChild(voroChild);
                voroChild.setParent(voroNode);
                voroNode.setTreemap(this);
                this.setSettingsToVoroNode(voroNode);
            }
        }
        return voroNode;
    }

    @Override
    public boolean getShowLeafs() {
        return this.showLeafs;
    }

    @Override
    public Iterator<VoroNode> iterator() {
        return new NodeIterator(this.root);
    }

    @Override
    public synchronized void finished() {
        this.timeEnd = System.currentTimeMillis();
        if (this.statusObject != null) {
            this.statusObject.finished();
        }
    }

    @Override
    public void setShrinkPercentage(double shrinkPercentage) {
        this.shrinkPercentage = shrinkPercentage;
    }

    @Override
    public double getShrinkPercentage() {
        return this.shrinkPercentage;
    }

    @Override
    public void setUseBorder(boolean useBorder) {
        this.useBorder = useBorder;
    }

    @Override
    public boolean getUseBorder() {
        return this.useBorder;
    }

    @Override
    public void setNumberMaxIterations(int numberMaxIterations) {
        this.numberMaxIterations = numberMaxIterations;
    }

    @Override
    public int getNumberMaxIterations() {
        return this.numberMaxIterations;
    }

    @Override
    public void setPreflowPercentage(double preflowPercentage) {
        this.preflowPercentage = preflowPercentage;
    }

    @Override
    public double getPreflowPercentage() {
        return this.preflowPercentage;
    }

    @Override
    public void setPreflowIncrease(double preflowIncrease) {
        this.preflowIncrease = preflowIncrease;
    }

    @Override
    public double getPreflowIncrease() {
        return this.preflowIncrease;
    }

    @Override
    public void setUseExtrapolation(boolean useExtrapolation) {
        this.useExtrapolation = useExtrapolation;
    }

    @Override
    public boolean getUseExtrapolation() {
        return this.useExtrapolation;
    }

    @Override
    public void setCancelOnThreshold(boolean cancelOnThreshold) {
        this.cancelOnThreshold = cancelOnThreshold;
    }

    @Override
    public boolean getCancelOnThreshold() {
        return this.cancelOnThreshold;
    }

    @Override
    public void setCancelOnMaxIteration(boolean cancelOnMaxIterat) {
        this.cancelOnMaxIterat = cancelOnMaxIterat;
    }

    @Override
    public boolean getCancelOnMaxIteration() {
        return this.cancelOnMaxIterat;
    }

    @Override
    public void setRootPolygon(PolygonSimple rootPolygon) {
        this.rootPolygon = rootPolygon;
    }

    @Override
    public void setRootRectangle(double x, double y, double width, double height) {
        this.rootPolygon = new PolygonSimple();
        this.rootPolygon.add(x, y);
        this.rootPolygon.add(x + width, y);
        this.rootPolygon.add(x + width, y + height);
        this.rootPolygon.add(x, y + height);
    }

    @Override
    public PolygonSimple getRootPolygon() {
        return this.rootPolygon;
    }

    @Override
    public void setGuaranteeValidCells(boolean guaranteeInvariant) {
        this.guaranteeValidCells = guaranteeInvariant;
    }

    @Override
    public boolean getGuaranteeValidCells() {
        return this.guaranteeValidCells;
    }

    @Override
    public void setNumberThreads(int numberThreads) {
        this.numberThreads = numberThreads >= 1 ? numberThreads : 1;
    }

    int getNumberThreads() {
        return this.numberThreads;
    }

    @Override
    public void setStatusObject(StatusObject statusObject) {
        this.statusObject = statusObject;
    }

    @Override
    public StatusObject getStatusObject() {
        return this.statusObject;
    }

    @Override
    public void finishedNode(int Node2, int layer, int[] children, PolygonSimple[] polygons) {
        if (this.statusObject != null) {
            this.statusObject.finishedNode(Node2, layer, children, polygons);
        }
    }

    @Override
    public void setAreaGoals(ArrayList<Tuple2ID> areaGoals) {
        if (areaGoals != null) {
            for (Tuple2ID tuple : areaGoals) {
                VoroNode voroNode = null;
                voroNode = this.idToNode.get(tuple.id);
                if (voroNode != null) {
                    voroNode.setWeight(tuple.value);
                    continue;
                }
                if (tuple.id == this.root.getNodeID()) continue;
                System.out.println("id: " + tuple.id);
                throw new RuntimeException("There is no node in the tree structure with this ID.");
            }
        }
    }

    @Override
    public void setReferenceMap(ArrayList<Tuple3ID> relativePositions) {
        for (Tuple3ID tuple : relativePositions) {
            VoroNode voroNode = null;
            voroNode = this.idToNode.get(tuple.id);
            if (voroNode != null) {
                voroNode.setRelativeVector(new Point2D(tuple.valueX, tuple.valueY));
                continue;
            }
            throw new RuntimeException("ReferencePosition for ID without node in the tree structure.");
        }
    }

    @Override
    public void setTree(ArrayList<ArrayList<Integer>> treeStructure) {
        this.idToNode = new HashMap();
        ArrayList<Integer> line = treeStructure.get(0);
        int numberLines = treeStructure.size();
        this.root = this.createVoroNode(this.idToNode, line);
        for (int i = 1; i < numberLines; ++i) {
            this.createVoroNode(this.idToNode, treeStructure.get(i));
        }
        for (VoroNode voroNode : this.idToNode.values()) {
            double x = this.rand.nextDouble();
            double y = this.rand.nextDouble();
            voroNode.setRelativeVector(new Point2D(x, y));
        }
        this.root.setVoroPolygon(this.rootPolygon);
    }

    @Override
    public boolean isUseNegativeWeights() {
        return this.useNegativeWeights;
    }

    @Override
    public void setUseNegativeWeights(boolean use) {
        this.useNegativeWeights = use;
    }

    @Override
    public void clear() {
        this.init();
    }

    @Override
    public void setAggressiveMode(boolean mode) {
        this.aggressiveMode = mode;
    }

    @Override
    public boolean getAggressiveMode() {
        return this.aggressiveMode;
    }

    @Override
    public void setRandomSeed(long seed) {
        this.randomSeed = seed;
        this.rand.setSeed(seed);
    }

    @Override
    public long getRandomSeed() {
        return this.randomSeed;
    }

    @Override
    public double getCancelErrorThreshold() {
        return this.errorAreaThreshold;
    }

    private class NodeIterator
    implements Iterator<VoroNode> {
        Stack<VoroNode> stack = new Stack();

        public NodeIterator(VoroNode root) {
            this.stack.addAll(root.getChildren());
        }

        @Override
        public boolean hasNext() {
            return this.stack.size() > 0;
        }

        @Override
        public VoroNode next() {
            VoroNode t = this.stack.pop();
            if (t != null && t.getChildren() != null && t.getChildren().size() > 0) {
                this.stack.addAll(t.getChildren());
            }
            return t;
        }

        @Override
        public void remove() {
        }
    }
}

