/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.originalfastvoronoi.convexHull;

import com.treemap.swing.originalfastvoronoi.convexHull.JVertex;

public class JVector {
    public double x;
    public double y;
    public double z;

    public JVector() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public JVector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public JVector(JVector a) {
        this.x = a.x;
        this.y = a.y;
        this.z = a.z;
    }

    public JVector subtract(JVector b) {
        return new JVector(this.x - b.x, this.y - b.y, this.z - b.z);
    }

    public JVector cross(JVector b) {
        return new JVector(this.y * b.z - this.z * b.y, this.z * b.x - this.x * b.z, this.x * b.y - this.y * b.x);
    }

    public double dot(JVector b) {
        return this.x * b.x + this.y * b.y + this.z * b.z;
    }

    public double dot(JVertex b) {
        return this.x * b.x + this.y * b.y + this.z * b.z;
    }

    public void normalize() {
        double len = this.length();
        if (len > 0.0) {
            this.x /= len;
            this.y /= len;
            this.z /= len;
        }
    }

    public void negate() {
        this.x *= -1.0;
        this.y *= -1.0;
        this.z *= -1.0;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public String toString() {
        return "JVector{x=" + this.x + ", y=" + this.y + ", z=" + this.z + "}";
    }
}

