/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.originalfastvoronoi.pd.gui;

import com.macrofocus.geom.Rectangle;
import com.treemap.swing.originalfastvoronoi.VoroCellObject;
import com.treemap.swing.originalfastvoronoi.j2d.Point2D;
import com.treemap.swing.originalfastvoronoi.j2d.PolygonSimple;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

public class JPolygon
extends JComponent
implements VoroCellObject {
    String text;
    private Font textFont;
    PolygonSimple polygon;
    private boolean mouseIn = false;
    private boolean isFinal;
    private Integer id;
    private boolean isLast = false;
    private Color fillColor = new Color(255, 255, 255, 0);
    private int height = 0;
    private boolean makeFontSmaller = false;

    public JPolygon(Integer id, String title) {
        this(id);
        this.text = title;
    }

    public JPolygon(Integer id) {
        this.id = id;
        this.polygon = null;
        this.setOpaque(false);
    }

    public JPolygon(PolygonSimple polygon, Integer id) {
        this(id);
        this.setPolygon(polygon);
    }

    public void calculateFittingFont() {
        if (this.polygon == null || this.text == null) {
            return;
        }
        this.textFont = null;
        new Thread(){

            @Override
            public void run() {
                Point2D centroid;
                Font font = new Font("Serif", 1, 5);
                int fontSize = 5;
                int w = 0;
                int h = 0;
                Point2D p1 = centroid = JPolygon.this.polygon.getCentroid();
                Point2D p2 = centroid;
                Point2D p3 = centroid;
                Point2D p4 = centroid;
                do {
                    font = new Font("Serif", 0, fontSize += 2);
                    FontMetrics fontMetrics = JPolygon.this.getFontMetrics(font);
                    w = fontMetrics.stringWidth(JPolygon.this.text);
                    h = fontMetrics.getHeight();
                    p1 = new Point2D(centroid.getX() - (double)(w / 2), centroid.getY() - (double)(h / 2));
                    p2 = new Point2D(centroid.getX() - (double)(w / 2), centroid.getY() + (double)(h / 2));
                    p3 = new Point2D(centroid.getX() + (double)(w / 2), centroid.getY() - (double)(h / 2));
                    p4 = new Point2D(centroid.getX() + (double)(w / 2), centroid.getY() + (double)(h / 2));
                } while (JPolygon.this.polygon.contains(p1) && JPolygon.this.polygon.contains(p2) && JPolygon.this.polygon.contains(p3) && JPolygon.this.polygon.contains(p4));
                if (fontSize - 4 > 0) {
                    JPolygon.this.textFont = JPolygon.this.makeFontSmaller ? new Font("Serif", 1, (int)((double)fontSize * 0.6)) : (JPolygon.this.text.length() <= 4 && JPolygon.this.height == 3 ? new Font("Serif", 1, (int)((double)fontSize * 0.6)) : new Font("Serif", 1, fontSize - 4));
                }
            }
        }.start();
    }

    public PolygonSimple getPolygon() {
        return this.polygon;
    }

    private void initListeners() {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                JPolygon.this.doMouseReleased(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JPolygon.this.doMousePressed(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JPolygon.this.doMouseExited(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JPolygon.this.doMouseEntered(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                JPolygon.this.doMouseClicked(e);
            }
        });
    }

    protected void doMousePressed(MouseEvent e) {
        System.out.println(e);
    }

    protected void doMouseReleased(MouseEvent e) {
    }

    protected void doMouseClicked(MouseEvent e) {
    }

    protected void doMouseEntered(MouseEvent e) {
        System.out.println(e);
        this.mouseIn = true;
        this.repaint();
    }

    protected void doMouseExited(MouseEvent e) {
        this.mouseIn = false;
        this.repaint();
    }

    public void setPolygon(PolygonSimple p) {
        this.polygon = p;
        if (this.polygon != null) {
            Rectangle bounds = p.getBounds();
            this.setLocation(bounds.x, bounds.y);
            this.setSize(bounds.width, bounds.height);
            this.setPreferredSize(new Dimension(bounds.width, bounds.height));
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
    }

    @Override
    public boolean contains(int x, int y) {
        if (super.contains(x, y)) {
            if (this.polygon == null) {
                return true;
            }
            return this.polygon.contains(x + this.getLocation().x, y + this.getLocation().y);
        }
        return false;
    }

    @Override
    public boolean contains(Point p) {
        if (super.contains(p)) {
            if (this.polygon == null) {
                return true;
            }
            return this.polygon.contains(p.x + this.getLocation().x, p.y + this.getLocation().y);
        }
        return false;
    }

    public static void main(String[] args) {
    }

    @Override
    public void doFinalWork() {
        this.calculateFittingFont();
        this.isFinal = true;
    }

    public void setVoroPolygon(PolygonSimple p, int height) {
        p = p.clone();
        this.height = height;
        this.isFinal = false;
        Rectangle bounds = p.getBounds();
        this.polygon = p;
        this.setLocation(bounds.x, bounds.y);
        this.setSize(bounds.width, bounds.height);
        this.setPreferredSize(new Dimension(bounds.width, bounds.height));
    }

    public void setIsLast(boolean isLast) {
        this.isLast = isLast;
    }

    public boolean getisLast() {
        return this.isLast;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setMakeFontSmaller(boolean b) {
        this.makeFontSmaller = b;
    }

    @Override
    public void setVoroPolygon(PolygonSimple polygon) {
        this.polygon = polygon;
    }
}

