/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.treeplot;

import com.macrofocus.geom.Point;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.RoundRectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.swing.SwingColor;
import com.treemap.TreeMapPopup;
import com.treemap.TreeMapToolTip;
import com.treemap.crossplatform.TGraphics;
import com.treemap.swing.JideTreeMapPopup;
import com.treemap.swing.SwingTreeMapPopup;
import com.treemap.swing.crossplatform.SwingTGraphics;
import com.treemap.swing.treeplot.SwingTreePlotView;
import com.treemap.treeplot.ToolTipTreePlotRenderer;
import com.treemap.treeplot.TreePlotModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;

public class SwingTreePlotToolTip<N, Row, Column>
extends JComponent
implements TreeMapToolTip<N, Row, Column, Color, Font> {
    private static final int topShift = 7;
    private static final int leftShift = 30;
    private ToolTipTreePlotRenderer<N, Row, Column, Color, Font> renderer = new ToolTipTreePlotRenderer();
    private SwingTreePlotView<N, Row, Column> view;
    private N node;
    private LineBorder border;
    private java.awt.Point mousePosition;
    private TreeMapToolTip.ToolTipType type = TreeMapToolTip.ToolTipType.Painted;
    private TreeMapPopup popup;
    private boolean redispatchMouseEvent = false;
    private transient MouseRedispatcher redispatcher = new MouseRedispatcher();
    private int preferredWidth = 230;

    public SwingTreePlotToolTip(SwingTreePlotView<N, Row, Column> view) {
        this.view = view;
        this.setOpaque(true);
        this.setRedispatchMouseEvent(true);
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    public void setSize(com.macrofocus.common.geom.Dimension d) {
        this.setSize(new Dimension(d.width, d.height));
    }

    public void setRedispatchMouseEvent(boolean redispatchMouseEvent) {
        if (this.redispatchMouseEvent != redispatchMouseEvent) {
            this.redispatchMouseEvent = redispatchMouseEvent;
            if (redispatchMouseEvent) {
                this.addMouseListener(this.redispatcher);
                this.addMouseMotionListener(this.redispatcher);
                this.addMouseWheelListener(this.redispatcher);
            } else {
                this.removeMouseListener(this.redispatcher);
                this.removeMouseMotionListener(this.redispatcher);
                this.removeMouseWheelListener(this.redispatcher);
            }
        }
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        SwingTGraphics g2 = new SwingTGraphics((Graphics2D)g);
        this.paintBackground((TGraphics<Color, Font>)g2);
        super.paintComponent(g);
        this.paintText((TGraphics<Color, Font>)g2);
    }

    public void paintText(TGraphics<Color, Font> g) {
        Insets insets = this.getInsets();
        int x = insets.left;
        int y = insets.top;
        int width = this.getWidth() - insets.left - insets.right;
        int height = this.getHeight() - insets.top - insets.bottom;
        g.save();
        g.translate(x, y);
        g.clip((Shape)new Rectangle2D.Double(0.0, 0.0, (double)width, (double)height));
        g.setAntialias(true);
        this.getRenderer().paint(g, this.view, this.node, this.getPreferredWidth(), 30, 7, null);
        g.restore();
    }

    public void paintBackground(TGraphics<Color, Font> g) {
        Object background;
        if (this.isOpaque() && (background = this.getBackground() == null || this.getBackground() instanceof UIResource ? this.view.getModel().getSettings().getTooltipBackground() : new SwingColor(this.getBackground())) != null) {
            Insets insets = this.getInsets();
            int x = insets.left;
            int y = insets.top;
            int width = this.getWidth() - insets.left - insets.right;
            int height = this.getHeight() - insets.top - insets.bottom;
            Color endColor = new Color(background.getRed(), background.getGreen(), background.getBlue(), Math.max(0, background.getAlpha() - 50));
            g.setPaint((Paint)new GradientPaint(x, y, (Color)background.getNativeColor(), 0.0f, height, endColor));
            g.fill((Shape)new RoundRectangle2D.Double((double)x, (double)y, (double)width, (double)height, 10.0, 10.0));
            CPColor<Color> borderColor = this.getBorderColor();
            if (borderColor != null) {
                g.setStroke(borderColor);
                float borderThickness = insets.left;
                g.setLineWidth((double)borderThickness);
                g.strokeRoundRect((double)(borderThickness / 2.0f), (double)(borderThickness / 2.0f), (double)((float)this.getWidth() - borderThickness), (double)((float)this.getHeight() - borderThickness), 10.0, 10.0);
            }
        }
    }

    protected CPColor<Color> getBorderColor() {
        CPColor probingColor = this.view.getModel().getSettings().getProbingColor();
        if (probingColor != null) {
            return new SwingColor(probingColor.getRed(), probingColor.getGreen(), probingColor.getBlue(), 127);
        }
        return null;
    }

    @Override
    public Border getBorder() {
        CPColor borderColor;
        Border superBorder = super.getBorder();
        if ((superBorder == null || superBorder instanceof BorderUIResource || superBorder.getClass().getName().equals("javax.swing.plaf.synth.SynthBorder")) && (borderColor = this.view.getModel().getSettings().getDefaultFieldSettings().getBorderColor()) != null) {
            if (this.border == null || this.border.getLineColor() != borderColor) {
                this.border = new LineBorder((Color)borderColor.getNativeColor(), 1);
            }
            return this.border;
        }
        return superBorder;
    }

    @Override
    public Insets getInsets() {
        return new Insets(2, 2, 2, 2);
    }

    protected SwingTreePlotView<N, Row, Column> getView() {
        return this.view;
    }

    public ToolTipTreePlotRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(ToolTipTreePlotRenderer renderer) {
        this.renderer = renderer;
    }

    public N getNode() {
        return this.node;
    }

    public synchronized void setNode(N node) {
        if (this.node != node) {
            this.node = node;
        }
    }

    public synchronized void showNode(N node) {
        Object v0 = (node = node == null || this.view.getRenderedShape(node) == null ? null : node);
        if (this.node != node) {
            this.setNode(node);
            if (node != null) {
                SwingTreePlotView<N, Row, Column> view = this.getView();
                try {
                    this.mousePosition = view.getNativeComponent().getMousePosition();
                }
                catch (ClassCastException e) {
                    this.mousePosition = null;
                }
                catch (HeadlessException e) {
                    this.mousePosition = null;
                }
                catch (RuntimeException e) {
                    this.mousePosition = null;
                }
                Point tooltipPosition = this.getPreferredLocation();
                com.macrofocus.common.geom.Dimension tooltipDimension = this.getPreferredSize(null);
                if (tooltipPosition != null && tooltipDimension != null && view.getNativeComponent().isShowing()) {
                    java.awt.Point p = view.getNativeComponent().getLocationOnScreen();
                    TreeMapPopup popup = this.getPopup();
                    if (popup != null) {
                        this.showPopup(p.x + tooltipPosition.x, p.y + tooltipPosition.y);
                    }
                }
            } else {
                this.hidePopup();
            }
            if (this.popup != null) {
                this.popup.repaint();
            }
        }
    }

    public Point getPopupLocation() {
        if (this.popup != null) {
            return this.popup.getAnchor();
        }
        return null;
    }

    public Point getPreferredLocation() {
        return this.getPreferredLocation(this.mousePosition != null ? new Point(this.mousePosition.x, this.mousePosition.y) : null);
    }

    public Point getPreferredLocation(Point p) {
        TreePlotModel model = this.view.getModel();
        if (model != null && this.node != null) {
            com.macrofocus.common.geom.Dimension size;
            Shape shape = null;
            if (p == null) {
                shape = this.view.getRenderedShape(this.node);
                if (shape != null) {
                    p = new Point((int)shape.getBounds2D().getCenterX(), (int)shape.getBounds2D().getCenterY());
                } else {
                    return null;
                }
            }
            int mouseX = p.x;
            int mouseY = p.y;
            if (p != null && (size = this.getPreferredSize(null)) != null) {
                int width = size.width;
                int height = size.height;
                Rectangle bounds = new Rectangle(mouseX + 30, mouseY + 7, width, height);
                if (mouseX > this.view.getWidth() - 30 - width) {
                    bounds.x = mouseX - (60 + width);
                }
                if (mouseY > this.view.getHeight() - height - 7) {
                    bounds.y = this.view.getHeight() - height - 7;
                }
                return new Point(bounds.x, bounds.y);
            }
        }
        return null;
    }

    public com.macrofocus.common.geom.Dimension getPreferredSize(TGraphics<Color, Font> g) {
        TreePlotModel model = this.view.getModel();
        if (model != null && this.node != null) {
            Rectangle bounds = this.getRenderer().drawToolTip(g, this.view, model, this.node, this.getPreferredWidth(), 30, 7, false);
            if (bounds != null) {
                Insets insets = this.getInsets();
                return new com.macrofocus.common.geom.Dimension(bounds.width + 1 + insets.left + insets.right, bounds.height + 1 + insets.top + insets.bottom);
            }
            return null;
        }
        return null;
    }

    public TreeMapToolTip.ToolTipType getType() {
        return this.type;
    }

    public void setType(TreeMapToolTip.ToolTipType type) {
        if (this.type != type) {
            this.type = type;
            this.popup = null;
        }
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setPreferredWidth(int width) {
        this.preferredWidth = width;
    }

    public TreeMapPopup getPopup() {
        if (this.popup == null) {
            this.popup = this.createPopup();
        }
        return this.popup;
    }

    protected void showPopup(int x, int y) {
        TreeMapPopup popup = this.getPopup();
        if (popup != null) {
            popup.showPopup(x, y, (Object)this.getView().getNativeComponent());
        }
    }

    protected void hidePopup() {
        TreeMapPopup popup = this.getPopup();
        if (popup != null) {
            popup.hidePopup();
        }
    }

    protected TreeMapPopup createPopup() {
        switch (this.type) {
            case Heavyweight: {
                JideTreeMapPopup popup = new JideTreeMapPopup();
                popup.putClientProperty("windowOpaque", Boolean.FALSE);
                popup.setPopupType(2);
                popup.setOpaque(false);
                popup.setFocusable(false);
                popup.setTransient(false);
                popup.setKeepPreviousSize(false);
                popup.setDefaultMoveOperation(1);
                popup.setPopupBorder(BorderFactory.createEmptyBorder());
                popup.getContentPane().setLayout(new BorderLayout());
                popup.getContentPane().add(this);
                return popup;
            }
            case Lightweight: {
                JideTreeMapPopup popup = new JideTreeMapPopup();
                popup.putClientProperty("windowOpaque", Boolean.FALSE);
                popup.setPopupType(0);
                popup.setOpaque(false);
                popup.setFocusable(false);
                popup.setKeepPreviousSize(false);
                popup.setDefaultMoveOperation(-1);
                popup.setPopupBorder(BorderFactory.createEmptyBorder());
                popup.getContentPane().setLayout(new BorderLayout());
                popup.getContentPane().add(this);
                return popup;
            }
            case Painted: {
                SwingTreeMapPopup popup = new SwingTreeMapPopup();
                return popup;
            }
        }
        throw new IllegalArgumentException();
    }

    public Component getNativeComponent() {
        return this;
    }

    protected class MouseRedispatcher
    implements MouseListener,
    MouseWheelListener,
    MouseMotionListener {
        protected MouseRedispatcher() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.dispatchMouseEvent(e);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this.dispatchMouseEvent(e);
        }

        private void dispatchMouseEvent(MouseEvent evt) {
            SwingTreePlotToolTip.this.getView().getNativeComponent().dispatchEvent(SwingUtilities.convertMouseEvent(evt.getComponent(), evt, SwingTreePlotToolTip.this.getView().getNativeComponent()));
        }
    }
}

