/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.treeplot;

import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.swing.SwingCanvasHandler;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.helper.ColorHelper;
import com.macrofocus.helper.LookAndFeelHelper;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.plot.guide.Guide;
import com.macrofocus.plot.guide.SwingXNumberOneDScreenTransformAxisGuide;
import com.macrofocus.plot.guide.SwingYNumberOneDScreenTransformAxisGuide;
import com.macrofocus.transform.OneDScreenTransform;
import com.treemap.CushionRendering;
import com.treemap.crossplatform.Headless;
import com.treemap.swing.crossplatform.SwingHeadless;
import com.treemap.swing.plaf.TreePlotUI;
import com.treemap.swing.plaf.basic.BasicTreePlotUI;
import com.treemap.swing.plaf.synth.SynthTreePlotUI;
import com.treemap.swing.treeplot.DrillDownAction;
import com.treemap.swing.treeplot.DrillUpAction;
import com.treemap.swing.treeplot.SwingTreePlotToolTip;
import com.treemap.treeplot.AbstractTreePlotView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class SwingTreePlotView<N, Row, Column>
extends AbstractTreePlotView<JComponent, N, Row, Column, Color, Font> {
    final Color backgroundColor = new Color(220, 220, 220);
    private RenderingHints _renderingHints;
    private NativeComponent nativeComponent = new NativeComponent();
    private final SwingCanvasHandler handler = new SwingCanvasHandler((JComponent)this.nativeComponent);

    public SwingTreePlotView() {
        super((Headless)new SwingHeadless());
        this.nativeComponent.setBackground(this.backgroundColor);
        this.nativeComponent.setOpaque(true);
        this.xGuide = new SwingXNumberOneDScreenTransformAxisGuide((OneDScreenTransform)this.getXCoordinateAxis());
        this.yGuide = new SwingYNumberOneDScreenTransformAxisGuide(Guide.Type.Left, (OneDScreenTransform)this.getYCoordinateAxis());
        this.nativeComponent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension d = SwingTreePlotView.this.nativeComponent.getSize();
                SwingTreePlotView.this.screenTransform.setScreenSize(d.width, d.height);
            }
        });
        this.probingToolTip = new SwingTreePlotToolTip(this);
        this.selectionToolTip = null;
        this.nativeComponent.getActionMap().put("drillDown", new DrillDownAction(this));
        this.nativeComponent.getActionMap().put("drillUp", new DrillUpAction(this));
        this._renderingHints = new RenderingHints(new HashMap());
        this._renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this._renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public Paint getPaint(N node, Shape shape, Rectangle bounds, boolean allowGradientPaint) {
        Color color = (Color)this.model.getColor(node).getNativeColor();
        if (color != null) {
            if (bounds.width > 6 && allowGradientPaint && this.model.getSettings().getRendering() instanceof CushionRendering && color instanceof Color) {
                try {
                    Color innerColor = ColorHelper.brighter((Color)color, (double)0.8);
                    innerColor = ColorHelper.desaturateColor((Color)innerColor);
                    Color outerColor = color;
                    Rectangle2D b2d = shape.getBounds2D();
                    RadialGradientPaint p = new RadialGradientPaint(new Point2D.Double(b2d.getCenterX(), b2d.getCenterY()), (float)bounds.width / 2.0f, new float[]{0.0f, 1.0f}, new Color[]{innerColor, outerColor}, MultipleGradientPaint.CycleMethod.NO_CYCLE);
                    return p;
                }
                catch (NoClassDefFoundError e) {
                    return color;
                }
                catch (SecurityException e) {
                    return color;
                }
            }
            return color;
        }
        return null;
    }

    public int getWidth() {
        return this.nativeComponent.getWidth();
    }

    public int getHeight() {
        return this.nativeComponent.getHeight();
    }

    public RenderingHints getRenderingHints() {
        return this._renderingHints;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        this._renderingHints = renderingHints;
        this.nativeComponent.repaint();
    }

    protected void repaint(long delay) {
        this.nativeComponent.repaint(delay);
    }

    protected void setBackground(CPColor<Color> background) {
        this.nativeComponent.setBackground((Color)background.getNativeColor());
    }

    public com.macrofocus.common.geom.Dimension getSize() {
        return new com.macrofocus.common.geom.Dimension(this.nativeComponent.getWidth(), this.nativeComponent.getHeight());
    }

    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }

    public void addMouseListener(CPCanvas.MouseListener l) {
        this.handler.addMouseListener(l);
    }

    public void addMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.handler.addMouseMotionListener(l);
    }

    public void addMouseWheelListener(CPCanvas.MouseWheelListener l) {
        this.handler.addMouseWheelListener(l);
    }

    public void addKeyListener(CPCanvas.KeyListener l) {
        this.handler.addKeyListener(l);
    }

    public void addContextMenuListener(CPCanvas.ContextMenuListener l) {
        this.handler.addContextMenuListener(l);
    }

    public final class NativeComponent
    extends JComponent {
        public static final String uiClassID = "TreePlotUI";

        public SwingTreePlotView<N, Row, Column> getTreeMapView() {
            return SwingTreePlotView.this;
        }

        public void setUI(TreePlotUI ui) {
            super.setUI(ui);
        }

        public NativeComponent() {
            this.updateUI();
        }

        @Override
        public void updateUI() {
            if (UIManager.get(this.getUIClassID()) != null) {
                this.setUI((TreePlotUI)UIManager.getUI(this));
            } else if (LookAndFeelHelper.isSynth()) {
                this.setUI(new SynthTreePlotUI());
            } else {
                this.setUI(new BasicTreePlotUI());
            }
        }

        @Override
        public TreePlotUI getUI() {
            return (TreePlotUI)this.ui;
        }

        @Override
        public String getUIClassID() {
            return uiClassID;
        }

        @Override
        public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

