/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.voronoi.smoothing;

import com.treemap.swing.voronoi.Point2d;
import com.treemap.swing.voronoi.smoothing.AbstractSmoothedSegment;
import com.treemap.swing.voronoi.smoothing.CurveLocation;
import com.treemap.swing.voronoi.smoothing.LineSegment;
import com.treemap.swing.voronoi.smoothing.SegmentDirection;
import com.treemap.swing.voronoi.smoothing.SegmentLocation;
import com.treemap.swing.voronoi.smoothing.SingleSpline;
import com.treemap.swing.voronoi.smoothing.SmoothedSegment;
import com.treemap.swing.voronoi.smoothing.Smoother;
import com.treemap.swing.voronoi.smoothing.Vertex;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Map;

public class DoubleSpline
extends AbstractSmoothedSegment {
    private final CubicCurve2D.Double startCurve = new CubicCurve2D.Double();
    private final CubicCurve2D.Double endCurve = new CubicCurve2D.Double();
    private Map<Double, Point2d> samplesCurve1;
    private Map<Double, Point2d> samplesCurve2;
    private Point2d connectingPoint;

    public DoubleSpline(LineSegment lineSegment, SegmentDirection direction) {
        super(lineSegment, direction);
        Point2d[] controlPoints1 = new Point2d[2];
        Point2d[] controlPoints2 = new Point2d[2];
        List<Point2d> points = lineSegment.getPoints();
        this.connectingPoint = points.get(points.size() / 2);
        Point2d startPoint = this.getStartVertex().getLocation();
        Point2d endPoint = this.getEndVertex().getLocation();
        this.getCurveControlPoints(new Point2d[]{startPoint, this.connectingPoint, endPoint}, controlPoints1, controlPoints2);
        this.startCurve.setCurve(startPoint.x, startPoint.y, controlPoints1[0].x, controlPoints1[0].y, controlPoints2[0].x, controlPoints2[0].y, this.connectingPoint.x, this.connectingPoint.y);
        this.endCurve.setCurve(this.connectingPoint.x, this.connectingPoint.y, controlPoints1[1].x, controlPoints1[1].y, controlPoints2[1].x, controlPoints2[1].y, endPoint.x, endPoint.y);
    }

    public DoubleSpline(CubicCurve2D startToConnectingPoint, CubicCurve2D connectingPointToEnd, Vertex startVertex, Vertex endVertex, LineSegment lineSegment) {
        super(startVertex, endVertex, lineSegment);
        this.startCurve.setCurve(startToConnectingPoint);
        this.endCurve.setCurve(connectingPointToEnd);
        Point2D p2 = this.startCurve.getP2();
        this.connectingPoint = new Point2d(p2.getX(), p2.getY());
    }

    public Point2d getConnectingPoint() {
        return this.connectingPoint;
    }

    private void calculateControlPoints(LineSegment lineSegment) {
    }

    public CubicCurve2D getStartCurve() {
        return this.startCurve;
    }

    private CubicCurve2D getEndCurve() {
        return this.endCurve;
    }

    private Map<Double, Point2d> getSamplesCurve1(CubicCurve2D curve1) {
        if (this.samplesCurve1 == null) {
            this.samplesCurve1 = Smoother.createSamples(curve1);
        }
        return this.samplesCurve1;
    }

    private Map<Double, Point2d> getSamplesCurve2(CubicCurve2D curve2) {
        if (this.samplesCurve2 == null) {
            this.samplesCurve2 = Smoother.createSamples(curve2);
        }
        return this.samplesCurve2;
    }

    @Override
    public SegmentLocation getNearestSegmentLocation(Vertex vertex) {
        Point2d cornerLocation = vertex.getLocation();
        CubicCurve2D curve1 = this.getStartCurve();
        CubicCurve2D curve2 = this.getEndCurve();
        Map<Double, Point2d> samples1 = this.getSamplesCurve1(curve1);
        Map<Double, Point2d> samples2 = this.getSamplesCurve2(curve2);
        CurveLocation nearestCurveLocation1 = Smoother.getNearestCurveLocation(vertex, curve1, samples1, this);
        CurveLocation nearestCurveLocation2 = Smoother.getNearestCurveLocation(vertex, curve2, samples2, this);
        if (nearestCurveLocation1 == null) {
            return nearestCurveLocation2;
        }
        if (nearestCurveLocation2 == null) {
            return nearestCurveLocation1;
        }
        return nearestCurveLocation1.getMinSquaredDistance() < nearestCurveLocation2.getMinSquaredDistance() ? nearestCurveLocation1 : nearestCurveLocation2;
    }

    @Override
    public SmoothedSegment getSubSegment(SegmentLocation start, SegmentLocation end) {
        CubicCurve2D endCurve;
        boolean onSameCurve;
        CurveLocation startCurveLocation = (CurveLocation)start;
        CurveLocation endCurveLocation = (CurveLocation)end;
        CubicCurve2D startCurve = startCurveLocation.getCurve();
        boolean bl = onSameCurve = startCurve == (endCurve = endCurveLocation.getCurve());
        if (onSameCurve) {
            CurveLocation closerToP1 = DoubleSpline.getTheOneCloserToP1(startCurveLocation, endCurveLocation, startCurve);
            boolean reversed = closerToP1 != startCurveLocation;
            CurveLocation closerToP2 = reversed ? startCurveLocation : endCurveLocation;
            CubicCurve2D closerToP1toP2 = Smoother.getSubCruveToP2(closerToP1, startCurve);
            CubicCurve2D result = Smoother.getSubCruveFromP1(closerToP2, closerToP1toP2);
            if (reversed) {
                Smoother.reverse(result);
            }
            return new SingleSpline(result, start.getVertex(), end.getVertex(), this.getLineSegment());
        }
        CubicCurve2D startToConnectingPoint = this.getSubCruveToConnectingPoint(startCurveLocation);
        CubicCurve2D connectingPointToEnd = this.getSubCruveFromConnectingPoint(endCurveLocation);
        return new DoubleSpline(startToConnectingPoint, connectingPointToEnd, start.getVertex(), end.getVertex(), this.getLineSegment());
    }

    private CubicCurve2D getSubCruveToConnectingPoint(CurveLocation curveLocation) {
        CubicCurve2D curve = curveLocation.getCurve();
        if (this.isP2connectingPoint(curve)) {
            return Smoother.getSubCruveToP2(curveLocation, curve);
        }
        CubicCurve2D subCruveFromP1 = Smoother.getSubCruveFromP1(curveLocation, curve);
        Smoother.reverse(subCruveFromP1);
        return subCruveFromP1;
    }

    public CubicCurve2D getSubCruveFromConnectingPoint(CurveLocation curveLocation) {
        CubicCurve2D curve = curveLocation.getCurve();
        if (this.isP1connectingPoint(curve)) {
            return Smoother.getSubCruveFromP1(curveLocation, curve);
        }
        CubicCurve2D subCruveToP2 = Smoother.getSubCruveToP2(curveLocation, curve);
        Smoother.reverse(subCruveToP2);
        return subCruveToP2;
    }

    private boolean isP1connectingPoint(CubicCurve2D curve) {
        return this.connectingPoint.x == curve.getX1() && this.connectingPoint.y == curve.getY1();
    }

    private boolean isP2connectingPoint(CubicCurve2D curve) {
        return this.connectingPoint.x == curve.getX2() && this.connectingPoint.y == curve.getY2();
    }

    private static CurveLocation getTheOneCloserToP1(CurveLocation l1, CurveLocation l2, CubicCurve2D curve) {
        Point2d location1 = l1.getNearestSample().getValue();
        Point2d location2 = l2.getNearestSample().getValue();
        Point2D p1 = curve.getP1();
        if (p1.distanceSq(location1.x, location1.y) < p1.distanceSq(location2.x, location2.y)) {
            return l1;
        }
        return l2;
    }

    private static SegmentLocation getTheOneCloserToP2(CurveLocation l1, CurveLocation l2, CubicCurve2D curve) {
        Point2d location1 = l1.getNearestSample().getValue();
        Point2d location2 = l2.getNearestSample().getValue();
        Point2D p2 = curve.getP2();
        if (p2.distanceSq(location1.x, location1.y) < p2.distanceSq(location2.x, location2.y)) {
            return l1;
        }
        return l2;
    }

    public void addCurveToGeneralPath(GeneralPath generalPath, SegmentDirection direction) {
    }

    public void getCurveControlPoints(Point2d[] knots, Point2d[] firstControlPoints, Point2d[] secondControlPoints) {
        if (knots == null) {
            return;
        }
        int n = knots.length - 1;
        double[] rhs = new double[n];
        for (int i = 1; i < n - 1; ++i) {
            rhs[i] = 4.0 * knots[i].x + 2.0 * knots[i + 1].x;
        }
        rhs[0] = knots[0].x + 2.0 * knots[1].x;
        rhs[n - 1] = (8.0 * knots[n - 1].x + knots[n].x) / 2.0;
        double[] x = this.getFirstControlPoints(rhs);
        for (int i = 1; i < n - 1; ++i) {
            rhs[i] = 4.0 * knots[i].y + 2.0 * knots[i + 1].y;
        }
        rhs[0] = knots[0].y + 2.0 * knots[1].y;
        rhs[n - 1] = (8.0 * knots[n - 1].y + knots[n].y) / 2.0;
        double[] y = this.getFirstControlPoints(rhs);
        for (int i = 0; i < n; ++i) {
            firstControlPoints[i] = new Point2d(x[i], y[i]);
            secondControlPoints[i] = i < n - 1 ? new Point2d(2.0 * knots[i + 1].x - x[i + 1], 2.0 * knots[i + 1].y - y[i + 1]) : new Point2d((knots[n].x + x[n - 1]) / 2.0, (knots[n].y + y[n - 1]) / 2.0);
        }
    }

    private double[] getFirstControlPoints(double[] rhs) {
        int i;
        int n = rhs.length;
        double[] x = new double[n];
        double[] tmp = new double[n];
        double b = 2.0;
        x[0] = rhs[0] / b;
        for (i = 1; i < n; ++i) {
            tmp[i] = 1.0 / b;
            b = (i < n - 1 ? 4.0 : 3.5) - tmp[i];
            x[i] = (rhs[i] - x[i - 1]) / b;
        }
        for (i = 1; i < n; ++i) {
            int n2 = n - i - 1;
            x[n2] = x[n2] - tmp[n - i] * x[n - i];
        }
        return x;
    }

    @Override
    public void addToGeneralPath(GeneralPath generalPath) {
        Point2d startPoint = this.getStartVertex().getLocation();
        Point2d endPoint = this.getEndVertex().getLocation();
        if (generalPath.getCurrentPoint() == null) {
            generalPath.moveTo(startPoint.x, startPoint.y);
        }
        generalPath.append(this.startCurve, true);
        generalPath.append(this.endCurve, true);
    }

    @Override
    public SmoothedSegment reversed() {
        return null;
    }
}

