/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.ncdm.venn;

public class Eigen {
    private Eigen() {
    }

    public static void eigenSymmetric(double[][] a, double[][] eigenvectors, double[] eigenvalues) {
        double[] e = new double[eigenvalues.length];
        Eigen.tred2(a, eigenvectors, eigenvalues, e);
        Eigen.imtql2(eigenvectors, eigenvalues, e);
        Eigen.sort(eigenvalues, eigenvectors);
    }

    private static void tred2(double[][] a, double[][] z, double[] d, double[] e) {
        double g;
        int k;
        int l;
        int j;
        int i;
        int n = d.length;
        for (i = 0; i < n; ++i) {
            for (j = 0; j <= i; ++j) {
                z[i][j] = a[i][j];
            }
        }
        if (n > 1) {
            for (i = n - 1; i > 0; --i) {
                l = i - 1;
                double h = 0.0;
                double scale = 0.0;
                if (l > 0) {
                    for (k = 0; k <= l; ++k) {
                        scale += Math.abs(z[i][k]);
                    }
                }
                if (scale == 0.0) {
                    e[i] = z[i][l];
                } else {
                    for (k = 0; k <= l; ++k) {
                        double[] dArray = z[i];
                        int n2 = k;
                        dArray[n2] = dArray[n2] / scale;
                        h += z[i][k] * z[i][k];
                    }
                    double f = z[i][l];
                    g = f < 0.0 ? Math.sqrt(h) : -Math.sqrt(h);
                    e[i] = scale * g;
                    h -= f * g;
                    z[i][l] = f - g;
                    f = 0.0;
                    for (j = 0; j <= l; ++j) {
                        z[j][i] = z[i][j] / (scale * h);
                        g = 0.0;
                        for (k = 0; k <= j; ++k) {
                            g += z[j][k] * z[i][k];
                        }
                        int jp1 = j + 1;
                        if (l >= jp1) {
                            for (k = jp1; k <= l; ++k) {
                                g += z[k][j] * z[i][k];
                            }
                        }
                        e[j] = g / h;
                        f += e[j] * z[i][j];
                    }
                    double hh = f / (h + h);
                    for (j = 0; j <= l; ++j) {
                        f = z[i][j];
                        e[j] = g = e[j] - hh * f;
                        for (k = 0; k <= j; ++k) {
                            z[j][k] = z[j][k] - f * e[k] - g * z[i][k];
                        }
                    }
                    k = 0;
                    while (k <= l) {
                        double[] dArray = z[i];
                        int n3 = k++;
                        dArray[n3] = dArray[n3] * scale;
                    }
                }
                d[i] = h;
            }
        }
        d[0] = 0.0;
        e[0] = 0.0;
        for (i = 0; i < n; ++i) {
            l = i - 1;
            if (d[i] != 0.0) {
                for (j = 0; j <= l; ++j) {
                    g = 0.0;
                    for (k = 0; k <= l; ++k) {
                        g += z[i][k] * z[k][j];
                    }
                    for (k = 0; k <= l; ++k) {
                        double[] dArray = z[k];
                        int n4 = j;
                        dArray[n4] = dArray[n4] - g * z[k][i];
                    }
                }
            }
            d[i] = z[i][i];
            z[i][i] = 1.0;
            if (l < 0) continue;
            for (j = 0; j <= l; ++j) {
                z[i][j] = 0.0;
                z[j][i] = 0.0;
            }
        }
    }

    private static int imtql2(double[][] z, double[] d, double[] e) {
        int i;
        double EPSILON = 1.0E-15;
        int n = d.length;
        if (n == 1) {
            return 0;
        }
        for (i = 1; i < n; ++i) {
            e[i - 1] = e[i];
        }
        e[n - 1] = 0.0;
        int mm = 0;
        block1: for (int l = 0; l < n; ++l) {
            int lp1 = l + 1;
            int j = 0;
            while (true) {
                int m;
                for (m = l; m < n; ++m) {
                    mm = m;
                    if (m == n - 1 || Math.abs(e[m]) <= EPSILON * (Math.abs(d[m]) + Math.abs(d[m + 1]))) break;
                }
                m = mm;
                double p = d[l];
                if (m == l) continue block1;
                if (j == 30) {
                    return l;
                }
                ++j;
                double g = (d[lp1] - p) / (2.0 * e[l]);
                double r = Math.sqrt(g * g + 1.0);
                g = d[m] - p + e[l] / (g + (g < 0.0 ? -r : r));
                double s = 1.0;
                double c = 1.0;
                p = 0.0;
                int mml = m - l;
                for (int ii = 1; ii <= mml; ++ii) {
                    i = m - ii;
                    int ip1 = i + 1;
                    double f = s * e[i];
                    double b = c * e[i];
                    if (Math.abs(f) >= Math.abs(g)) {
                        c = g / f;
                        r = Math.sqrt(c * c + 1.0);
                        e[ip1] = f * r;
                        s = 1.0 / r;
                        c *= s;
                    } else {
                        s = f / g;
                        r = Math.sqrt(s * s + 1.0);
                        e[ip1] = g * r;
                        c = 1.0 / r;
                        s *= c;
                    }
                    g = d[ip1] - p;
                    r = (d[i] - g) * s + 2.0 * c * b;
                    p = s * r;
                    d[ip1] = g + p;
                    g = c * r - b;
                    for (int k = 0; k < n; ++k) {
                        f = z[k][ip1];
                        z[k][ip1] = s * z[k][i] + c * f;
                        z[k][i] = c * z[k][i] - s * f;
                    }
                }
                int n2 = l;
                d[n2] = d[n2] - p;
                e[l] = g;
                e[m] = 0.0;
            }
        }
        return 0;
    }

    private static void sort(double[] d, double[][] z) {
        int n = d.length;
        int l = 1;
        while (l <= n) {
            l = 3 * l + 1;
        }
        while (l > 2) {
            int k = n - (l /= 3);
            for (int j = 0; j < k; ++j) {
                int ip1;
                for (int i = j; i >= 0 && (d[i] < d[ip1 = i + l] || Double.isNaN(d[i])); i -= l) {
                    double p = d[i];
                    d[i] = d[ip1];
                    d[ip1] = p;
                    for (int ii = 0; ii < n; ++ii) {
                        p = z[ii][i];
                        z[ii][i] = z[ii][ip1];
                        z[ii][ip1] = p;
                    }
                }
            }
        }
    }
}

