/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot;

import com.macrofocus.cartoplot.CartoPlotListener;
import com.macrofocus.cartoplot.CartoPlotModel;
import com.macrofocus.cartoplot.CartoPlotView;
import com.macrofocus.cartoplot.Geometry2Shape;
import com.macrofocus.common.interval.BoundedInterval;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.interval.SimpleBoundedInterval;
import com.macrofocus.common.properties.EnumProperties;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SimpleSingleSelection;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.AbstractIDrawing;
import com.macrofocus.igraphics.IDrawing;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.igraphics.colortheme.LightColorTheme;
import com.macrofocus.igraphics.pressure.LinearPressure;
import com.macrofocus.igraphics.pressure.Pressure;
import com.macrofocus.palette.FixedPalette;
import com.macrofocus.timer.CPTimer;
import com.macrofocus.timer.CPTimerListener;
import com.macrofocus.transform.RangesScreenTransformCoordinator;
import com.macrofocus.transform.ScreenTransformEvent;
import com.macrofocus.transform.ScreenTransformListener;
import com.macrofocus.transform.twod.MutableTwoDScreenTransform;
import com.macrofocus.transform.twod.SimpleTwoDScreenTransform;
import com.macrofocus.transform.twod.TwoDScreenTransform;
import com.macrofocus.visual.VisualLayer;
import com.macrofocus.visual.VisualListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

public abstract class AbstractCartoPlotView<Component, Color, Row, Column>
implements CartoPlotView<Component, Color, Row, Column> {
    private CartoPlotModel<Color, Row, Column> model;
    protected CPCanvas<Component> canvas;
    private CPFactory<?, ?, ?, Color> factory;
    protected final CPTimer timer;
    private double resolution = 0.0;
    private MutableSingleSelection<Rectangle2D> rubberBand = new SimpleSingleSelection();
    private boolean isSelectionMode = true;
    private RangesScreenTransformCoordinator rangesScreenTransformCoordinator = null;
    private static final float rubberbandStroke = 1.0f;
    protected final MutableProperties<CartoPlotView.PropertyType> properties = new EnumProperties(CartoPlotView.PropertyType.class);
    private static final boolean MULTITHREADED = false;
    private static final int nAvailableProcessors = Math.max(Runtime.getRuntime().availableProcessors(), 1);
    private static ExecutorService executor;
    protected final MutableBoundedInterval xRangeModel;
    protected final MutableBoundedInterval yRangeModel;
    protected final MutableTwoDScreenTransform screenTransform;
    private final CartoPlotListener listener = new CartoPlotListener(){

        @Override
        public void cartoPlotChanged() {
            AbstractCartoPlotView.this.resetXAxis();
            AbstractCartoPlotView.this.resetYAxis();
            AbstractCartoPlotView.this.scheduleUpdate();
        }
    };
    private final Geometry2Shape converter = new Geometry2Shape(new Geometry2Shape.PointConverter(){

        @Override
        public Point2D toViewPoint(Coordinate modelCoordinate) {
            double x = modelCoordinate.getX();
            double y = modelCoordinate.getY();
            y = AbstractCartoPlotView.lat2y(y);
            return new Point2D.Double((double)AbstractCartoPlotView.this.screenTransform.getX().worldToScreen(x), (double)AbstractCartoPlotView.this.screenTransform.getY().worldToScreen(y));
        }

        @Override
        public double getScale() {
            return (AbstractCartoPlotView.this.xRangeModel.getMaximum() - AbstractCartoPlotView.this.xRangeModel.getMinimum()) / AbstractCartoPlotView.this.xRangeModel.getExtent();
        }
    }, this.resolution);

    public AbstractCartoPlotView(CPFactory<Component, ?, ?, Color> factory) {
        this.canvas = factory.createCanvas();
        this.factory = factory;
        executor = factory.newFixedThreadPool(AbstractCartoPlotView.class.getSimpleName(), nAvailableProcessors / 2, nAvailableProcessors);
        this.properties.createProperty((Object)CartoPlotView.PropertyType.ShowFiltered, (Object)Boolean.TRUE);
        this.properties.createProperty((Object)CartoPlotView.PropertyType.Antialiasing, (Object)Boolean.TRUE);
        this.properties.createProperty((Object)CartoPlotView.PropertyType.Rendering, (Object)CPCanvas.Rendering.AlphaBlended);
        this.properties.createProperty((Object)CartoPlotView.PropertyType.DoubleBuffered, (Object)Boolean.TRUE);
        this.properties.createProperty((Object)CartoPlotView.PropertyType.ColorTheme, (Object)new LightColorTheme(factory));
        this.properties.createProperty((Object)CartoPlotView.PropertyType.DrawTileGrid, (Object)Boolean.FALSE);
        this.properties.createProperty((Object)CartoPlotView.PropertyType.TileEffect, (Object)CartoPlotView.TileEffect.None);
        this.properties.createProperty((Object)CartoPlotView.PropertyType.Wrap, (Object)Boolean.FALSE);
        this.xRangeModel = new SimpleBoundedInterval(-180.0, 360.0, -180.0, 180.0);
        double start = AbstractCartoPlotView.lat2y(-85.0511);
        double end = AbstractCartoPlotView.lat2y(85.0511);
        this.yRangeModel = new SimpleBoundedInterval(start, end - start, start, end);
        this.screenTransform = new SimpleTwoDScreenTransform((BoundedInterval)this.xRangeModel, (BoundedInterval)this.yRangeModel, 0, 0, this.xRangeModel.getExtent() / this.yRangeModel.getExtent());
        this.timer = factory.createTimer("CartoPlotResizer", 50, true, new CPTimerListener(){

            public void timerTriggered() {
                if (AbstractCartoPlotView.this.canvas.getWidth() > 0.0 && AbstractCartoPlotView.this.canvas.getHeight() > 0.0) {
                    AbstractCartoPlotView.this.canvas.refresh();
                }
            }
        });
        this.canvas.addCanvasListener(new CPCanvas.CanvasListener(){

            public void sizeChange(int width, int height) {
                AbstractCartoPlotView.this.screenTransform.setScreenSize(width, height);
            }
        });
        this.screenTransform.addScreenTransformListener(new ScreenTransformListener(){

            public void transformChanged(ScreenTransformEvent event) {
                AbstractCartoPlotView.this.timer.restart();
            }
        });
        this.setMaintainAspectRatio(true);
    }

    @Override
    public void setModel(CartoPlotModel model) {
        if (this.model != null) {
            this.model.removeCartoPlotListener(this.listener);
        }
        this.model = model;
        this.createOverplots();
        if (this.model != null) {
            this.model.addCartoPlotListener(this.listener);
        }
        this.resetXAxis();
        this.resetYAxis();
        this.timer.restart();
    }

    @Override
    public CartoPlotModel getModel() {
        return this.model;
    }

    @Override
    public MutableBoundedInterval getXRangeModel() {
        return this.xRangeModel;
    }

    @Override
    public MutableBoundedInterval getYRangeModel() {
        return this.yRangeModel;
    }

    @Override
    public TwoDScreenTransform getScreenTransform() {
        return this.screenTransform;
    }

    @Override
    public void setMaintainAspectRatio(boolean maintainAspectRatio) {
        if (maintainAspectRatio && this.rangesScreenTransformCoordinator == null) {
            this.rangesScreenTransformCoordinator = new RangesScreenTransformCoordinator(this.xRangeModel, this.yRangeModel);
        } else if (!maintainAspectRatio && this.rangesScreenTransformCoordinator != null) {
            this.rangesScreenTransformCoordinator.setRanges(null, null);
            this.rangesScreenTransformCoordinator = null;
        }
        this.screenTransform.setMaintainAspectRatio(maintainAspectRatio);
    }

    @Override
    public boolean isMaintainAspectRatio() {
        return this.rangesScreenTransformCoordinator != null;
    }

    @Override
    public void zoom(boolean animate, double x1, double x2, double y1, double y2) {
        this.getXRangeModel().setValue(x1, x2 - x1);
        this.getYRangeModel().setValue(y1, y2 - y1);
    }

    public void resetXAxis() {
        if (this.model.getXAxisModel() != null) {
            double min = this.model.getXAxisModel().getMinimum();
            double max = this.model.getXAxisModel().getMaximum();
            this.xRangeModel.setMinMax(min, max);
            this.xRangeModel.setValue(min, max - min);
        }
    }

    public void resetYAxis() {
        if (this.model.getYAxisModel() != null) {
            double min = AbstractCartoPlotView.lat2y(this.model.getYAxisModel().getMinimum());
            double max = AbstractCartoPlotView.lat2y(this.model.getYAxisModel().getMaximum());
            this.yRangeModel.setMinMax(min, max);
            this.yRangeModel.setValue(min, max - min);
            this.screenTransform.setWorldAspectRatio(this.xRangeModel.getExtent() / this.yRangeModel.getExtent());
        }
    }

    protected abstract void scheduleUpdate();

    protected abstract void repaint();

    @Override
    public Row getClosestRow(int x, int y) {
        Shape p;
        double bestdistance = Double.MAX_VALUE;
        Row bestrow = null;
        VisualLayer visible = this.getModel().getVisual().getActive();
        for (Object row : visible) {
            p = this.getShape(row);
            if (p == null || !p.contains((Point2D)new Point2D.Double((double)x, (double)y))) continue;
            bestdistance = 0.0;
            bestrow = (Row)row;
            break;
        }
        if (bestdistance > 0.0) {
            for (Object row : visible) {
                double distance;
                p = this.getPoint(row);
                if (p == null || !((distance = Point2D.distance((double)p.getX(), (double)p.getY(), (double)x, (double)y)) < bestdistance)) continue;
                bestdistance = distance;
                bestrow = (Row)row;
            }
        }
        return bestrow;
    }

    @Override
    public List<Row> getRows(Rectangle2D rect) {
        VisualLayer visible = this.getModel().getVisual().getActive();
        ArrayList list = new ArrayList();
        for (Object row : visible) {
            Shape p = this.getShape(row);
            if (p == null) continue;
            if (p instanceof Rectangle2D) {
                if (!this.intersects((Rectangle2D)p, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight())) continue;
                list.add(row);
                continue;
            }
            if (!p.intersects(rect)) continue;
            list.add(row);
        }
        return list;
    }

    private boolean intersects(Rectangle2D s, double x, double y, double w, double h) {
        if (w <= 0.0 || h <= 0.0) {
            return false;
        }
        double x0 = s.getX();
        double y0 = s.getY();
        return x + w > x0 && y + h > y0 && x < x0 + s.getWidth() && y < y0 + s.getHeight();
    }

    @Override
    public boolean isSelectionMode() {
        return this.isSelectionMode;
    }

    @Override
    public void setSelectionMode(boolean value) {
        this.isSelectionMode = value;
    }

    @Override
    public void startRubberBand(int x, int y) {
        double xWorld = this.screenTransform.getX().screenToWorld(x);
        double yWorld = this.screenTransform.getY().screenToWorld(y);
        this.rubberBand.setSelected((Object)new Rectangle2D.Double(xWorld, yWorld, 0.0, 0.0));
    }

    @Override
    public void stretchRubberBand(int x, int y) {
        if (this.rubberBand.isActive()) {
            double xWorld = this.screenTransform.getX().screenToWorld(x);
            double yWorld = this.screenTransform.getY().screenToWorld(y);
            Rectangle2D r = (Rectangle2D)this.rubberBand.getSelected();
            this.rubberBand.setSelected((Object)new Rectangle2D.Double(r.getX(), r.getY(), xWorld - r.getX(), yWorld - r.getY()));
        }
    }

    @Override
    public void stopRubberBand() {
        this.rubberBand.clearSelection();
    }

    @Override
    public SingleSelection<Rectangle2D> getRubberBand() {
        return this.rubberBand;
    }

    @Override
    public Rectangle2D getRubberBandScreen() {
        if (this.rubberBand.isActive()) {
            return this.worldToScreen((Rectangle2D)this.rubberBand.getSelected()).normalize();
        }
        return null;
    }

    public Rectangle worldToScreen(Rectangle2D r) {
        int x1 = (int)Math.round(this.screenTransform.getX().worldToScreenPrecise(r.getMinX()));
        int x2 = (int)Math.round(this.screenTransform.getX().worldToScreenPrecise(r.getMaxX()));
        int y1 = (int)Math.round(this.screenTransform.getY().worldToScreenPrecise(r.getMinY()));
        int y2 = (int)Math.round(this.screenTransform.getY().worldToScreenPrecise(r.getMaxY()));
        int minX = Math.min(x1, x2);
        int maxX = Math.max(x1, x2);
        int minY = Math.min(y1, y2);
        int maxY = Math.max(y1, y2);
        int width = maxX - minX;
        int height = maxY - minY;
        return new Rectangle(minX, minY, width, height);
    }

    @Override
    public MutableProperty<Boolean> getShowFiltered() {
        return this.properties.getProperty((Object)CartoPlotView.PropertyType.ShowFiltered);
    }

    @Override
    public MutableProperty<Boolean> getAntialiasing() {
        return this.properties.getProperty((Object)CartoPlotView.PropertyType.Antialiasing);
    }

    @Override
    public MutableProperty<CPCanvas.Rendering> getRendering() {
        return this.properties.getProperty((Object)CartoPlotView.PropertyType.Rendering);
    }

    @Override
    public MutableProperty<Boolean> getDoubleBuffered() {
        return this.properties.getProperty((Object)CartoPlotView.PropertyType.DoubleBuffered);
    }

    public MutableProperty<Boolean> getDrawTileGrid() {
        return this.properties.getProperty((Object)CartoPlotView.PropertyType.DrawTileGrid);
    }

    public MutableProperty<CartoPlotView.TileEffect> getTileEffect() {
        return this.properties.getProperty((Object)CartoPlotView.PropertyType.TileEffect);
    }

    public MutableProperty<Boolean> getWrap() {
        return this.properties.getProperty((Object)CartoPlotView.PropertyType.Wrap);
    }

    @Override
    public void setShowFiltered(MutableProperty<Boolean> showFiltered) {
        this.properties.replaceProperty((Object)CartoPlotView.PropertyType.ShowFiltered, showFiltered);
    }

    @Override
    public void setRendering(MutableProperty<CPCanvas.Rendering> rendering) {
        this.properties.replaceProperty((Object)CartoPlotView.PropertyType.Rendering, rendering);
    }

    @Override
    public void setAntialiasing(MutableProperty<Boolean> antialiasing) {
        this.properties.replaceProperty((Object)CartoPlotView.PropertyType.Antialiasing, antialiasing);
    }

    @Override
    public MutableProperty<ColorTheme<Color>> getColorTheme() {
        return this.properties.getProperty((Object)CartoPlotView.PropertyType.ColorTheme);
    }

    @Override
    public void setColorTheme(MutableProperty<ColorTheme<Color>> colorTheme) {
        this.properties.replaceProperty((Object)CartoPlotView.PropertyType.ColorTheme, colorTheme);
    }

    public static double y2lat(double aY) {
        return Math.toDegrees(2.0 * Math.atan(Math.exp(Math.toRadians(aY))) - 1.5707963267948966);
    }

    public static double lat2y(double aLat) {
        return Math.toDegrees(Math.log(Math.tan(0.7853981633974483 + Math.toRadians(aLat) / 2.0)));
    }

    protected Rectangle2D tile2boundingBox(int x, int y, int zoom) {
        double north = AbstractCartoPlotView.tile2lat(y, zoom);
        double south = AbstractCartoPlotView.tile2lat(y + 1, zoom);
        double west = AbstractCartoPlotView.tile2lon(x, zoom);
        double east = AbstractCartoPlotView.tile2lon(x + 1, zoom);
        north = AbstractCartoPlotView.lat2y(north);
        south = AbstractCartoPlotView.lat2y(south);
        Rectangle2D.Double bb = new Rectangle2D.Double(west, south, east - west, north - south);
        return bb;
    }

    static double tile2lon(int x, int z) {
        return (double)x / Math.pow(2.0, z) * 360.0 - 180.0;
    }

    static double tile2lat(int y, int z) {
        double n = Math.PI - Math.PI * 2 * (double)y / Math.pow(2.0, z);
        return Math.toDegrees(Math.atan(Math.sinh(n)));
    }

    protected static int getTileY(double lat, int zoom) {
        return (int)Math.floor((1.0 - Math.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0 * (double)(1 << zoom));
    }

    protected static int getTileX(double lon, int zoom) {
        return (int)Math.floor((lon + 180.0) / 360.0 * (double)(1 << zoom));
    }

    protected void createOverplots() {
        if (this.getModel() != null) {
            this.canvas.removeAllLayers();
            this.populateOverplots();
        }
    }

    protected void populateOverplots() {
        AbstractVisualLayerIDrawing filteredDrawing = new AbstractVisualLayerIDrawing(this.getModel().getVisual().getFiltered()){

            @Override
            public boolean isActive() {
                return (Boolean)AbstractCartoPlotView.this.getShowFiltered().getValue() != false && super.isActive();
            }

            @Override
            public void draw(IGraphics g, Row row, double width, double height) {
                if (AbstractCartoPlotView.this.getModel().isPointGeometry()) {
                    Point2D mp = AbstractCartoPlotView.this.getPoint(row);
                    if (mp != null) {
                        int radius = 2;
                        g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)(radius * 2), (double)(radius * 2)));
                    }
                } else {
                    Shape mp = AbstractCartoPlotView.this.getShape(row);
                    if (mp != null) {
                        g.fillShape(mp);
                    }
                }
            }
        };
        AbstractVisualLayerIDrawing visibleDrawing = new AbstractVisualLayerIDrawing(this.getModel().getVisual().getVisible()){

            @Override
            public void draw(IGraphics g, Row row, double width, double height) {
                if (AbstractCartoPlotView.this.getModel().isPointGeometry()) {
                    Point2D mp = AbstractCartoPlotView.this.getPoint(row);
                    if (mp != null) {
                        int radius = 4;
                        g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)(radius * 2), (double)(radius * 2)));
                    }
                } else {
                    Shape mp = AbstractCartoPlotView.this.getShape(row);
                    if (mp != null) {
                        g.fillShape(mp);
                    }
                }
            }
        };
        AbstractVisualLayerIDrawing colorMappedDrawing = new AbstractVisualLayerIDrawing(this.getModel().getVisual().getColorMapped()){

            @Override
            public void draw(IGraphics g, Row row, double width, double height) {
                if (AbstractCartoPlotView.this.getModel().isPointGeometry()) {
                    Point2D mp = AbstractCartoPlotView.this.getPoint(row);
                    if (mp != null) {
                        g.setColor(AbstractCartoPlotView.this.getModel().getColorMapping().getColor(row));
                        int radius = 4;
                        g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)(radius * 2), (double)(radius * 2)));
                    }
                } else {
                    Shape mp = AbstractCartoPlotView.this.getShape(row);
                    if (mp != null) {
                        g.setColor(AbstractCartoPlotView.this.getModel().getColorMapping().getColor(row));
                        g.fillShape(mp);
                    }
                }
            }
        };
        AbstractVisualLayerIDrawing coloredDrawing = new AbstractVisualLayerIDrawing(this.getModel().getVisual().getColored()){

            @Override
            public void draw(IGraphics g, Row row, double width, double height) {
                if (AbstractCartoPlotView.this.getModel().isPointGeometry()) {
                    Point2D mp = AbstractCartoPlotView.this.getPoint(row);
                    if (mp != null) {
                        g.setColor(AbstractCartoPlotView.this.getModel().getColoring().getColor(row));
                        int radius = 4;
                        g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)(radius * 2), (double)(radius * 2)));
                    }
                } else {
                    Shape mp = AbstractCartoPlotView.this.getShape(row);
                    if (mp != null) {
                        g.setColor(AbstractCartoPlotView.this.getModel().getColoring().getColor(row));
                        g.fillShape(mp);
                    }
                }
            }
        };
        AbstractVisualLayerIDrawing singleSelectedDrawing = new AbstractVisualLayerIDrawing(this.getModel().getVisual().getSingleSelected()){

            @Override
            public void draw(IGraphics g, Row row, double width, double height) {
                if (AbstractCartoPlotView.this.getModel().isPointGeometry()) {
                    Point2D mp = AbstractCartoPlotView.this.getPoint(row);
                    if (mp != null) {
                        g.setColor(((ColorTheme)AbstractCartoPlotView.this.getColorTheme().getValue()).getSelection());
                        int radius = 6;
                        g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)(radius * 2), (double)(radius * 2)));
                    }
                } else {
                    Shape mp = AbstractCartoPlotView.this.getShape(row);
                    if (mp != null) {
                        g.setColor(((ColorTheme)AbstractCartoPlotView.this.getColorTheme().getValue()).getSelection());
                        MutableProperty<Boolean> fillSelected = AbstractCartoPlotView.this.getModel().getFillSelected();
                        if (((Boolean)fillSelected.getValue()).booleanValue()) {
                            g.fillShape(mp);
                        } else {
                            g.drawShape(mp);
                        }
                    }
                }
            }
        };
        AbstractVisualLayerIDrawing multiSelectedDrawing = new AbstractVisualLayerIDrawing(this.getModel().getVisual().getMultipleSelected()){

            @Override
            public void draw(IGraphics g, Row row, double width, double height) {
                if (AbstractCartoPlotView.this.getModel().isPointGeometry()) {
                    Point2D mp = AbstractCartoPlotView.this.getPoint(row);
                    if (mp != null) {
                        g.setColor(((ColorTheme)AbstractCartoPlotView.this.getColorTheme().getValue()).getSelection());
                        int radius = 6;
                        g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)(radius * 2), (double)(radius * 2)));
                    }
                } else {
                    Shape mp = AbstractCartoPlotView.this.getShape(row);
                    if (mp != null) {
                        g.setColor(((ColorTheme)AbstractCartoPlotView.this.getColorTheme().getValue()).getSelection());
                        MutableProperty<Boolean> fillSelected = AbstractCartoPlotView.this.getModel().getFillSelected();
                        if (((Boolean)fillSelected.getValue()).booleanValue()) {
                            g.fillShape(mp);
                        } else {
                            g.drawShape(mp);
                        }
                    }
                }
            }
        };
        AbstractVisualLayerIDrawing probedDrawing = new AbstractVisualLayerIDrawing(this.getModel().getVisual().getProbed()){

            @Override
            public void draw(IGraphics g, Row row, double width, double height) {
                if (AbstractCartoPlotView.this.getModel().isPointGeometry()) {
                    Point2D mp = AbstractCartoPlotView.this.getPoint(row);
                    if (mp != null) {
                        g.setColor(((ColorTheme)AbstractCartoPlotView.this.getColorTheme().getValue()).getProbing());
                        int radius = 6;
                        g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)(radius * 2), (double)(radius * 2)));
                        if (AbstractCartoPlotView.this.getModel().getSelection().isSelected(row)) {
                            g.setColor(((ColorTheme)AbstractCartoPlotView.this.getColorTheme().getValue()).getSelection());
                            radius = 4;
                            g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - (double)radius, mp.getY() - (double)radius, (double)(radius * 2), (double)(radius * 2)));
                        }
                    }
                } else {
                    Shape mp = AbstractCartoPlotView.this.getShape(row);
                    if (mp != null) {
                        MutableProperty<Boolean> fillSelected = AbstractCartoPlotView.this.getModel().getFillSelected();
                        if (((Boolean)fillSelected.getValue()).booleanValue()) {
                            if (AbstractCartoPlotView.this.getModel().getSelection().isSelected(row)) {
                                g.setColor(((ColorTheme)AbstractCartoPlotView.this.getColorTheme().getValue()).getSelection());
                                g.fillShape(mp);
                            }
                            g.setColor(((ColorTheme)AbstractCartoPlotView.this.getColorTheme().getValue()).getProbing());
                            g.drawShape(mp);
                        } else if (AbstractCartoPlotView.this.getModel().getSelection().isSelected(row)) {
                            g.setLineWidth(3.0);
                            g.setColor(((ColorTheme)AbstractCartoPlotView.this.getColorTheme().getValue()).getProbing());
                            g.drawShape(mp);
                            g.setLineWidth(1.0);
                            g.setColor(((ColorTheme)AbstractCartoPlotView.this.getColorTheme().getValue()).getSelection());
                            g.drawShape(mp);
                        } else {
                            g.setColor(((ColorTheme)AbstractCartoPlotView.this.getColorTheme().getValue()).getProbing());
                            g.drawShape(mp);
                        }
                    }
                }
            }
        };
        this.canvas.addDensityLayer((CPCanvas.Rendering)this.getRendering().getValue(), (IDrawing)filteredDrawing, (Pressure)new LinearPressure(), new CPCanvas.PaletteProvider(){

            public FixedPalette getPalette() {
                return ((ColorTheme)AbstractCartoPlotView.this.getColorTheme().getValue()).getGhostedPalette();
            }
        });
        this.canvas.addDensityLayer((CPCanvas.Rendering)this.getRendering().getValue(), (IDrawing)visibleDrawing, (Pressure)new LinearPressure(), new CPCanvas.PaletteProvider(){

            public FixedPalette getPalette() {
                return ((ColorTheme)AbstractCartoPlotView.this.getColorTheme().getValue()).getVisiblePalette();
            }
        });
        this.canvas.addAveragingLayer((CPCanvas.Rendering)this.getRendering().getValue(), (IDrawing)colorMappedDrawing);
        this.canvas.addBufferedLayer((IDrawing)coloredDrawing);
        this.canvas.addBufferedLayer((IDrawing)multiSelectedDrawing);
        this.canvas.addLayer((IDrawing)singleSelectedDrawing);
        this.canvas.addLayer((IDrawing)probedDrawing);
        this.canvas.addLayer((IDrawing)new RubberbandDrawing(this.getRubberBand()));
    }

    protected Point2D getPoint(Row row) {
        Geometry geometry = this.getModel().getGeometry(row);
        return this.getPoint(geometry);
    }

    public Point2D getPoint(Geometry geometry) {
        if (geometry != null) {
            double y = geometry.getCentroid().getY();
            y = AbstractCartoPlotView.lat2y(y);
            return new Point2D.Double((double)this.screenTransform.getX().worldToScreen(geometry.getCentroid().getX()), (double)this.screenTransform.getY().worldToScreen(y));
        }
        return null;
    }

    protected Shape getShape(Row row) {
        Geometry geometry = this.getModel().getGeometry(row);
        return this.getShape(geometry);
    }

    public Shape getShape(Geometry geometry) {
        if (geometry != null) {
            Shape shape = this.converter.toShape(geometry);
            return shape;
        }
        return null;
    }

    @Override
    public void addMouseListener(CPCanvas.MouseListener l) {
        this.canvas.addMouseListener(l);
    }

    @Override
    public void addMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.canvas.addMouseMotionListener(l);
    }

    @Override
    public void addMouseWheelListener(CPCanvas.MouseWheelListener l) {
        this.canvas.addMouseWheelListener(l);
    }

    @Override
    public void addKeyListener(CPCanvas.KeyListener listener) {
        this.canvas.addKeyListener(listener);
    }

    private class RubberbandDrawing
    extends AbstractIDrawing {
        private final SingleSelection<Rectangle2D> rubberband;
        final SingleSelectionListener<Rectangle2D> rubberbandListener = new SingleSelectionListener<Rectangle2D>(){

            public void selectionChanged(SingleSelectionEvent<Rectangle2D> event) {
                RubberbandDrawing.this.notifyIDrawingChanged();
            }
        };

        public RubberbandDrawing(SingleSelection<Rectangle2D> rubberband) {
            this.rubberband = rubberband;
            rubberband.addSingleSelectionListener(this.rubberbandListener);
        }

        public boolean isActive() {
            return this.rubberband.isActive();
        }

        public void draw(IGraphics g, Point2D point, double width, double height, Rectangle clipBounds) {
            float[] dashPattern = new float[]{10.0f, 2.0f, 2.0f, 2.0f};
            g.setLineWidth(1.0);
            g.setLineDash(dashPattern);
            if (((ColorTheme)AbstractCartoPlotView.this.getColorTheme().getValue()).isDark()) {
                g.setColor(AbstractCartoPlotView.this.factory.createRGBAColor(255, 255, 255, 220));
            } else {
                g.setColor(AbstractCartoPlotView.this.factory.createRGBAColor(0, 0, 0, 220));
            }
            g.drawShape((Shape)AbstractCartoPlotView.this.getRubberBandScreen());
        }
    }

    public abstract class AbstractVisualLayerIDrawing
    extends AbstractIDrawing {
        private final VisualLayer<Row> visualLayer;

        protected AbstractVisualLayerIDrawing(VisualLayer<Row> visualLayer) {
            this.visualLayer = visualLayer;
            visualLayer.addVisualListener(new VisualListener(){

                public void visualChanged() {
                    AbstractVisualLayerIDrawing.this.notifyIDrawingChanged();
                }
            });
        }

        public boolean isActive() {
            return this.visualLayer.isActive();
        }

        public void draw(IGraphics g, Point2D point, double gw, double gh, Rectangle clipBounds) {
            if (this.visualLayer.getObjectCount() > 0) {
                for (Object row : this.visualLayer) {
                    this.draw(g, row, gw, gh);
                }
            }
        }

        public abstract void draw(IGraphics var1, Row var2, double var3, double var5);
    }
}

