/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.georeferencing;

import com.macrofocus.cartoplot.georeferencing.AbstractGeoReferencingService;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.molap.dataframe.DataFrame;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class LatLonGeoReferencingService<Component, R, C>
extends AbstractGeoReferencingService<Component, R> {
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private DataFrame dataFrame;
    private C latIndex = null;
    private C lonIndex = null;

    public LatLonGeoReferencingService(CPFactory factory, DataFrame<R, C, ?> dataFrame) {
        this.dataFrame = dataFrame;
        if (dataFrame != null) {
            String name;
            for (Object c : dataFrame.columns()) {
                if (!factory.isNumericType(dataFrame.getColumnClass(c))) continue;
                name = dataFrame.getColumnName(c);
                if ("Longitude".equalsIgnoreCase(name) || "Lon".equalsIgnoreCase(name)) {
                    this.lonIndex = c;
                }
                if ("Latitude".equalsIgnoreCase(name) || "Lat".equalsIgnoreCase(name)) {
                    this.latIndex = c;
                }
                if (this.latIndex == null || this.lonIndex == null) continue;
                break;
            }
            if (this.lonIndex == null || this.latIndex == null) {
                for (Object c : dataFrame.columns()) {
                    name = dataFrame.getColumnName(c);
                    if (name.toLowerCase().contains("longitude") || name.toLowerCase().startsWith("lon")) {
                        this.lonIndex = c;
                    }
                    if (name.toLowerCase().contains("latitude") || name.toLowerCase().startsWith("lat")) {
                        this.latIndex = c;
                    }
                    if (this.latIndex == null || this.lonIndex == null) continue;
                    break;
                }
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.latIndex != null && this.lonIndex != null;
    }

    @Override
    public Component getEditor() {
        return null;
    }

    @Override
    public boolean isPointGeometry() {
        return true;
    }

    @Override
    public Geometry getGeometry(R row) {
        if (this.latIndex != null && this.lonIndex != null) {
            Object lonValue = this.dataFrame.getValueAt(row, this.lonIndex);
            Object latValue = this.dataFrame.getValueAt(row, this.latIndex);
            if (lonValue != null && latValue != null && lonValue instanceof Number && latValue instanceof Number) {
                Number lon = (Number)lonValue;
                Number lat = (Number)latValue;
                return this.geometryFactory.createPoint(new Coordinate(lon.doubleValue(), lat.doubleValue()));
            }
        }
        return null;
    }

    public C getLatIndex() {
        return this.latIndex;
    }

    public void setLatIndex(C latIndex) {
        if (this.latIndex != latIndex) {
            C old = this.latIndex;
            this.latIndex = latIndex;
            this.notififyGeoReferencingServiceChanged();
        }
    }

    public C getLonIndex() {
        return this.lonIndex;
    }

    public void setLonIndex(C lonIndex) {
        if (this.lonIndex != lonIndex) {
            C old = this.lonIndex;
            this.lonIndex = lonIndex;
            this.notififyGeoReferencingServiceChanged();
        }
    }

    public String toString() {
        return "Latitude/Longitude";
    }
}

